/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.NativeTradeItem;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;

public class NativeTrade
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(NativeTrade.class.getName());
    public static final String TAG = "nativeTrade";
    private static final StringTemplate abortTrade = StringTemplate.template("");
    private Unit unit;
    private IndianSettlement is;
    private int count;
    private boolean buy;
    private boolean sell;
    private boolean gift;
    private NativeTradeItem item;
    private List<NativeTradeItem> unitToSettlement = new ArrayList<NativeTradeItem>();
    private List<NativeTradeItem> settlementToUnit = new ArrayList<NativeTradeItem>();
    private static final String BUY_TAG = "buy";
    private static final String COUNT_TAG = "count";
    private static final String GIFT_TAG = "gift";
    private static final String SELL_TAG = "sell";
    private static final String SETTLEMENT_TAG = "settlement";
    private static final String SETTLEMENT_TO_UNIT_TAG = "settlementToUnit";
    private static final String UNIT_TAG = "unit";
    private static final String UNIT_TO_SETTLEMENT_TAG = "unitToSettlement";

    public NativeTrade(Game game, String id) {
        super(game, id);
    }

    public NativeTrade(Unit unit, IndianSettlement is) {
        this(unit.getGame(), "");
        this.unit = unit;
        this.is = is;
        this.count = 0;
        this.gift = true;
        this.sell = true;
        this.buy = true;
    }

    private boolean atWar() {
        return this.is.getOwner().atWarWith(this.unit.getOwner());
    }

    public String getKey() {
        return NativeTrade.getNativeTradeKey(this.unit, this.is);
    }

    public static String getNativeTradeKey(Unit unit, IndianSettlement is) {
        return unit.getId() + "-" + is.getId();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public IndianSettlement getIndianSettlement() {
        return this.is;
    }

    public boolean getBuy() {
        return this.buy;
    }

    public boolean canBuy() {
        return this.getBuy() && !this.atWar() && this.unit.getSpaceLeft() > 0 && CollectionUtils.any(this.getSettlementToUnit(), NativeTradeItem::priceIsValid);
    }

    public void setBuy(boolean buy) {
        this.buy = buy;
    }

    public boolean getSell() {
        return this.sell;
    }

    public boolean canSell() {
        return this.getSell() && !this.atWar() && CollectionUtils.any(this.getUnitToSettlement(), NativeTradeItem::priceIsValid);
    }

    public void setSell(boolean sell) {
        this.sell = sell;
    }

    public boolean getGift() {
        return this.gift;
    }

    public boolean canGift() {
        return this.getGift() && this.unit.hasGoodsCargo();
    }

    public void setGift(boolean gift) {
        this.gift = gift;
    }

    public boolean hasNotTraded() {
        return this.getBuy() && this.getSell() && this.getGift();
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean getDone() {
        return this.count < 0 || !this.canBuy() && !this.canSell() && !this.canGift();
    }

    public void setDone() {
        this.count = -1;
    }

    public NativeTradeItem getItem() {
        return this.item;
    }

    public void setItem(NativeTradeItem nti) {
        this.item = nti;
    }

    public List<NativeTradeItem> getUnitToSettlement() {
        return this.unitToSettlement;
    }

    public List<NativeTradeItem> getSettlementToUnit() {
        return this.settlementToUnit;
    }

    public void addToUnit(NativeTradeItem nti) {
        this.unitToSettlement.add(nti);
    }

    public void removeFromUnit(NativeTradeItem nti) {
        CollectionUtils.removeInPlace(this.unitToSettlement, nti.goodsMatcher());
    }

    public boolean isCompatible(NativeTrade nt) {
        return this.getKey().equals(nt.getKey());
    }

    public void initialize() {
        Player unitPlayer = this.unit.getOwner();
        Player settlementPlayer = this.is.getOwner();
        Game game = this.unit.getGame();
        for (Goods g : this.unit.getGoodsList()) {
            this.unitToSettlement.add(new NativeTradeItem(game, unitPlayer, settlementPlayer, g));
        }
        for (Goods g : this.is.getSellGoods(this.unit)) {
            this.settlementToUnit.add(new NativeTradeItem(game, settlementPlayer, unitPlayer, g));
        }
    }

    public void mergeFrom(NativeTrade nt) {
        if (this.isCompatible(nt) && !this.equals(nt)) {
            this.unitToSettlement.clear();
            this.unitToSettlement.addAll(nt.getUnitToSettlement());
            this.settlementToUnit.clear();
            this.settlementToUnit.addAll(nt.getSettlementToUnit());
            this.item = nt.getItem();
        }
    }

    public void limitSettlementToUnit(int n) {
        List<NativeTradeItem> best = CollectionUtils.transform(this.settlementToUnit, NativeTradeItem::priceIsValid, Function.identity(), NativeTradeItem.descendingPriceComparator);
        if (best.size() <= n) {
            return;
        }
        for (NativeTradeItem nti : best.subList(n, best.size())) {
            nti.setPrice(-1);
        }
    }

    public static int haggleUp(int price) {
        return price * 11 / 10;
    }

    public static int haggleDown(int price) {
        return price * 9 / 10;
    }

    @Override
    public boolean isInternable() {
        return false;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        NativeTrade o = this.copyInCast(other, NativeTrade.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.unit = game.updateRef(o.getUnit());
        this.is = game.updateRef(o.getIndianSettlement());
        this.count = o.getCount();
        this.buy = o.getBuy();
        this.sell = o.getSell();
        this.gift = o.getGift();
        this.item = game.update(o.getItem(), false);
        this.unitToSettlement = game.update(o.getUnitToSettlement(), false);
        this.settlementToUnit = game.update(o.getSettlementToUnit(), false);
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(BUY_TAG, this.buy);
        xw.writeAttribute(COUNT_TAG, this.count);
        xw.writeAttribute(GIFT_TAG, this.gift);
        xw.writeAttribute(SELL_TAG, this.sell);
        xw.writeAttribute(SETTLEMENT_TAG, this.is);
        xw.writeAttribute(UNIT_TAG, this.unit);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        xw.writeStartElement(SETTLEMENT_TO_UNIT_TAG);
        for (NativeTradeItem nti : this.settlementToUnit) {
            nti.toXML(xw);
        }
        xw.writeEndElement();
        xw.writeStartElement(UNIT_TO_SETTLEMENT_TAG);
        for (NativeTradeItem nti : this.unitToSettlement) {
            nti.toXML(xw);
        }
        xw.writeEndElement();
        if (this.item != null) {
            this.item.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        super.readAttributes(xr);
        this.buy = xr.getAttribute(BUY_TAG, false);
        this.count = xr.getAttribute(COUNT_TAG, -1);
        this.gift = xr.getAttribute(GIFT_TAG, false);
        this.sell = xr.getAttribute(SELL_TAG, false);
        this.is = xr.getAttribute(game, SETTLEMENT_TAG, IndianSettlement.class, (IndianSettlement)null);
        this.unit = xr.getAttribute(game, UNIT_TAG, Unit.class, (Unit)null);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.unitToSettlement.clear();
        this.settlementToUnit.clear();
        this.item = null;
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        Game game = this.getGame();
        if (SETTLEMENT_TO_UNIT_TAG.equals(tag)) {
            while (xr.moreTags()) {
                tag = xr.getLocalName();
                if ("nativeTradeItem".equals(tag)) {
                    this.settlementToUnit.add(new NativeTradeItem(game, xr));
                    continue;
                }
                logger.warning("SettlementToUnit-item expected, not: " + tag);
            }
        } else if (UNIT_TO_SETTLEMENT_TAG.equals(tag)) {
            while (xr.moreTags()) {
                tag = xr.getLocalName();
                if ("nativeTradeItem".equals(tag)) {
                    this.unitToSettlement.add(new NativeTradeItem(game, xr));
                    continue;
                }
                logger.warning("UnitToSettlement-item expected, not: " + tag);
            }
        } else if ("nativeTradeItem".equals(tag)) {
            this.item = new NativeTradeItem(game, xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        NativeTradeItem item = this.getItem();
        sb.append('[').append(TAG).append(' ').append(this.getUnit().getId()).append(' ').append(this.getIndianSettlement().getId()).append(" buy=").append(this.getBuy()).append(" sell=").append(this.getSell()).append(" gift=").append(this.getGift()).append(" count=").append(this.getCount()).append(" item=").append(item == null ? "null" : item.toString()).append(" unitToSettlement[");
        for (NativeTradeItem nti : this.unitToSettlement) {
            sb.append(' ').append(nti);
        }
        sb.append("] settlementToUnit[");
        for (NativeTradeItem nti : this.settlementToUnit) {
            sb.append(' ').append(nti);
        }
        return sb.append(" ]]").toString();
    }

    public static enum NativeTradeAction {
        OPEN(false, true),
        CLOSE(true, true),
        BUY(false, true),
        SELL(false, true),
        GIFT(false, true),
        ACK_OPEN(false, false),
        ACK_BUY(false, false),
        ACK_SELL(false, false),
        ACK_GIFT(false, false),
        ACK_BUY_HAGGLE(false, false),
        ACK_SELL_HAGGLE(false, false),
        NAK_GOODS(false, false),
        NAK_HAGGLE(true, false),
        NAK_HOSTILE(true, false),
        NAK_NOSALE(true, false),
        NAK_INVALID(true, false);

        private final boolean closing;
        private final boolean fromEuropeans;

        private NativeTradeAction(boolean closing, boolean fromEuropeans) {
            this.closing = closing;
            this.fromEuropeans = fromEuropeans;
        }

        public boolean isClosing() {
            return this.closing;
        }

        public boolean isEuropean() {
            return this.fromEuropeans;
        }
    }
}

