/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class MovementTest
extends FreeColTestCase {
    private static final TileImprovementType riverType = MovementTest.spec().getTileImprovementType("model.improvement.river");
    private static final TileImprovementType roadType = MovementTest.spec().getTileImprovementType("model.improvement.road");
    private static final TileType hills = MovementTest.spec().getTileType("model.tile.hills");
    private static final TileType ocean = MovementTest.spec().getTileType("model.tile.ocean");
    private static final TileType plains = MovementTest.spec().getTileType("model.tile.plains");
    private static final Role armedBraveRole = MovementTest.spec().getRole("model.role.armedBrave");
    private static final Role dragoonRole = MovementTest.spec().getRole("model.role.dragoon");
    private static final Role missionaryRole = MovementTest.spec().getRole("model.role.missionary");
    private static final Role mountedBraveRole = MovementTest.spec().getRole("model.role.mountedBrave");
    private static final Role nativeDragoonRole = MovementTest.spec().getRole("model.role.nativeDragoon");
    private static final Role pioneerRole = MovementTest.spec().getRole("model.role.pioneer");
    private static final Role scoutRole = MovementTest.spec().getRole("model.role.scout");
    private static final Role soldierRole = MovementTest.spec().getRole("model.role.soldier");
    private static final UnitType braveType = MovementTest.spec().getUnitType("model.unit.brave");
    private static final UnitType colonistType = MovementTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType galleonType = MovementTest.spec().getUnitType("model.unit.galleon");

    public void testMoveFromPlainsToPlains() throws Exception {
        Game game = MovementTest.getStandardGame();
        Map map = MovementTest.getTestMap(plains);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        tile1.setExplored(dutch, true);
        tile2.setExplored(dutch, true);
        ServerUnit colonist = new ServerUnit(game, tile1, dutch, colonistType);
        int moveCost = plains.getBasicMoveCost();
        MovementTest.assertEquals((int)moveCost, (int)colonist.getMoveCost(tile2));
        MovementTest.assertEquals((int)Math.min(moveCost, colonistType.getMovement()), (int)colonist.getMoveCost(tile2));
        MovementTest.assertTrue((String)"No improvements", (boolean)tile2.getTileImprovements().isEmpty());
        TileImprovement ti = new TileImprovement(game, tile2, MovementTest.spec().getTileImprovementType("model.improvement.plow"), null);
        ti.setTurnsToComplete(0);
        tile2.add(ti);
        MovementTest.assertTrue((String)"Plowed", (tile2.getCompleteTileImprovements().size() == 1 ? 1 : 0) != 0);
        MovementTest.assertEquals((int)moveCost, (int)colonist.getMoveCost(tile2));
        MovementTest.assertEquals((int)Math.min(moveCost, colonistType.getMovement()), (int)colonist.getMoveCost(tile2));
    }

    public void testMoveFromPlainsToHills() throws Exception {
        Game game = MovementTest.getStandardGame();
        Map map = MovementTest.getTestMap(plains);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        tile2.setType(hills);
        tile1.setExplored(dutch, true);
        tile2.setExplored(dutch, true);
        ServerUnit colonist = new ServerUnit(game, tile1, dutch, colonistType);
        int moveCost = hills.getBasicMoveCost();
        MovementTest.assertTrue((moveCost > colonist.getMovesLeft() ? 1 : 0) != 0);
        MovementTest.assertEquals((int)Math.min(moveCost, colonistType.getMovement()), (int)colonist.getMoveCost(tile2));
    }

    public void testMoveAlongRoad() throws Exception {
        Game game = MovementTest.getStandardGame();
        Map map = MovementTest.getTestMap(plains);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        tile1.setExplored(dutch, true);
        tile2.setExplored(dutch, true);
        TileImprovement road1 = tile1.addRoad();
        MovementTest.assertTrue((boolean)road1.isRoad());
        MovementTest.assertFalse((boolean)road1.isComplete());
        road1.setTurnsToComplete(0);
        MovementTest.assertTrue((boolean)road1.isComplete());
        road1.updateRoadConnections(true);
        MovementTest.assertEquals((Object)road1, (Object)tile1.getRoad());
        TileImprovement road2 = tile2.addRoad();
        road2.setTurnsToComplete(0);
        road2.updateRoadConnections(true);
        MovementTest.assertTrue((boolean)road2.isComplete());
        MovementTest.assertEquals((Object)road2, (Object)tile2.getRoad());
        MovementTest.assertTrue((boolean)road1.isConnectedTo(tile1.getDirection(tile2)));
        MovementTest.assertTrue((boolean)road2.isConnectedTo(tile2.getDirection(tile1)));
        ServerUnit colonist = new ServerUnit(game, tile1, dutch, colonistType);
        int moveCost = 1;
        MovementTest.assertEquals((int)moveCost, (int)colonist.getMoveCost(tile2));
        MovementTest.assertEquals((int)Math.min(moveCost, colonistType.getMovement()), (int)colonist.getMoveCost(tile2));
    }

    public void testMoveAlongRiver() throws Exception {
        Game game = MovementTest.getStandardGame();
        Map map = MovementTest.getTestMap(ocean);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = tile1.getNeighbourOrNull(Direction.NE);
        tile1.setType(plains);
        tile2.setType(plains);
        tile1.setExplored(dutch, true);
        tile2.setExplored(dutch, true);
        MovementTest.assertEquals((Object)Direction.NE, (Object)map.getDirection(tile1, tile2));
        MovementTest.assertEquals((Object)Direction.SW, (Object)map.getDirection(tile2, tile1));
        TileImprovement river1 = tile1.addRiver(1, "0101");
        MovementTest.assertTrue((boolean)river1.isRiver());
        MovementTest.assertTrue((boolean)river1.isComplete());
        MovementTest.assertTrue((boolean)tile1.hasRiver());
        TileImprovement river2 = tile2.addRiver(1, "0101");
        MovementTest.assertTrue((boolean)river2.isRiver());
        MovementTest.assertTrue((boolean)river2.isComplete());
        MovementTest.assertTrue((boolean)tile2.hasRiver());
        MovementTest.assertFalse((boolean)river1.isConnectedTo(Direction.NE));
        MovementTest.assertTrue((boolean)river1.isConnectedTo(Direction.SE));
        MovementTest.assertFalse((boolean)river1.isConnectedTo(Direction.SW));
        MovementTest.assertTrue((boolean)river1.isConnectedTo(Direction.NW));
        MovementTest.assertFalse((boolean)river2.isConnectedTo(Direction.NE));
        MovementTest.assertTrue((boolean)river2.isConnectedTo(Direction.SE));
        MovementTest.assertFalse((boolean)river2.isConnectedTo(Direction.SW));
        MovementTest.assertTrue((boolean)river2.isConnectedTo(Direction.NW));
        ServerUnit colonist = new ServerUnit(game, tile1, dutch, colonistType);
        int moveCost = 3;
        MovementTest.assertEquals((int)moveCost, (int)colonist.getMoveCost(tile2));
        MovementTest.assertEquals((int)Math.min(moveCost, colonistType.getMovement()), (int)colonist.getMoveCost(tile2));
        river1.updateRiverConnections("1000");
        river2.updateRiverConnections("0010");
        MovementTest.assertTrue((boolean)river1.isConnectedTo(Direction.NE));
        MovementTest.assertFalse((boolean)river1.isConnectedTo(Direction.SE));
        MovementTest.assertFalse((boolean)river1.isConnectedTo(Direction.SW));
        MovementTest.assertFalse((boolean)river1.isConnectedTo(Direction.NW));
        MovementTest.assertFalse((boolean)river2.isConnectedTo(Direction.NE));
        MovementTest.assertFalse((boolean)river2.isConnectedTo(Direction.SE));
        MovementTest.assertTrue((boolean)river2.isConnectedTo(Direction.SW));
        MovementTest.assertFalse((boolean)river2.isConnectedTo(Direction.NW));
        moveCost = 1;
        MovementTest.assertEquals((int)moveCost, (int)colonist.getMoveCost(tile2));
        MovementTest.assertEquals((int)Math.min(moveCost, colonistType.getMovement()), (int)colonist.getMoveCost(tile2));
    }

    public void testScoutColony() {
        Game game = MovementTest.getGame();
        Map map = MovementTest.getTestMap(true);
        game.changeMap(map);
        Player french = game.getPlayerByNationId("model.nation.french");
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player iroquois = game.getPlayerByNationId("model.nation.iroquois");
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        Tile tile3 = map.getTile(6, 8);
        tile1.setExplored(french, true);
        tile2.setExplored(french, true);
        tile3.setExplored(french, true);
        tile1.setExplored(dutch, true);
        tile2.setExplored(dutch, true);
        tile3.setExplored(dutch, true);
        Colony colony = this.getStandardColony();
        MovementTest.assertEquals((Object)tile1.getColony(), (Object)colony);
        ServerUnit colonist = new ServerUnit(game, tile2, french, colonistType);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.MOVE_NO_ACCESS_SETTLEMENT), (Object)((Object)colonist.getMoveType(tile1)));
        colonist.setRole(pioneerRole);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.MOVE_NO_ACCESS_SETTLEMENT), (Object)((Object)colonist.getMoveType(tile1)));
        colonist.setRole(missionaryRole);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.MOVE_NO_ACCESS_SETTLEMENT), (Object)((Object)colonist.getMoveType(tile1)));
        colonist.setRole(scoutRole);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT), (Object)((Object)colonist.getMoveType(tile1)));
        colonist.setRole(soldierRole);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)colonist.getMoveType(tile1)));
        colonist.setRole(dragoonRole);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)colonist.getMoveType(tile1)));
        ServerUnit brave = new ServerUnit(game, tile3, iroquois, braveType);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)brave.getMoveType(tile1)));
        brave.setRole(mountedBraveRole);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)brave.getMoveType(tile1)));
        brave.setRole(armedBraveRole);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)brave.getMoveType(tile1)));
        brave.setRole(nativeDragoonRole);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)brave.getMoveType(tile1)));
    }

    public void testScoutIndianSettlement() {
        Game game = MovementTest.getStandardGame();
        Map map = MovementTest.getTestMap(plains);
        game.changeMap(map);
        Player french = game.getPlayerByNationId("model.nation.french");
        Player inca = game.getPlayerByNationId("model.nation.inca");
        Player iroquois = game.getPlayerByNationId("model.nation.iroquois");
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        Tile tile3 = map.getTile(6, 8);
        tile1.setExplored(french, true);
        tile2.setExplored(french, true);
        tile3.setExplored(french, true);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        builder.player(inca).settlementTile(tile1).skillToTeach(null).build();
        ServerUnit colonist = new ServerUnit(game, tile2, french, colonistType);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.MOVE_NO_ACCESS_CONTACT), (Object)((Object)colonist.getMoveType(tile1)));
        Player.makeContact(french, inca);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST), (Object)((Object)colonist.getMoveType(tile1)));
        colonist.setRole(MovementTest.spec().getRole("model.role.pioneer"));
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST), (Object)((Object)colonist.getMoveType(tile1)));
        colonist.setRole(MovementTest.spec().getRole("model.role.missionary"));
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY), (Object)((Object)colonist.getMoveType(tile1)));
        colonist.setRole(MovementTest.spec().getRole("model.role.scout"));
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT), (Object)((Object)colonist.getMoveType(tile1)));
        colonist.setRole(MovementTest.spec().getRole("model.role.soldier"));
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)colonist.getMoveType(tile1)));
        colonist.setRole(MovementTest.spec().getRole("model.role.dragoon"));
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)colonist.getMoveType(tile1)));
        ServerUnit brave = new ServerUnit(game, tile3, iroquois, braveType);
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)brave.getMoveType(tile1)));
        brave.setRole(MovementTest.spec().getRole("model.role.mountedBrave"));
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)brave.getMoveType(tile1)));
        brave.setRole(MovementTest.spec().getRole("model.role.armedBrave"));
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)brave.getMoveType(tile1)));
        brave.setRole(MovementTest.spec().getRole("model.role.nativeDragoon"));
        MovementTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_SETTLEMENT), (Object)((Object)brave.getMoveType(tile1)));
    }
}

