/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.util.test.FreeColTestCase;

public class ModifierTest
extends FreeColTestCase {
    private static final UnitType carpenter = ModifierTest.spec().getUnitType("model.unit.masterCarpenter");
    private static final UnitType frigate = ModifierTest.spec().getUnitType("model.unit.frigate");

    public void testAdditiveModifier() {
        Modifier modifier = new Modifier("test", 3.0f, Modifier.ModifierType.ADDITIVE);
        ModifierTest.spec().addModifier(modifier);
        ModifierTest.assertEquals((Object)Float.valueOf(4.0f), (Object)Float.valueOf(modifier.applyTo(1.0f)));
    }

    public void testMultiplicativeModifier() {
        Modifier modifier = new Modifier("test", 1.5f, Modifier.ModifierType.MULTIPLICATIVE);
        ModifierTest.spec().addModifier(modifier);
        ModifierTest.assertEquals((Object)Float.valueOf(1.5f), (Object)Float.valueOf(modifier.applyTo(1.0f)));
        ModifierTest.assertEquals((Object)Float.valueOf(4.5f), (Object)Float.valueOf(modifier.applyTo(3.0f)));
    }

    public void testPercentageModifier() {
        Modifier modifier = new Modifier("test", 50.0f, Modifier.ModifierType.PERCENTAGE);
        ModifierTest.spec().addModifier(modifier);
        ModifierTest.assertEquals((Object)Float.valueOf(150.0f), (Object)Float.valueOf(modifier.applyTo(100.0f)));
        ModifierTest.assertEquals((Object)Float.valueOf(4.5f), (Object)Float.valueOf(modifier.applyTo(3.0f)));
    }

    public void testCombineAdditiveModifiers() {
        Modifier modifier1 = new Modifier("test", 3.0f, Modifier.ModifierType.ADDITIVE);
        Modifier modifier2 = new Modifier("test", 4.0f, Modifier.ModifierType.ADDITIVE);
        HashSet<Modifier> modifierSet = new HashSet<Modifier>();
        modifierSet.add(modifier1);
        modifierSet.add(modifier2);
        ModifierTest.assertEquals((Object)Float.valueOf(8.0f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, null, modifierSet)));
    }

    public void testCombineMultiplicativeModifiers() {
        Modifier modifier1 = new Modifier("test", 3.0f, Modifier.ModifierType.MULTIPLICATIVE);
        Modifier modifier2 = new Modifier("test", 4.0f, Modifier.ModifierType.MULTIPLICATIVE);
        HashSet<Modifier> modifierSet = new HashSet<Modifier>();
        modifierSet.add(modifier1);
        modifierSet.add(modifier2);
        ModifierTest.assertEquals((Object)Float.valueOf(24.0f), (Object)Float.valueOf(FeatureContainer.applyModifiers(2.0f, null, modifierSet)));
    }

    public void testCombinePercentageModifiers() {
        Modifier modifier1 = new Modifier("test", 3.0f, Modifier.ModifierType.PERCENTAGE);
        Modifier modifier2 = new Modifier("test", 4.0f, Modifier.ModifierType.PERCENTAGE);
        HashSet<Modifier> modifierSet = new HashSet<Modifier>();
        modifierSet.add(modifier1);
        modifierSet.add(modifier2);
        ModifierTest.assertEquals((Object)Float.valueOf(107.12f), (Object)Float.valueOf(FeatureContainer.applyModifiers(100.0f, null, modifierSet)));
    }

    public void testCombinedModifier() {
        Modifier modifier1 = new Modifier("test", 3.0f, Modifier.ModifierType.ADDITIVE);
        Modifier modifier2 = new Modifier("test", 1.5f, Modifier.ModifierType.MULTIPLICATIVE);
        Modifier modifier3 = new Modifier("test", 50.0f, Modifier.ModifierType.PERCENTAGE);
        HashSet<Modifier> modifierSet = new HashSet<Modifier>();
        modifierSet.add(modifier1);
        modifierSet.add(modifier2);
        ModifierTest.assertEquals((Object)Float.valueOf(6.0f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, null, modifierSet)));
        modifierSet.add(modifier3);
        ModifierTest.assertEquals((Object)Float.valueOf(9.0f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, null, modifierSet)));
        modifierSet.remove(modifier1);
        ModifierTest.assertEquals((Object)Float.valueOf(22.5f), (Object)Float.valueOf(FeatureContainer.applyModifiers(10.0f, null, modifierSet)));
    }

    public void testScope() {
        Modifier modifier1 = new Modifier("test", 3.0f, Modifier.ModifierType.ADDITIVE);
        Modifier modifier2 = new Modifier("test", 1.5f, Modifier.ModifierType.MULTIPLICATIVE);
        Modifier modifier3 = new Modifier("test", 30.0f, Modifier.ModifierType.PERCENTAGE);
        FeatureContainer featureContainer = new FeatureContainer();
        featureContainer.addModifier(modifier1);
        featureContainer.addModifier(modifier2);
        featureContainer.addModifier(modifier3);
        Scope scope1 = new Scope();
        scope1.setType("model.unit.frigate");
        Scope scope2 = new Scope();
        scope2.setAbilityId("model.ability.navalUnit");
        scope2.setAbilityValue(false);
        Scope scope3 = new Scope();
        scope3.setMethodName("getLineOfSight");
        scope3.setMethodValue("2");
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        scopes.add(scope1);
        modifier1.copyScopes(scopes);
        ModifierTest.assertTrue((boolean)modifier1.appliesTo(frigate));
        ModifierTest.assertFalse((boolean)modifier1.appliesTo(carpenter));
        List<Modifier> result = CollectionUtils.toList(featureContainer.getModifiers("test", frigate, null));
        ModifierTest.assertEquals((int)3, (int)result.size());
        ModifierTest.assertEquals((Object)Float.valueOf(7.8f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, null, result)));
        result = CollectionUtils.toList(featureContainer.getModifiers("test", carpenter, null));
        ModifierTest.assertEquals((int)2, (int)result.size());
        ModifierTest.assertEquals((Object)Float.valueOf(1.95f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, null, result)));
        ArrayList<Scope> scopes2 = new ArrayList<Scope>();
        scopes2.add(scope2);
        scopes2.add(scope3);
        modifier2.copyScopes(scopes2);
        ModifierTest.assertTrue((boolean)modifier2.appliesTo(frigate));
        ModifierTest.assertTrue((boolean)modifier2.appliesTo(carpenter));
        result = CollectionUtils.toList(featureContainer.getModifiers("test", frigate, null));
        ModifierTest.assertEquals((int)3, (int)result.size());
        ModifierTest.assertEquals((Object)Float.valueOf(7.8f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, null, result)));
        result = CollectionUtils.toList(featureContainer.getModifiers("test", carpenter, null));
        ModifierTest.assertEquals((int)2, (int)result.size());
        ModifierTest.assertEquals((Object)Float.valueOf(1.95f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, null, result)));
    }

    public void testTimeLimits() {
        Modifier modifier1 = new Modifier("test", 1.0f, Modifier.ModifierType.ADDITIVE);
        Modifier modifier2 = new Modifier("test", 2.0f, Modifier.ModifierType.ADDITIVE);
        modifier1.setFirstTurn(new Turn(10));
        modifier1.setLastTurn(new Turn(30));
        modifier2.setFirstTurn(new Turn(20));
        modifier2.setLastTurn(new Turn(40));
        ModifierTest.assertTrue((boolean)modifier1.hasTimeLimit());
        ModifierTest.assertTrue((boolean)modifier2.hasTimeLimit());
        ModifierTest.assertFalse((boolean)modifier1.appliesTo(frigate, new Turn(5)));
        ModifierTest.assertFalse((boolean)modifier1.appliesTo(frigate, new Turn(35)));
        ModifierTest.assertFalse((boolean)modifier1.isOutOfDate(new Turn(25)));
        ModifierTest.assertTrue((boolean)modifier1.appliesTo(frigate, new Turn(25)));
        ModifierTest.assertFalse((boolean)modifier2.appliesTo(frigate, new Turn(5)));
        ModifierTest.assertFalse((boolean)modifier2.appliesTo(frigate, new Turn(5)));
        ModifierTest.assertFalse((boolean)modifier2.isOutOfDate(new Turn(25)));
        ModifierTest.assertTrue((boolean)modifier2.appliesTo(frigate, new Turn(25)));
        FeatureContainer featureContainer = new FeatureContainer();
        featureContainer.addModifier(modifier1);
        featureContainer.addModifier(modifier2);
        List<Modifier> modifiers = CollectionUtils.toList(featureContainer.getModifiers("test", frigate, new Turn(15)));
        ModifierTest.assertEquals((int)1, (int)modifiers.size());
        ModifierTest.assertEquals((Object)modifier1, (Object)CollectionUtils.first(modifiers));
        modifiers = CollectionUtils.toList(featureContainer.getModifiers("test", frigate, new Turn(35)));
        ModifierTest.assertEquals((int)1, (int)modifiers.size());
        ModifierTest.assertEquals((Object)modifier2, (Object)CollectionUtils.first(modifiers));
    }

    public void testIncrements() {
        Modifier modifier1 = new Modifier("test", 1.0f, Modifier.ModifierType.ADDITIVE);
        Modifier modifier2 = new Modifier("test", 2.0f, Modifier.ModifierType.ADDITIVE);
        modifier1.setIncrement(Modifier.ModifierType.ADDITIVE, 1.0f, new Turn(10), new Turn(15));
        ModifierTest.assertFalse((boolean)modifier1.appliesTo(frigate, new Turn(9)));
        ModifierTest.assertTrue((boolean)modifier1.appliesTo(frigate, new Turn(10)));
        ModifierTest.assertTrue((boolean)modifier1.hasIncrement());
        FeatureContainer featureContainer = new FeatureContainer();
        featureContainer.addModifier(modifier1);
        featureContainer.addModifier(modifier2);
        Turn turn = new Turn(9);
        ModifierTest.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, turn, featureContainer.getModifiers("test", frigate, turn))));
        turn = new Turn(10);
        ModifierTest.assertEquals((Object)Float.valueOf(4.0f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, turn, featureContainer.getModifiers("test", frigate, turn))));
        turn = new Turn(11);
        ModifierTest.assertEquals((Object)Float.valueOf(5.0f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, new Turn(11), featureContainer.getModifiers("test", frigate, turn))));
        turn = new Turn(15);
        ModifierTest.assertEquals((Object)Float.valueOf(9.0f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, turn, featureContainer.getModifiers("test", frigate, turn))));
        turn = new Turn(16);
        ModifierTest.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, turn, featureContainer.getModifiers("test", frigate, turn))));
    }

    public void testHashEquals() {
        Scope scope1 = new Scope();
        scope1.setType("model.unit.frigate");
        scope1.setAbilityId("whatever");
        Scope scope2 = new Scope();
        scope2.setType("model.unit.frigate");
        scope2.setAbilityId("whatever");
        Scope scope3 = new Scope();
        scope3.setType("model.unit.frigate");
        scope3.setAbilityId("whatever");
        scope3.setAbilityValue(false);
        ModifierTest.assertEquals((Object)scope1, (Object)scope1);
        ModifierTest.assertEquals((int)scope1.hashCode(), (int)scope1.hashCode());
        ModifierTest.assertEquals((Object)scope1, (Object)scope2);
        ModifierTest.assertEquals((int)scope1.hashCode(), (int)scope2.hashCode());
        ModifierTest.assertFalse((boolean)scope1.equals(scope3));
        ModifierTest.assertFalse((scope1.hashCode() == scope3.hashCode() ? 1 : 0) != 0);
        Modifier modifier1 = new Modifier("test", 3.0f, Modifier.ModifierType.ADDITIVE);
        Modifier modifier2 = new Modifier("test", 3.0f, Modifier.ModifierType.ADDITIVE);
        Modifier modifier3 = new Modifier("test", 2.0f, Modifier.ModifierType.ADDITIVE);
        ModifierTest.assertEquals((Object)modifier1, (Object)modifier1);
        ModifierTest.assertEquals((int)modifier1.hashCode(), (int)modifier1.hashCode());
        ModifierTest.assertEquals((Object)modifier1, (Object)modifier2);
        ModifierTest.assertEquals((int)modifier1.hashCode(), (int)modifier2.hashCode());
        ModifierTest.assertFalse((boolean)modifier1.equals(modifier3));
        ModifierTest.assertFalse((modifier1.hashCode() == modifier3.hashCode() ? 1 : 0) != 0);
        ArrayList<Scope> scopeList1 = new ArrayList<Scope>();
        scopeList1.add(scope1);
        scopeList1.add(scope3);
        ArrayList<Scope> scopeList2 = new ArrayList<Scope>();
        scopeList2.add(scope3);
        scopeList2.add(scope1);
        ArrayList<Scope> scopeList3 = new ArrayList<Scope>();
        scopeList3.add(scope1);
        scopeList3.add(scope2);
        modifier1.copyScopes(scopeList1);
        modifier2.copyScopes(scopeList1);
        ModifierTest.assertEquals((Object)modifier1, (Object)modifier1);
        ModifierTest.assertEquals((int)modifier1.hashCode(), (int)modifier1.hashCode());
        ModifierTest.assertEquals((Object)modifier1, (Object)modifier2);
        ModifierTest.assertEquals((int)modifier1.hashCode(), (int)modifier2.hashCode());
        ModifierTest.assertFalse((boolean)modifier1.equals(modifier3));
        ModifierTest.assertFalse((modifier1.hashCode() == modifier3.hashCode() ? 1 : 0) != 0);
        modifier2.copyScopes(scopeList2);
        ModifierTest.assertEquals((Object)modifier2, (Object)modifier2);
        ModifierTest.assertEquals((int)modifier2.hashCode(), (int)modifier2.hashCode());
        ModifierTest.assertEquals((Object)modifier1, (Object)modifier2);
        ModifierTest.assertEquals((int)modifier1.hashCode(), (int)modifier2.hashCode());
        ModifierTest.assertFalse((boolean)modifier2.equals(modifier3));
        ModifierTest.assertFalse((modifier2.hashCode() == modifier3.hashCode() ? 1 : 0) != 0);
        modifier2.copyScopes(scopeList3);
        ModifierTest.assertEquals((Object)modifier2, (Object)modifier2);
        ModifierTest.assertEquals((int)modifier2.hashCode(), (int)modifier2.hashCode());
        ModifierTest.assertFalse((boolean)modifier1.equals(modifier2));
        ModifierTest.assertFalse((modifier1.hashCode() == modifier2.hashCode() ? 1 : 0) != 0);
        ModifierTest.assertFalse((boolean)modifier2.equals(modifier3));
        ModifierTest.assertFalse((modifier2.hashCode() == modifier3.hashCode() ? 1 : 0) != 0);
    }

    public void testModifierUnknown() {
        Modifier modifier1 = new Modifier("test", 3.0f, Modifier.ModifierType.ADDITIVE);
        Modifier modifier2 = new Modifier("test", Float.MIN_VALUE, Modifier.ModifierType.MULTIPLICATIVE);
        Modifier modifier3 = new Modifier("test", 30.0f, Modifier.ModifierType.PERCENTAGE);
        FeatureContainer featureContainer = new FeatureContainer();
        featureContainer.addModifier(modifier1);
        featureContainer.addModifier(modifier2);
        featureContainer.addModifier(modifier3);
        Turn turn = new Turn(15);
        ModifierTest.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), (Object)Float.valueOf(FeatureContainer.applyModifiers(1.0f, turn, featureContainer.getModifiers("test", null, turn))));
    }
}

