/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.CollectionUtils;

public final class FeatureContainer {
    private static final Logger logger = Logger.getLogger(FeatureContainer.class.getName());
    private final Object abilitiesLock = new Object();
    private final Object modifiersLock = new Object();
    private Map<String, Set<Ability>> abilities = null;
    private Map<String, Set<Modifier>> modifiers = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean abilitiesPresent() {
        Object object = this.abilitiesLock;
        synchronized (object) {
            return this.abilities != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requireAbilities() {
        Object object = this.abilitiesLock;
        synchronized (object) {
            if (this.abilities == null) {
                this.abilities = new HashMap<String, Set<Ability>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modifiersPresent() {
        Object object = this.modifiersLock;
        synchronized (object) {
            return this.modifiers != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void requireModifiers() {
        Object object = this.modifiersLock;
        synchronized (object) {
            if (this.modifiers == null) {
                this.modifiers = new HashMap<String, Set<Modifier>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Ability> getAbilityValues() {
        HashSet<Ability> ret = new HashSet<Ability>();
        Object object = this.abilitiesLock;
        synchronized (object) {
            if (this.abilities != null) {
                for (Set<Ability> as : this.abilities.values()) {
                    ret.addAll(as);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Modifier> getModifierValues() {
        HashSet<Modifier> ret = new HashSet<Modifier>();
        Object object = this.modifiersLock;
        synchronized (object) {
            if (this.modifiers != null) {
                for (Set<Modifier> ms : this.modifiers.values()) {
                    ret.addAll(ms);
                }
            }
        }
        return ret;
    }

    public static boolean allAbilities(Stream<Ability> abilities) {
        boolean ret = false;
        for (Ability ability : CollectionUtils.iterable(abilities)) {
            if (!ability.getValue()) {
                return false;
            }
            ret = true;
        }
        return ret;
    }

    public boolean hasAbility(String id, FreeColSpecObjectType fcgot, Turn turn) {
        return FeatureContainer.allAbilities(this.getAbilities(id, fcgot, turn));
    }

    public boolean containsAbilityKey(String key) {
        return CollectionUtils.first(this.getAbilities(key, null, null)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Ability> getAbilities(String id, FreeColSpecObjectType fcgot, Turn turn) {
        HashSet<Ability> result = new HashSet<Ability>();
        if (this.abilitiesPresent()) {
            Object object = this.abilitiesLock;
            synchronized (object) {
                if (id == null) {
                    for (Set<Ability> aset : this.abilities.values()) {
                        result.addAll(aset);
                    }
                } else {
                    Set<Ability> aset = this.abilities.get(id);
                    if (aset != null) {
                        result.addAll(aset);
                    }
                }
            }
            CollectionUtils.removeInPlace(result, a -> !a.appliesTo(fcgot, turn));
        }
        return result.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAbility(Ability ability) {
        if (ability == null) {
            return false;
        }
        this.requireAbilities();
        Object object = this.abilitiesLock;
        synchronized (object) {
            Set<Ability> abilitySet = this.abilities.get(ability.getId());
            if (abilitySet == null) {
                abilitySet = new HashSet<Ability>();
                this.abilities.put(ability.getId(), abilitySet);
            }
            return abilitySet.add(ability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ability removeAbility(Ability ability) {
        if (ability == null || !this.abilitiesPresent()) {
            return null;
        }
        Object object = this.abilitiesLock;
        synchronized (object) {
            Set<Ability> abilitySet = this.abilities.get(ability.getId());
            return abilitySet == null || !abilitySet.remove(ability) ? null : ability;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAbilities(String id) {
        if (!this.abilitiesPresent()) {
            return;
        }
        Object object = this.abilitiesLock;
        synchronized (object) {
            this.abilities.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Modifier> getModifiers(String id, FreeColSpecObjectType fcgot, Turn turn) {
        if (!this.modifiersPresent()) {
            return Stream.empty();
        }
        HashSet<Modifier> mset = new HashSet<Modifier>();
        Object object = this.modifiersLock;
        synchronized (object) {
            if (id == null) {
                for (Set<Modifier> ms : this.modifiers.values()) {
                    mset.addAll(ms);
                }
            } else {
                Set<Modifier> ms = this.modifiers.get(id);
                if (ms != null) {
                    mset.addAll(ms);
                }
            }
        }
        CollectionUtils.removeInPlace(mset, m -> !m.appliesTo(fcgot, turn));
        return mset.isEmpty() ? Stream.empty() : mset.stream();
    }

    public static float applyModifiers(float number, Turn turn, Collection<Modifier> mods) {
        return mods == null || mods.isEmpty() ? number : FeatureContainer.applyModifiersInternal(number, turn, CollectionUtils.sort(mods, Modifier.ascendingModifierIndexComparator));
    }

    public static float applyModifiers(float number, Turn turn, Stream<Modifier> mods) {
        return mods == null ? number : FeatureContainer.applyModifiersInternal(number, turn, CollectionUtils.sort(mods, Modifier.ascendingModifierIndexComparator));
    }

    private static float applyModifiersInternal(float number, Turn turn, Collection<Modifier> mods) {
        float result = number;
        for (Modifier m : mods) {
            float value = m.getValue(turn);
            if (Float.compare(value, Float.MIN_VALUE) == 0) {
                return value;
            }
            result = m.apply(result, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addModifier(Modifier modifier) {
        if (modifier == null) {
            return false;
        }
        this.requireModifiers();
        Object object = this.modifiersLock;
        synchronized (object) {
            Set<Modifier> modifierSet = this.modifiers.get(modifier.getId());
            if (modifierSet == null) {
                modifierSet = new HashSet<Modifier>();
                this.modifiers.put(modifier.getId(), modifierSet);
            }
            return modifierSet.add(modifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Modifier removeModifier(Modifier modifier) {
        if (modifier == null || !this.modifiersPresent()) {
            return null;
        }
        Object object = this.modifiersLock;
        synchronized (object) {
            Set<Modifier> modifierSet = this.modifiers.get(modifier.getId());
            return modifierSet == null || !modifierSet.remove(modifier) ? null : modifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModifiers(String id) {
        if (!this.modifiersPresent()) {
            return;
        }
        Object object = this.modifiersLock;
        synchronized (object) {
            this.modifiers.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(FreeColObject fco) {
        Object object;
        FeatureContainer c = fco.getFeatureContainer();
        if (c == null) {
            return;
        }
        if (c.abilitiesPresent()) {
            HashMap<String, Set<Ability>> ca;
            this.requireAbilities();
            object = c.abilitiesLock;
            synchronized (object) {
                ca = new HashMap<String, Set<Ability>>(c.abilities);
            }
            object = this.abilitiesLock;
            synchronized (object) {
                CollectionUtils.forEachMapEntry(ca, e -> {
                    Set<Ability> abilitySet = this.abilities.get(e.getKey());
                    if (abilitySet == null) {
                        abilitySet = new HashSet<Ability>();
                        this.abilities.put((String)e.getKey(), abilitySet);
                    }
                    abilitySet.addAll((Collection)e.getValue());
                });
            }
        }
        if (c.modifiersPresent()) {
            HashMap<String, Set<Modifier>> cm;
            this.requireModifiers();
            object = c.modifiersLock;
            synchronized (object) {
                cm = new HashMap<String, Set<Modifier>>(c.modifiers);
            }
            object = this.modifiersLock;
            synchronized (object) {
                CollectionUtils.forEachMapEntry(cm, e -> {
                    Set<Modifier> modifierSet = this.modifiers.get(e.getKey());
                    if (modifierSet == null) {
                        modifierSet = new HashSet<Modifier>();
                        this.modifiers.put((String)e.getKey(), modifierSet);
                    }
                    modifierSet.addAll((Collection)e.getValue());
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatures(FreeColObject fco) {
        Object object;
        FeatureContainer c = fco.getFeatureContainer();
        if (c == null) {
            return;
        }
        if (this.abilitiesPresent() && c.abilitiesPresent()) {
            HashSet<String> ca = new HashSet<String>();
            object = c.abilitiesLock;
            synchronized (object) {
                ca.addAll(c.abilities.keySet());
            }
            object = this.abilitiesLock;
            synchronized (object) {
                for (String key : ca) {
                    Set<Ability> abilitySet = this.abilities.get(key);
                    if (abilitySet == null) continue;
                    for (Ability a : new HashSet<Ability>(abilitySet)) {
                        if (a.getSource() != fco) continue;
                        abilitySet.remove(a);
                    }
                }
            }
        }
        if (this.modifiersPresent() && c.modifiersPresent()) {
            HashSet<String> cm = new HashSet<String>();
            object = c.modifiersLock;
            synchronized (object) {
                cm.addAll(c.modifiers.keySet());
            }
            object = this.modifiersLock;
            synchronized (object) {
                for (String key : cm) {
                    Set<Modifier> modifierSet = this.modifiers.get(key);
                    if (modifierSet == null) continue;
                    for (Modifier m : new HashSet<Modifier>(modifierSet)) {
                        if (m.getSource() != fco) continue;
                        modifierSet.remove(m);
                    }
                }
            }
        }
    }

    public void copy(FeatureContainer other) {
        this.clear();
        if (other != null) {
            for (Ability a : other.getAbilityValues()) {
                this.addAbility(a);
            }
            for (Modifier m : other.getModifierValues()) {
                this.addModifier(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object;
        if (this.abilitiesPresent()) {
            object = this.abilitiesLock;
            synchronized (object) {
                this.abilities.clear();
            }
        }
        if (this.modifiersPresent()) {
            object = this.modifiersLock;
            synchronized (object) {
                this.modifiers.clear();
            }
        }
    }

    public void replaceSource(FreeColSpecObjectType oldSource, FreeColSpecObjectType newSource) {
        for (Ability ability : CollectionUtils.transform(this.getAbilities(null, null, null), a -> oldSource == null || a.getSource() == oldSource)) {
            this.removeAbility(ability);
            Ability newAbility = new Ability(ability);
            newAbility.setSource(newSource);
            this.addAbility(newAbility);
        }
        for (Modifier modifier : CollectionUtils.transform(this.getModifiers(null, null, null), m -> oldSource == null || m.getSource() == oldSource)) {
            this.removeModifier(modifier);
            Modifier mod = Modifier.makeModifier(modifier);
            mod.setSource(newSource);
            this.addModifier(mod);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("[FeatureContainer");
        int siz = sb.length();
        for (Ability ability : CollectionUtils.iterable(this.getAbilities(null, null, null))) {
            sb.append(' ').append(ability);
        }
        if (sb.length() > siz) {
            sb.insert(siz, " [abilities");
            sb.append(']');
        }
        siz = sb.length();
        for (Modifier modifier : CollectionUtils.iterable(this.getModifiers(null, null, null))) {
            sb.append(' ').append(modifier);
        }
        if (sb.length() > siz) {
            sb.insert(siz, "[modifiers");
            sb.append(']');
        }
        sb.append(']');
        return sb.toString();
    }
}

