/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaDetailPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaTreeItem;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.util.ImageUtils;

public class ConceptDetailPanel
extends FreeColPanel
implements ColopediaDetailPanel<String> {
    private static final String id = "colopediaAction." + ColopediaAction.PanelType.CONCEPTS.getKey();
    private static final String[] concepts = new String[]{"taxes", "efficiency", "education", "fortification", "independence", "ref", "interventionForce"};
    private static final Comparator<DefaultMutableTreeNode> nodeComparator = Comparator.comparing(tn -> ((ColopediaTreeItem)tn.getUserObject()).getText());
    private ColopediaPanel colopediaPanel;

    public ConceptDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient);
        this.colopediaPanel = colopediaPanel;
    }

    @Override
    public String getName() {
        return Messages.getName(id);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(this, id, this.getName(), null));
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(concepts.length);
        for (String concept : concepts) {
            String nodeId = "colopedia.concepts." + concept;
            String nodeName = Messages.getName(nodeId);
            BufferedImage image = ImageUtils.createCenteredImage(this.getImageLibrary().getColopediaConceptImage(), this.colopediaPanel.getListItemIconSize());
            nodes.add(new DefaultMutableTreeNode(new ColopediaTreeItem(this, nodeId, nodeName, new ImageIcon(image))));
        }
        Collections.sort(nodes, nodeComparator);
        for (DefaultMutableTreeNode n : nodes) {
            node.add(n);
        }
        root.add(node);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (ConceptDetailPanel.id.equals(id)) {
            return;
        }
        panel.setLayout(new MigLayout("wrap 1, center"));
        JLabel header = Utility.localizedHeaderLabel(Messages.nameKey(id), 10, Utility.FONTSPEC_SUBTITLE);
        panel.add((Component)header, "align center, wrap 20");
        ConceptEditorPane editorPane = new ConceptEditorPane(Messages.getDescription(id));
        editorPane.setFont(panel.getFont());
        editorPane.addHyperlinkListener(this.colopediaPanel);
        panel.add((Component)editorPane, "width 95%");
    }

    private static class ConceptEditorPane
    extends JEditorPane {
        public ConceptEditorPane(String text) {
            super("text/html", text);
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.setOpaque(false);
            this.setEditable(false);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D graphics2d = (Graphics2D)g;
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintComponent(graphics2d);
        }
    }
}

