/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.ResourceUtil;
import org.w3c.epubcheck.core.Checker;

public class OCFExtensionChecker
implements Checker {
    private final ValidationContext context;
    private final Report report;
    private final String extension;

    public OCFExtensionChecker(ValidationContext context) {
        this.context = context;
        this.report = context.report;
        this.extension = ResourceUtil.getExtension(context.path);
    }

    @Override
    public void check() {
        if (this.extension != null && !this.extension.equals("epub")) {
            if (this.extension.matches("[Ee][Pp][Uu][Bb]")) {
                this.report.message(MessageId.PKG_016, EPUBLocation.of(this.context), new Object[0]);
            } else if (this.context.version == EPUBVersion.VERSION_3) {
                this.report.message(MessageId.PKG_024, EPUBLocation.of(this.context).context(this.extension), new Object[0]);
            } else {
                this.report.message(MessageId.PKG_017, EPUBLocation.of(this.context).context(this.extension), new Object[0]);
            }
        }
    }
}

