/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonServiceException;
import java.util.Map;

public class AmazonS3Exception
extends AmazonServiceException {
    private static final long serialVersionUID = 7573680383273658477L;
    private String extendedRequestId;
    private Map<String, String> additionalDetails;
    private final String errorResponseXml;

    public AmazonS3Exception(String message) {
        super(message);
        this.errorResponseXml = null;
    }

    public AmazonS3Exception(String message, Exception cause) {
        super(message, cause);
        this.errorResponseXml = null;
    }

    public AmazonS3Exception(String message, String errorResponseXml) {
        super(message);
        if (errorResponseXml == null) {
            throw new IllegalArgumentException("Error Response XML cannot be null");
        }
        this.errorResponseXml = errorResponseXml;
    }

    public String getExtendedRequestId() {
        return this.extendedRequestId;
    }

    public void setExtendedRequestId(String extendedRequestId) {
        this.extendedRequestId = extendedRequestId;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(Map<String, String> additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public String toString() {
        return super.toString() + ", " + "S3 Extended Request ID: " + this.getExtendedRequestId();
    }

    public String getErrorResponseXml() {
        return this.errorResponseXml;
    }
}

