/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XPath2NodeFilter
implements NodeFilter {
    boolean hasUnionFilter;
    boolean hasSubtractFilter;
    boolean hasIntersectFilter;
    Set unionNodes;
    Set subtractNodes;
    Set intersectNodes;
    int inSubtract = -1;
    int inIntersect = -1;
    int inUnion = -1;

    XPath2NodeFilter(List list, List list2, List list3) {
        this.hasUnionFilter = !list.isEmpty();
        this.unionNodes = XPath2NodeFilter.convertNodeListToSet(list);
        this.hasSubtractFilter = !list2.isEmpty();
        this.subtractNodes = XPath2NodeFilter.convertNodeListToSet(list2);
        this.hasIntersectFilter = !list3.isEmpty();
        this.intersectNodes = XPath2NodeFilter.convertNodeListToSet(list3);
    }

    public int isNodeInclude(Node node) {
        int n = 1;
        if (this.hasSubtractFilter && XPath2NodeFilter.rooted(node, this.subtractNodes)) {
            n = -1;
        } else if (this.hasIntersectFilter && !XPath2NodeFilter.rooted(node, this.intersectNodes)) {
            n = 0;
        }
        if (n == 1) {
            return 1;
        }
        if (this.hasUnionFilter) {
            if (XPath2NodeFilter.rooted(node, this.unionNodes)) {
                return 1;
            }
            n = 0;
        }
        return n;
    }

    public int isNodeIncludeDO(Node node, int n) {
        int n2 = 1;
        if (this.hasSubtractFilter) {
            if (this.inSubtract == -1 || n <= this.inSubtract) {
                this.inSubtract = XPath2NodeFilter.inList(node, this.subtractNodes) ? n : -1;
            }
            if (this.inSubtract != -1) {
                n2 = -1;
            }
        }
        if (n2 != -1 && this.hasIntersectFilter && (this.inIntersect == -1 || n <= this.inIntersect)) {
            if (!XPath2NodeFilter.inList(node, this.intersectNodes)) {
                this.inIntersect = -1;
                n2 = 0;
            } else {
                this.inIntersect = n;
            }
        }
        if (n <= this.inUnion) {
            this.inUnion = -1;
        }
        if (n2 == 1) {
            return 1;
        }
        if (this.hasUnionFilter) {
            if (this.inUnion == -1 && XPath2NodeFilter.inList(node, this.unionNodes)) {
                this.inUnion = n;
            }
            if (this.inUnion != -1) {
                return 1;
            }
            n2 = 0;
        }
        return n2;
    }

    static boolean rooted(Node node, Set set) {
        if (set.isEmpty()) {
            return false;
        }
        if (set.contains(node)) {
            return true;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (!XMLUtils.isDescendantOrSelf(node2, node)) continue;
            return true;
        }
        return false;
    }

    static boolean inList(Node node, Set set) {
        return set.contains(node);
    }

    private static Set convertNodeListToSet(List list) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (int i = 0; i < list.size(); ++i) {
            NodeList nodeList = (NodeList)list.get(i);
            int n = nodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node node = nodeList.item(j);
                hashSet.add(node);
            }
        }
        return hashSet;
    }
}

