/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.MissingAtLeastOneArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AssignPrivateIPAddresses
extends BaseCmd {
    public static final String[] NETWORK_INTERFACE_DESC = new String[]{"The ID of the network interface to which the specified addresses", "will be assigned ."};
    public static final String[] SECONDARY_PRIVATE_IP_ADDRESS_COUNT_DESC = new String[]{"The number of secondary private IP addresses to be automatically", "assigned to the network interface."};
    public static final String[] SECONDARY_PRIVATE_IP_ADDRESS_DESC = new String[]{"The secondary private IP address to assign to the network ", "interface."};
    public static final String[] ALLOW_REASSIGNMENT_DESC = new String[]{"Specify whether IP addresses can be reassigned if they are ", "already assigned to a different network interface in the same", "subnet."};

    public AssignPrivateIPAddresses(String[] args) {
        super("ec2apip", "ec2-assign-private-ip-addresses");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"network-interface");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"NETWORKINTERFACE");
        OptionBuilder.withDescription((String)AssignPrivateIPAddresses.joinDescription(NETWORK_INTERFACE_DESC));
        o.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"secondary-private-ip-address-count");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SECONDARY-PRIVATE-ADDRESS-COUNT");
        OptionBuilder.withDescription((String)AssignPrivateIPAddresses.joinDescription(SECONDARY_PRIVATE_IP_ADDRESS_COUNT_DESC));
        o.addOption(OptionBuilder.create(null));
        OptionBuilder.withLongOpt((String)"secondary-private-ip-address");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SECONDARY-PRIVATE-IP-ADDRESS");
        OptionBuilder.withDescription((String)AssignPrivateIPAddresses.joinDescription(SECONDARY_PRIVATE_IP_ADDRESS_DESC));
        o.addOption(OptionBuilder.create(null));
        o.addOption(AssignPrivateIPAddresses.createOption(null, "allow-reassignment", ALLOW_REASSIGNMENT_DESC));
        return o;
    }

    @Override
    protected String getOptionString() {
        return "-n NETWORK_INTERFACE_ID (--secondary-private-ip-address-count SECONDARY_PRIVATE ADDRESS_COUNT | --secondary-private-ip-address SECONDARY_PRIVATE_IP_ADDRESS [--secondary-private-ip-address SECONDARY_PRIVATE_IP_ADDRESS ...])";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("network-interface");
        this.printOption("secondary-private-ip-address-count");
        this.printOption("secondary-private-ip-address");
        this.printOption("allow-reassignment");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Assign secondary private IP addresses to the specified network ");
        System.out.println("     interface. The private IP addresses to be assigned can be added ");
        System.out.println("     individually or the number to be added can be specified.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertOptionSet("network-interface");
        if (!this.isOptionSet("secondary-private-ip-address-count") && !this.isOptionSet("secondary-private-ip-address")) {
            throw new MissingAtLeastOneArgument(new String[]{"secondary-private-ip-address-count", "secondary-private-ip-address"});
        }
        if (this.isOptionSet("secondary-private-ip-address-count") && this.isOptionSet("secondary-private-ip-address")) {
            throw new InvalidArgumentCombination("Specify either a secondary private address count or a list of secondary private addresses, not both.");
        }
        String networkInterfaceId = this.getOptionValue("network-interface");
        Integer addressCount = this.isOptionSet("secondary-private-ip-address-count") ? Integer.valueOf(Integer.parseInt(this.getOptionValue("secondary-private-ip-address-count"))) : null;
        List<String> privateIPAddresses = this.isOptionSet("secondary-private-ip-address") ? Arrays.asList(this.getOptionValues("secondary-private-ip-address")) : null;
        boolean allowReassignment = this.isOptionSet("allow-reassignment");
        this.warnIfTooManyNonOptions();
        RequestResultPair resPair = jec2.assignPrivateIPAddresses(networkInterfaceId, addressCount, privateIPAddresses, allowReassignment);
        out.output(System.out, (Boolean)resPair.getResponse());
        return true;
    }

    public static void main(String[] args) {
        new AssignPrivateIPAddresses(args).invoke();
    }
}

