/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.io.FileInputStream;
import java.security.Security;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SecureXSLTTest
extends TestCase {
    public SecureXSLTTest(String string) {
        super(string);
    }

    public void test() throws Exception {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        File file = new File(string2 + string + "data" + string + "javax" + string + "xml" + string + "crypto", "dsig");
        String[] stringArray = new String[]{"signature1.xml", "signature2.xml", "signature3.xml"};
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        File file2 = new File("doc.xml");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new FileInputStream(new File(file, string3)));
            NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nodeList.getLength() == 0) {
                throw new Exception("Cannot find Signature element");
            }
            DOMValidateContext dOMValidateContext = new DOMValidateContext(new KeySelectors.KeyValueKeySelector(), nodeList.item(0));
            dOMValidateContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
            file2.delete();
            XMLSignature xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
            try {
                if (xMLSignature.validate(dOMValidateContext)) {
                    System.err.println("Signature UNEXPECTEDLY passed validation");
                }
                xMLSignature.getSignedInfo().getReferences().get(0);
            }
            catch (XMLSignatureException xMLSignatureException) {
                // empty catch block
            }
            if (!file2.exists()) continue;
            file2.delete();
            throw new Exception("Test FAILED: doc.xml was successfully created");
        }
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }
}

