/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.transport.http.HttpChannel;
import org.codehaus.xfire.transport.http.HttpTransport;
import org.codehaus.xfire.transport.http.XFireServletController;
import org.codehaus.xfire.util.OutMessageDataSource;

public class XFireServletChannel
extends HttpChannel {
    public XFireServletChannel(String uri, HttpTransport transport) {
        super(uri, transport);
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if (message.getUri().equals("urn:xfire:channel:backchannel")) {
            HttpServletResponse response = XFireServletController.getResponse();
            if (response == null) {
                throw new XFireRuntimeException("No backchannel exists for message");
            }
            this.sendViaServlet(context, message, response);
        } else {
            this.sendViaClient(context, message);
        }
    }

    protected void sendViaServlet(MessageContext context, OutMessage message, HttpServletResponse response) throws XFireException {
        try {
            BufferedOutputStream out = null;
            boolean mtomEnabled = Boolean.valueOf((String)context.getContextualProperty("mtom-enabled"));
            Attachments atts = message.getAttachments();
            if (mtomEnabled || atts != null) {
                if (atts == null) {
                    atts = new JavaMailAttachments();
                    message.setAttachments(atts);
                }
                OutMessageDataSource source = new OutMessageDataSource(context, message);
                DataHandler soapHandler = new DataHandler((DataSource)source);
                atts.setSoapContentType(HttpChannel.getSoapMimeType(message, false));
                atts.setSoapMessage(new SimpleAttachment(source.getName(), soapHandler));
                response.setContentType(atts.getContentType());
                out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                atts.write(out);
                source.dispose();
            } else {
                response.setContentType(this.doGetSoapMimeType(message, true));
                out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                message.setProperty("channel.outputstream", out);
                HttpChannel.writeWithoutAttachments(context, message, out);
            }
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new XFireException("Couldn't send message.", e);
        }
    }

    protected String doGetSoapMimeType(AbstractMessage msg, boolean includeEncoding) {
        return HttpChannel.getSoapMimeType(msg, includeEncoding);
    }
}

