/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.signature.contract;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.samples.SampleUtils;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

public class ThreeSignerContractVerify {
    public static void main(String[] stringArray) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        try {
            File file = new File("threeSignerContract.xml");
            String string = file.toURL().toString();
            System.out.println("Try to verify " + file.toURL().toString());
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            Document document = documentBuilder.parse(new FileInputStream(file));
            Element element = SampleUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
            NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"//ds:Signature", (Node)element);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                XMLSignature xMLSignature = new XMLSignature(element2, string);
                Element element3 = (Element)element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyName").item(0);
                String string2 = element3.getFirstChild().getNodeValue();
                System.out.println("The signature number " + (i + 1) + " is " + (xMLSignature.checkSignatureValue((Key)xMLSignature.createSecretKey(string2.getBytes())) ? "valid (good)" : "invalid !!!!! (bad)"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        Init.init();
    }
}

