### v0.25.6
- Fixed demo playback file loading

### v0.25.5
- Fixed per-source sound limit
- Fixed load order on demo playback
- Fixed nerf map 8 load time

### v0.25.4
- Fixed doom sound priority yet further

### v0.25.3
- Fixed doom sound priority
- Fixed MS GS Synth bug (ceski)

### v0.25.2
- Added separate `off` variant of hud config when extended hud is off
- Added "armor color by class" hud option (default is on)
- Added `big_health_text` and `big_armor_text` hud components (status bar font without sprite)

### v0.25.1
- Added portmidi reverb and chorus options (ceski)
- Removed anisotropic filtering setting (only applied to "detail textures")
- Fixed various portmidi issues (ceski)
- Fixed looping sound on intermission screen
- Fixed exhud toggle not always applying immediately
- Fixed assign causing a permanent change for screen resolution
- Fixed fullclip not working with A_ConsumeAmmo (e.g., vesper weapons)

### v0.25.0
This update is the biggest yet, including improvements in many areas of the port. There is a new indexed light mode (software fidelity in opengl), expanded doom-in-hexen coverage, improved controller support, a new HUD system with new components, command-line-argument validations and descriptions, new console commands and better usability, debugging tools for testers / creators, scripting, a basic build mode, new trackers, various quality of life improvements, and a configuration / menu overhaul. Check out the details below.

#### Graphics
- OpenGL windows are now resizable / maximizable (elim)
- OpenGL now stretches in full screen mode (elim)
- Improved performance of raven title screens (xaser)
- Indexed Light Mode (xaser)
  - Xaser has implemented a new light mode for opengl that closely replicates the visuals of the software renderer. It uses the software palette system (including the pain palette and gamma) and can replicate previously software-exclusive effects like fake fog (recently seen in wormwood 4 map 5). This is the new default for opengl and combines the accuracy of software with the performance of hardware. Enjoy!
  - There are still quirks of the software renderer that cannot be reproduced, but this is a significant improvement in visual fidelity.

#### Doom in Hexen
- Completed the first iteration of the format!
  - Thing specials
    - Creatures / destructables execute their specials when killed / destroyed
    - Items execute their specials when picked up
  - New thing type
    - Custom MusicChanger
      - The track number can be from 0 to 64
      - The order argument is currently not supported
  - TeleportDest2 & TeleportDest3 now use their z position for teleports
  - New line specials
    - Radius_Quake
    - Thing_SetSpecial
    - TeleportGroup
    - TeleportInSector
    - Teleport_NewMap
      - The cluster concept is not supported yet
    - Teleport_EndGame
  - The interaction between Teleport_* and UMAPINFO is currently undefined
  - The position argument (arg 0) is now supported in Exit_Normal and Exit_Secret

#### Controller Support
- Added support for modern controller buttons
- Added support for dual analogs
- Added semantic names for the binding menu (i.e., `pad x` instead of `jsb2`)
- Improved menu navigation
- Updated default bindings
  - `L` strafe
  - `R` use item (heretic / hexen)
  - `LT` map
  - `RT` fire
  - `A` use
  - `B` jump (hexen)
  - `X` previous weapon
  - `Y` next weapon
  - `Dpad Up` fly up (heretic / hexen)
  - `Dpad Down` fly down (heretic / hexen)
  - `Dpad Left` inventory left (heretic / hexen)
  - `Dpad Right` inventory right (heretic / hexen)
  - `Left Stick` toggle auto run
  - `Right Stick` turn 180
- New config variables:
  - `left_analog_deadzone`
  - `right_analog_deadzone`
  - `left_trigger_deadzone`
  - `right_trigger_deadzone`
  - `left_analog_sensitivity_x`
  - `left_analog_sensitivity_y`
  - `right_analog_sensitivity_x`
  - `right_analog_sensitivity_y`
  - `analog_look_acceleration`
  - `swap_analogs`
    - When on, the left analog stick looks and the right analog stick moves
  - `invert_analog_look`
- While recording in strict mode, mouse and controller cannot be used simultaneously
  - The port will detect the first peripheral used and block the other

#### HUD
- Replaced the fullscreen hud
- Added a hud configuration lump (`DSDAHUD.lmp`)
  - Can be used to configure the fullscreen hud (like `-PRBHUD-.lmp`)
  - Can also be used to configure the extended hud
  - Added `-hud my_hud.cfg` command line argument to override the lump
- The fullscreen hud now works in hexen and heretic
- Heretic and hexen hud text colors have been corrected
- Coordinate display now works with the fullscreen hud
- Command display now works with the fullscreen hud
- Full documentation [here](../docs/hud.md)
- Added angle to coordinate display
- Added distance traveled to coordinate display
- Added line interactions to coordinate display
- Added extended hud scale option (under quality of life in general settings)
- Added simple fps component (menu toggle and key binding)
- Command display now shows on the intermission stats screen
- Coordinate display now shifts down when the console is open

#### Command Line Arguments
- Added `-help` / `--help`
  - Prints out brief description of the options
- Options and their arguments are now validated
  - `-warp abc` raises an error (cannot interpret string as a map)
  - `-recordfromto a.lmp` raises an error (missing destination file)
  - `-skill -warp` raises an error (no skill specified)
  - `-recor my.lmp` raises an error (unknown option)
- `-file` now accepts `.deh` files instead of silently ignoring them
- `-file` now raises an error if it can't find the file
- `-time_*` now accepts an optional message duration argument (in tics)
- Using `-recordfromto` with a missing source demo now causes an error
- Changed default `-turbo` value to 255
- Added a warning for duplicate options
- Added error message when recording without specifying a compatibility level
- Added `-cl` alias for `-complevel`
- Added `-skiptic` (`-skipsec` analog for tics)
- Added `-assign attribute=value [attribute2=value2 ...]`
  - Sets the `value` of `attribute` (a config file key)
  - These changes are temporary and will not be written to the config file
- Added `-update attribute=value [attribute2=value2 ...]`
  - Sets the `value` of `attribute` (a config file key)
  - These changes are permanent and will be written to the config file
- Removed `-nowindow` and `-nofullscreen`
  - Use `-window` and `-fullscreen` (temporary settings)
- Removed -ffmap (use -warp)

#### Console
- Added basic [console doc](../docs/guides/console.md)
- Added `assign attribute value`
  - Sets the `value` of `attribute` (a config file key)
  - These changes are temporary and will not be written to the config file
- Added `update attribute value`
  - Sets the `value` of `attribute` (a config file key)
  - These changes are permanent and will be written to the config file
- Added `toggle_assign attribute`
  - Toggles `attribute` (a config file key)
  - These changes are temporary and will not be written to the config file
- Added `toggle_update attribute`
  - Toggles `attribute` (a config file key)
  - These changes are permanent and will be written to the config file
- Added `demo.export X`
  - Exports current demo buffer to file `X.lmp`
  - Existing demo will continue as normal
- Added `demo.start X`
  - Starts a demo recording *in the middle of a session*, with name `X.lmp`
  - Demos may not play back on other operating systems (due to how the state is archived)
  - Consider this experimental right now - the side effects are not well understood
- Added `demo.stop`
  - Exports current demo buffer and stops recording
- Added `music.restart`
- Added `jump.to_tic X`
  - Works during playback and recording
- Added `jump.by_tic X`
  - Accepts positive and negative values
- Added `script.run X`
  - Loads text file `X` and runs each line as a console command
  - Lines starting with `!`, `#`, and `/` are considered comments
- Added `fullclip` (infinite ammo)
- Added `freeze` (freeze time)
- Added `nosleep` (wakes up all monsters)
- Added `allghosts` (trigger intercept overflow blockmap corruption)
- Added another batch of cheats
  - `idclev`, `idmus`, `gimme`, `engage`, `shadowcaster`, `visit`, and `puke`
  - These commands all take one argument, without spaces (`idclev 24` for map 24 or e2m4)
- Added `player.give_weapon X`
- Added `player.give_ammo ammo_type [ammo_amount]`
  - If no `ammo_amount` is given, gives the player max ammo
- Added `player.set_ammo ammo_type ammo_amount`
- Added `player.give_power power [duration]` and `player.remove_power power`
  - If no `duration` (in tics) is given, the duration is infinite
  - Adding or removing powers from a different game has undefined behaviour
  - Powers:
    - 0: Invulnerability
    - 1: Berserk
    - 2: Partial Invisibility
    - 3: Radiation Suit
    - 4: Map
    - 5: Light Amplification
    - 6: Tome of Power
    - 7: Flight
    - 10: Speed
- Added `player.give_key X` and `player.remove_key X`
- Added basic feedback to console ("command invalid")
  - Unallowed cheats are interpreted as invalid
- Added context validations (some commands are invalid while recording)
- Added support for semicolon-separated commands on one line
- Enabled console in strict mode (most commands are invalid)
- Pressing up & down now moves through the console entry history
- Pressing left & right now adjusts the cursor
- Added support for SDL text input
  - You can now type characters like `_`
  - Existing commands have been converted to snake case
  - Non-ascii characters are currently ignored
- Removed `command.lock` / `command.unlock` (superseded by build mode)

#### Testing / Debugging
- Console command subjects:
  - `target.* [args]` commands affect the thing the player is aiming at
  - `mobj.* <mobj_index> [args]` commands affect the thing with the given index
  - `boss.* <mobj_index> [args]` commands execute with the boss action flag set
  - `player.* [args]` commands are executed by the console player
- Added thing manipulation console commands
  - Supports `target` and `mobj`
  - Added state manipulation:
    - `*.spawn`
    - `*.see`
    - `*.pain`
    - `*.melee`
    - `*.missile`
    - `*.death`
    - `*.xdeath`
    - `*.raise`
    - `*.set_state <state_num>`
  - Added flag manipulation:
    - Use named format (e.g., `LOGRAV+SHOOTABLE`)
    - Some flag changes may have unforeseen side effects
    - `*.add_flags <flags>`
    - `*.remove_flags <flags>`
    - `*.set_flags <flags>`
  - Added `*.set_health <health>`
  - Added `*.move <x> <y>`
  - Added `*.set_target <mobj_index>`
  - Added `*.target_player`
- Added `spawn <x> <y> <z> <type>` console command
- Added `*.activate_line <line_id>`
  - Supports `player`, `target`, `mobj`, and `boss`
- Added state manipulation console commands
  - `state.set_tics <state_id> <value>`
  - `state.set_misc1 <state_id> <value>`
  - `state.set_misc2 <state_id> <value>`
  - `state.set_args1 <state_id> <value>`
  - `state.set_args2 <state_id> <value>`
  - `state.set_args3 <state_id> <value>`
  - `state.set_args4 <state_id> <value>`
  - `state.set_args5 <state_id> <value>`
  - `state.set_args6 <state_id> <value>`
  - `state.set_args7 <state_id> <value>`
  - `state.set_args8 <state_id> <value>`
- Added mobj info manipulation console commands
  - Some changes to mobj info require restarting a map
  - `mobjinfo.set_health <type> <value>`
  - `mobjinfo.set_radius <type> <value>`
  - `mobjinfo.set_height <type> <value>`
  - `mobjinfo.set_mass <type> <value>`
  - `mobjinfo.set_damage <type> <value>`
  - `mobjinfo.set_speed <type> <value>`
  - `mobjinfo.set_fast_speed <type> <value>`
  - `mobjinfo.set_melee_range <type> <value>`
  - `mobjinfo.set_reaction_time <type> <value>`
  - `mobjinfo.set_pain_chance <type> <value>`
  - `mobjinfo.set_infighting_group <type> <value>`
  - `mobjinfo.set_projectile_group <type> <value>`
  - `mobjinfo.set_splash_group <type> <value>`
  - Flags
    - Use named format (e.g., `LOGRAV+SHOOTABLE`)
    - `mobjinfo.add_flags <type> <value>`
    - `mobjinfo.remove_flags <type> <value>`
    - `mobjinfo.set_flags <type> <value>`
- Replaced the `idrate` component
  - Tracks and shows the max values for segs, planes, and sprites
  - Color codes the values based on static limits
    - These depend on the rendering mode and are not guaranteed
  - Uses the hud font rather than hooking into the message widget

#### Scripts
- Added 10 script entries to the config file, `dsda_script_*`
- Scripts can be bound to keys
- Use `;` to delimit multiple commands
- Example:
  - Config file: `dsda_script_0                     "fly;idclip;iddqd"`
  - Bind `K` to `Script 0`
  - Pressing `K` will now toggle flight, no clip, and god mode

#### Demos
- Added automatic time suffix for demo file names
  - Add `$` to the end of your file name to trigger this behaviour
  - You may need to escape this character depending on environment (`-record ny01p\$`)
  - The suffix is only applied for "completed" runs
    - By default a run is assumed to be an IL, so a completed run is one that exits the first map only
    - To apply this logic for movies, use `-movie X` to set the _final map_ that your movie must end on. For example, a doom 1 episode run would use `-movie 8`. A d2all would use `-movie 30`
    - Runs with the same time will have a counter like normal demos (`ny01p597-00002.lmp`)
  - The suffix format depends on the type of run:
    - IL:
      - `11.97` is `1197`
      - `1:01.03` is `10103`
    - Movie:
      - `0:09` is `009`
      - `1:01` is `101`
      - `2:13:45` is `21345`
- Added extra error info if splits fail to write
- Added `reborn` to analysis output
- Opening the menu pauses demo playback
- The join key now works during demo playback
- The restart key now works during demo playback
- Improved startup time during demo playback
- Disabled mlook in strict mode
- Disabled simple shadows in strict mode
- Disabled idrate stats in strict mode
- Disabled ghosts in strict mode
- Removed mlook data from extended demo footer
- Removed the option to overwrite existing demos
- Added `cap_wipescreen` option in config file (pr+)
- Heretic key frames should be safe and reliable now
  - Hexen key frames are more stable but not perfect yet

#### Quality of Life
- Added `boom_translucent_sprites` toggle option
- Added option to hide top left precise intermission time
- Added option to hide player weapon (e.g., for screenshots)
- Added quake intensity accessibility option (hexen)

#### Sound & Music
- Restored the default secret sound effect from zdoom
- Added looping sounds to reduce clicking in certain level events
- Improved portmidi player (pr+)
- Improved audio buffer slize size calculation (pr+)
- Improved fluidsynth defaults (pr+)
- Added support for 8-bit and 16-bit WAV sfx (rfomin)

#### Tracker
- Added tracker to extended hud (unavailable in strict mode)
  - line (special)
  - sector (special, active, floor height)
  - mobj (health)
  - player (last damage dealt)
- Added tracker console commands:
  - `tracker.add_line X` / `t.al X`: adds line index X to tracker
  - `tracker.remove_line X` / `t.rl X`: removes line index X from tracker
  - `tracker.add_line_distance X` / `t.ald X`: adds distance from line index X to tracker
  - `tracker.remove_line_distance X` / `t.rld X`: removes distance from line index X from tracker
  - `tracker.add_sector X` / `t.as X`: adds sector index X to tracker
  - `tracker.remove_sector X` / `t.rs X`: removes sector index X from tracker
  - `tracker.add_mobj X` / `t.am X`: adds mobj index X to tracker
  - `tracker.remove_mobj X` / `t.rm X`: removes mobj index X from tracker
  - `tracker.add_player` / `t.ap`: adds player to tracker
  - `tracker.remove_player` / `t.rp`: removes player from tracker
  - `tracker.reset` / `t.r`: removes all trackers
- Added tracker command line arguments:
  - `-track_line a [b c ...]`
  - `-track_line_distance a [b c ...]`
  - `-track_sector a [b c ...]`
  - `-track_mobj a [b c ...]`
  - `-track_player`
- Removed old tas tracers

#### Build Mode
- Added basic [build mode](../docs/guides/build_mode.md)
  - Supports doom and heretic fully
  - Hexen building is still unreliable due to imperfect key frames
- Added simple brute force
- Added frame-by-frame control of demo playback

#### Compatibility
- Added support for automap color OPTIONS lump entries
- Added automatic compatibilty correction for the following maps:
  - roomblow e1m1 (comp_stairs)
  - esp map21 (comp_stairs)
  - av map07 (comp_model)
  - sin2_9 map02 (comp_vile)
  - d2reload map09 (comp_vile)
  - amoreupho map02 (comp_vile)
  - dbp20_dnd map07 (comp_vile)
  - arch map01 (comp_vile)
  - ur map06 (comp_vile)

#### Interface
- Consolidated and rearranged many menus
- Protected the select item keybinding from being cleared
- Removed chat setup menu and settings
- Improved resolution sorting (fabian)
- Removed legacy windows launcher
  - See the official launcher by PBeGood4 [here](https://github.com/Pedro-Beirao/dsda-launcher).
- Removed legacy autoload configuration (use autoload folder)
- Removed ENDOOM / ENDBOOM screen emulation
  - Added `ansi_endoom` config setting
    - Dumps the endoom data to the terminal at exit, using ansi format codes
    - Set this to `1` for the CP437 character set
    - Set this to `2` for the UTF-8 character set
  - Support may be added to the official launcher later on

#### Technical
- Added extra context information in signal crashes
- Added a specific error message when trying to load a udmf map
- Terminal interrupt now exits without a message box on windows
- Cleaned up log output
- Improved mouse stutter correction formula (mikeday0)

#### Bug Fixes
- Fixed gamma changes not preserving palette
- Fixed an issue with flat / texture animation syncing
- Fixed erroneous color duplicate detection
- Fixed heretic e3 finale scroll jitter in uncapped fps
- Fixed heretic door landing sound
- Fixed certain hexen sounds having lower than intended priority
- Fixed an issue where fewer than expected raven sounds would play simultaneously
- Fixed a few fluidsynth errors and warnings
- Fixed menu choice settings being updated even after pressing escape
- Fixed "show alive monsters" behaviour when toggling strict mode
- Fixed various cases where rewind did not work
  - You can now rewind past a map restart
  - You can now rewind past a load event
- Fixed various desyncs caused by mixing manual and automatic key frames
- Fixed an edge case where an automatic key frame could be skipped
- Fixed TNTR Map 30 comp option in MBF21
- Fixed minor memory leak from in-game restart
- Fixed dsda-format playback progress bar (for future demos)
- Fixed top left intermission time not showing right away in heretic
- Fixed iddqd / idclip key bindings in `-dsdademo` mode
- Fixed desync from combining key frames and `-recordfromto`
- Fixed `-warp` and `-skipsec` hanging in certain cases when combined with `-recordfromto`
- Fixed `-turbo` default handling
- Fixed `-turbo` value overflows
- Fixed `-warp 0`
- Fixed an error in split file parsing
- Fixed umapinfo actor index calculation
- Fixed weapon swap overrides while holding down fire when running out of ammo in cl9+
- Fixed a key frame desync in heretic caused by ambient sounds
- Fixed a key frame desync in hexen caused by animated textures
- Fixed a key frame desync in hexen caused by lightning
- Fixed a key frame desync in hexen caused by poly objects
- Fixed a key frame desync in hexen caused by inconsistent bounding boxes
- Fixed a corrupt save game bug caused by msecnode orphans
- Fixed strafe not applying for the quickstart cache
- Fixed a rare crash caused by out-of-bounds patches in the software renderer
- Fixed turn keys leaking into the mouse cache
- Fixed smooth demo teleport in raven games
- Fixed a case where umapinfo levels would not trigger a levelstat entry
- Fixed map finish log in hexen
- Fixed a umapinfo crash when using endgame in doom 2 without an endpic
- Fixed some issues related to par times in umapinfo
- Fixed the default umapinfo endpic for e2
- Fixed clicking caused by moving planes under certain conditions
- Fixed portmidi volume spikes (ceski)
- Fixed sound attenuation at long distances (decino)
- Fixed distant sounds counting for parallel sfx limit (jackrjli)
- Fixed `iddit` and `iddkt` behavior when only one thing exists (jackrjli)
- Fixed various umapinfo consistency issues (pr+)
- Fixed sky bleed opengl issue (pr+)
- Fixed midtexture overlap judder (pr+)
- Fixed rare desync in clang builds (pr+)
- Fixed translation table behaviour (pr+)
- Fixed an issue with drawing status bar numbers with offsets (woof)

#### Configuration

The way configuration works in dsda-doom has been completely rewritten. This was done to create a generic interface that allows for temporary and permanent changes to every configurable variable. This process required evaluating each variable's presence in the code base and migrating it from the old system to the new one. Since this migration took considerable effort, it was a good excuse to perform an audit on the config file and remove variables that have little value to the port as it currently exists, and to make some semantic changes in a few places. This additionally makes the settings less confusing and overwhelming for new players (though there is still work to do). It also improves predictability in the user experience and reduces the number of bugs that can occur over time. If a setting was removed, it doesn't mean it can't come back - it only means that it did not make the initial cut as I was prioritizing the things that have clear, fundamental importance.

- Deconfigured the following settings (the default value is assumed):
  - `demo_demoex_filename`
  - `filter_floor`
  - `filter_patch`
  - `filter_sprite`
  - `filter_threshold`
  - `filter_wall`
  - `filter_z`
  - `getwad_cmdline`
  - `gl_allow_detail_textures`
  - `gl_arb_multitexture`
  - `gl_arb_texture_compression`
  - `gl_arb_texture_non_power_of_two`
  - `gl_arb_pixel_buffer_object`
  - `gl_arb_shader_objects`
  - `gl_boom_colormaps`
  - `gl_clear`
  - `gl_color_mip_levels`
  - `gl_colorbuffer_bits`
  - `gl_detail_maxdist`
  - `gl_depthbuffer_bits`
  - `gl_exclusive_fullscreen`
  - `gl_ext_arb_vertex_buffer_object`
  - `gl_ext_blend_color`
  - `gl_ext_framebuffer_object`
  - `gl_ext_packed_depth_stencil`
  - `gl_ext_texture_filter_anisotropic`
  - `gl_finish`
  - `gl_fog_color`
  - `gl_hires_24bit_colormap`
  - `gl_hires_override_pwads`
  - `gl_mask_sprite_threshold`
  - `gl_motionblur`
  - `gl_motionblur_att_a`
  - `gl_motionblur_att_b`
  - `gl_motionblur_att_c`
  - `gl_motionblur_min_angle`
  - `gl_motionblur_min_speed`
  - `gl_nearclip`
  - `gl_patch_filter`
  - `gl_shadows`
  - `gl_shadows_factor`
  - `gl_shadows_maxdist`
  - `gl_sky_detail`
  - `gl_sprite_blend`
  - `gl_sprite_filter`
  - `gl_sprite_offset`
  - `gl_spriteclip`
  - `gl_spriteclip_threshold`
  - `gl_sprites_frustum_culling`
  - `gl_texture_external_hires`
  - `gl_texture_filter`
  - `gl_texture_hires_dir`
  - `gl_texture_hqresize`
  - `gl_texture_hqresize_patches`
  - `gl_texture_hqresize_sprites`
  - `gl_texture_hqresize_textures`
  - `gl_texture_internal_hires`
  - `gl_use_display_lists`
  - `gl_use_paletted_texture`
  - `gl_use_shared_texture_palette`
  - `gl_use_stencil`
  - `gl_ztrick`
  - `health_bar_full_length`
  - `health_bar_green`
  - `health_bar_red`
  - `health_bar_yellow`
  - `hud_list_bgon`
  - `hud_msg_lines`
  - `hudcolor_list`
  - `hudcolor_mapstat_time`
  - `hudcolor_mapstat_title`
  - `hudcolor_mapstat_value`
  - `hudcolor_mesg`
  - `hudcolor_titl`
  - `hudcolor_xyco`
  - `interpolation_maxobjects`
  - `level_precache`
  - `map_always_updates`
  - `map_overlay_pos_width`
  - `map_overlay_pos_height`
  - `map_overlay_pos_x`
  - `map_overlay_pos_y`
  - `movement_maxviewpitch`
  - `mus_extend_volume`
  - `patch_edges`
  - `render_paperitems`
  - `speed_step`
  - `sprite_edges`
  - `sprites_doom_order`
  - `tran_filter_pct`
- Changed the following settings:
  - `sound_card` (unused and removed)
  - `music_card` (unused and removed)
  - `gl_light_ambient` (unused and removed)
  - `map_use_multisamling` (corrected to `map_use_multisampling`)
  - `health_red` (changed to `hud_health_red`)
  - `health_yellow` (changed to `hud_health_yellow`)
  - `health_green` (changed to `hud_health_green`)
  - `ammo_red` (changed to `hud_ammo_red`)
  - `ammo_yellow` (changed to `hud_ammo_yellow`)
  - `quickstart_window_ms` (changed to `startup_delay_ms`)
  - `movement_mousenovert` (replaced by `movement_vertmouse`)
  - `render_multisampling` (changed by `gl_render_multisampling`)
  - `render_fov` (changed by `gl_render_fov`)
  - `useglgamma` (changed by `gl_usegamma`)
  - `automapmode` (split into `automap_follow`, etc)
  - `movement_mouselook` (replaced by `allow_freelook`)
  - `samplerate` (replaced by `snd_samplerate`)
  - `slice_samplecount` (replaced by `snd_samplecount`)
- Rearranged and consolidated sections in the config file
- Added console commands for editing config variables (see console section above)
- Added command line arguments for editing config variables (see above)
