/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.node;

import com.googlecode.d2j.Method;
import com.googlecode.d2j.Visibility;
import com.googlecode.d2j.node.DexAnnotationNode;
import com.googlecode.d2j.node.DexCodeNode;
import com.googlecode.d2j.visitors.DexAnnotationAble;
import com.googlecode.d2j.visitors.DexAnnotationVisitor;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexMethodVisitor;
import java.util.ArrayList;
import java.util.List;

public class DexMethodNode
extends DexMethodVisitor {
    public int access;
    public List<DexAnnotationNode> anns;
    public DexCodeNode codeNode;
    public Method method;
    public List<DexAnnotationNode>[] parameterAnns;

    public DexMethodNode(DexMethodVisitor mv, int access, Method method) {
        super(mv);
        this.access = access;
        this.method = method;
    }

    public DexMethodNode(int access, Method method) {
        this.access = access;
        this.method = method;
    }

    public void accept(DexClassVisitor dcv) {
        DexMethodVisitor mv = dcv.visitMethod(this.access, this.method);
        if (mv != null) {
            this.accept(mv);
            mv.visitEnd();
        }
    }

    public void accept(DexMethodVisitor mv) {
        if (this.anns != null) {
            for (DexAnnotationNode ann : this.anns) {
                ann.accept(mv);
            }
        }
        if (this.parameterAnns != null) {
            int i = 0;
            while (i < this.parameterAnns.length) {
                DexAnnotationAble av;
                List<DexAnnotationNode> ps = this.parameterAnns[i];
                if (ps != null && (av = mv.visitParameterAnnotation(i)) != null) {
                    for (DexAnnotationNode p : ps) {
                        p.accept(av);
                    }
                }
                ++i;
            }
        }
        if (this.codeNode != null) {
            this.codeNode.accept(mv);
        }
    }

    @Override
    public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
        if (this.anns == null) {
            this.anns = new ArrayList<DexAnnotationNode>(5);
        }
        DexAnnotationNode annotation = new DexAnnotationNode(name, visibility);
        this.anns.add(annotation);
        return annotation;
    }

    @Override
    public DexCodeVisitor visitCode() {
        DexCodeNode codeNode;
        this.codeNode = codeNode = new DexCodeNode(super.visitCode());
        return codeNode;
    }

    @Override
    public DexAnnotationAble visitParameterAnnotation(final int index) {
        if (this.parameterAnns == null) {
            this.parameterAnns = new List[this.method.getParameterTypes().length];
        }
        return new DexAnnotationAble(){

            @Override
            public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
                List<DexAnnotationNode> pas = DexMethodNode.this.parameterAnns[index];
                if (pas == null) {
                    DexMethodNode.this.parameterAnns[index] = pas = new ArrayList<DexAnnotationNode>(5);
                }
                DexAnnotationNode annotation = new DexAnnotationNode(name, visibility);
                pas.add(annotation);
                return annotation;
            }
        };
    }
}

