/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.PhiExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class DeadCodeTransformer
implements Transformer {
    @Override
    public void transform(IrMethod method) {
        Cfg.createCFG(method);
        Cfg.dfsVisit(method, null);
        if (method.traps != null) {
            Iterator<Trap> it = method.traps.iterator();
            while (it.hasNext()) {
                Trap t = it.next();
                boolean allNotThrow = true;
                Stmt p = t.start;
                while (p != t.end) {
                    if (p.visited && Cfg.isThrow(p)) {
                        allNotThrow = false;
                        break;
                    }
                    p = p.getNext();
                }
                if (allNotThrow) {
                    it.remove();
                    continue;
                }
                boolean allNotVisited = true;
                boolean allVisited = true;
                LabelStmt[] labelStmtArray = t.handlers;
                int n = t.handlers.length;
                int n2 = 0;
                while (n2 < n) {
                    LabelStmt labelStmt = labelStmtArray[n2];
                    if (labelStmt.visited) {
                        allNotVisited = false;
                    } else {
                        allVisited = false;
                    }
                    ++n2;
                }
                if (allNotVisited) {
                    it.remove();
                    continue;
                }
                t.start.visited = true;
                t.end.visited = true;
                if (allVisited) continue;
                ArrayList<String> types = new ArrayList<String>(t.handlers.length);
                ArrayList<LabelStmt> labelStmts = new ArrayList<LabelStmt>(t.handlers.length);
                int i = 0;
                while (i < t.handlers.length) {
                    labelStmts.add(t.handlers[i]);
                    types.add(t.types[i]);
                    ++i;
                }
                t.handlers = labelStmts.toArray(new LabelStmt[labelStmts.size()]);
                t.types = types.toArray(new String[types.size()]);
            }
        }
        HashSet<Local> definedLocals = new HashSet<Local>();
        Iterator<Stmt> it = method.stmts.iterator();
        while (it.hasNext()) {
            Stmt p = it.next();
            if (!p.visited) {
                it.remove();
                continue;
            }
            if (p.st != Stmt.ST.ASSIGN && p.st != Stmt.ST.IDENTITY || p.getOp1().vt != Value.VT.LOCAL) continue;
            definedLocals.add((Local)p.getOp1());
        }
        if (method.phiLabels != null) {
            it = method.phiLabels.iterator();
            while (it.hasNext()) {
                LabelStmt labelStmt = (LabelStmt)it.next();
                if (!labelStmt.visited) {
                    it.remove();
                    continue;
                }
                if (labelStmt.phis == null) continue;
                for (AssignStmt phi : labelStmt.phis) {
                    definedLocals.add((Local)phi.getOp1());
                }
            }
        }
        method.locals.clear();
        method.locals.addAll(definedLocals);
        HashSet<Value> tmp = new HashSet<Value>();
        if (method.phiLabels != null) {
            for (LabelStmt labelStmt : method.phiLabels) {
                if (labelStmt.phis == null) continue;
                for (AssignStmt phi : labelStmt.phis) {
                    Value v;
                    PhiExpr phiExpr = (PhiExpr)phi.getOp2();
                    boolean needRebuild = false;
                    Value[] valueArray = phiExpr.getOps();
                    int n = valueArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        v = valueArray[n3];
                        if (!definedLocals.contains(v)) {
                            needRebuild = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!needRebuild) continue;
                    valueArray = phiExpr.getOps();
                    n = valueArray.length;
                    n3 = 0;
                    while (n3 < n) {
                        v = valueArray[n3];
                        if (definedLocals.contains(v)) {
                            tmp.add(v);
                        }
                        ++n3;
                    }
                    phiExpr.setOps(tmp.toArray(new Value[tmp.size()]));
                    tmp.clear();
                }
            }
        }
    }
}

