/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.merge;

import com.android.dx.dex.TableOfContents;
import com.android.dx.io.Annotation;
import com.android.dx.io.ClassData;
import com.android.dx.io.ClassDef;
import com.android.dx.io.Code;
import com.android.dx.io.DexBuffer;
import com.android.dx.io.DexHasher;
import com.android.dx.io.FieldId;
import com.android.dx.io.MethodId;
import com.android.dx.io.ProtoId;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.IndexMap;
import com.android.dx.merge.InstructionTransformer;
import com.android.dx.merge.SortableType;
import com.android.dx.merge.TypeList;
import com.android.dx.util.DexException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DexMerger {
    private final DexBuffer dexA;
    private final DexBuffer dexB;
    private final CollisionPolicy collisionPolicy;
    private final WriterSizes writerSizes;
    private final DexBuffer dexOut = new DexBuffer();
    private final DexBuffer.Section headerOut;
    private final DexBuffer.Section idsDefsOut;
    private final DexBuffer.Section mapListOut;
    private final DexBuffer.Section typeListOut;
    private final DexBuffer.Section classDataOut;
    private final DexBuffer.Section codeOut;
    private final DexBuffer.Section stringDataOut;
    private final DexBuffer.Section debugInfoOut;
    private final DexBuffer.Section encodedArrayOut;
    private final DexBuffer.Section annotationsDirectoryOut;
    private final DexBuffer.Section annotationSetOut;
    private final DexBuffer.Section annotationSetRefListOut;
    private final DexBuffer.Section annotationOut;
    private final TableOfContents contentsOut;
    private final IndexMap aIndexMap;
    private final IndexMap bIndexMap;
    private final InstructionTransformer aInstructionTransformer;
    private final InstructionTransformer bInstructionTransformer;
    private int compactWasteThreshold = 0x100000;

    public DexMerger(DexBuffer dexA, DexBuffer dexB, CollisionPolicy collisionPolicy) throws IOException {
        this(dexA, dexB, collisionPolicy, new WriterSizes(dexA, dexB));
    }

    private DexMerger(DexBuffer dexA, DexBuffer dexB, CollisionPolicy collisionPolicy, WriterSizes writerSizes) throws IOException {
        this.dexA = dexA;
        this.dexB = dexB;
        this.collisionPolicy = collisionPolicy;
        this.writerSizes = writerSizes;
        TableOfContents aContents = dexA.getTableOfContents();
        TableOfContents bContents = dexB.getTableOfContents();
        this.aIndexMap = new IndexMap(this.dexOut, aContents);
        this.bIndexMap = new IndexMap(this.dexOut, bContents);
        this.aInstructionTransformer = new InstructionTransformer(this.aIndexMap);
        this.bInstructionTransformer = new InstructionTransformer(this.bIndexMap);
        this.headerOut = this.dexOut.appendSection(writerSizes.header, "header");
        this.idsDefsOut = this.dexOut.appendSection(writerSizes.idsDefs, "ids defs");
        this.contentsOut = this.dexOut.getTableOfContents();
        this.contentsOut.dataOff = this.dexOut.getLength();
        this.contentsOut.mapList.off = this.dexOut.getLength();
        this.contentsOut.mapList.size = 1;
        this.mapListOut = this.dexOut.appendSection(writerSizes.mapList, "map list");
        this.contentsOut.typeLists.off = this.dexOut.getLength();
        this.typeListOut = this.dexOut.appendSection(writerSizes.typeList, "type list");
        this.contentsOut.annotationSetRefLists.off = this.dexOut.getLength();
        this.annotationSetRefListOut = this.dexOut.appendSection(writerSizes.annotationsSetRefList, "annotation set ref list");
        this.contentsOut.annotationSets.off = this.dexOut.getLength();
        this.annotationSetOut = this.dexOut.appendSection(writerSizes.annotationsSet, "annotation sets");
        this.contentsOut.classDatas.off = this.dexOut.getLength();
        this.classDataOut = this.dexOut.appendSection(writerSizes.classData, "class data");
        this.contentsOut.codes.off = this.dexOut.getLength();
        this.codeOut = this.dexOut.appendSection(writerSizes.code, "code");
        this.contentsOut.stringDatas.off = this.dexOut.getLength();
        this.stringDataOut = this.dexOut.appendSection(writerSizes.stringData, "string data");
        this.contentsOut.debugInfos.off = this.dexOut.getLength();
        this.debugInfoOut = this.dexOut.appendSection(writerSizes.debugInfo, "debug info");
        this.contentsOut.annotations.off = this.dexOut.getLength();
        this.annotationOut = this.dexOut.appendSection(writerSizes.annotation, "annotation");
        this.contentsOut.encodedArrays.off = this.dexOut.getLength();
        this.encodedArrayOut = this.dexOut.appendSection(writerSizes.encodedArray, "encoded array");
        this.contentsOut.annotationsDirectories.off = this.dexOut.getLength();
        this.annotationsDirectoryOut = this.dexOut.appendSection(writerSizes.annotationsDirectory, "annotations directory");
        this.dexOut.noMoreSections();
        this.contentsOut.dataSize = this.dexOut.getLength() - this.contentsOut.dataOff;
    }

    public void setCompactWasteThreshold(int compactWasteThreshold) {
        this.compactWasteThreshold = compactWasteThreshold;
    }

    private DexBuffer mergeDexBuffers() throws IOException {
        this.mergeStringIds();
        this.mergeTypeIds();
        this.mergeTypeLists();
        this.mergeProtoIds();
        this.mergeFieldIds();
        this.mergeMethodIds();
        this.mergeAnnotations();
        this.unionAnnotationSetsAndDirectories();
        this.mergeClassDefs();
        this.contentsOut.header.off = 0;
        this.contentsOut.header.size = 1;
        this.contentsOut.fileSize = this.dexOut.getLength();
        this.contentsOut.computeSizesFromOffsets();
        this.contentsOut.writeHeader(this.headerOut);
        this.contentsOut.writeMap(this.mapListOut);
        new DexHasher().writeHashes(this.dexOut);
        return this.dexOut;
    }

    public DexBuffer merge() throws IOException {
        long start = System.nanoTime();
        DexBuffer result = this.mergeDexBuffers();
        WriterSizes compactedSizes = this.writerSizes.clone();
        compactedSizes.minusWaste(this);
        int wastedByteCount = this.writerSizes.size() - compactedSizes.size();
        if (wastedByteCount > this.compactWasteThreshold) {
            DexMerger compacter = new DexMerger(this.dexOut, new DexBuffer(), CollisionPolicy.FAIL, compactedSizes);
            result = compacter.mergeDexBuffers();
            System.out.printf("Result compacted from %.1fKiB to %.1fKiB to save %.1fKiB%n", Float.valueOf((float)this.dexOut.getLength() / 1024.0f), Float.valueOf((float)result.getLength() / 1024.0f), Float.valueOf((float)wastedByteCount / 1024.0f));
        }
        long elapsed = System.nanoTime() - start;
        System.out.printf("Merged dex A (%d defs/%.1fKiB) with dex B (%d defs/%.1fKiB). Result is %d defs/%.1fKiB. Took %.1fs%n", this.dexA.getTableOfContents().classDefs.size, Float.valueOf((float)this.dexA.getLength() / 1024.0f), this.dexB.getTableOfContents().classDefs.size, Float.valueOf((float)this.dexB.getLength() / 1024.0f), result.getTableOfContents().classDefs.size, Float.valueOf((float)result.getLength() / 1024.0f), Float.valueOf((float)elapsed / 1.0E9f));
        return result;
    }

    private IndexMap getIndexMap(DexBuffer dexBuffer) {
        if (dexBuffer == this.dexA) {
            return this.aIndexMap;
        }
        if (dexBuffer == this.dexB) {
            return this.bIndexMap;
        }
        throw new IllegalArgumentException();
    }

    private void mergeStringIds() {
        new IdMerger<String>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.stringIds;
            }

            @Override
            String read(DexBuffer.Section in, IndexMap indexMap, int index) {
                return in.readString();
            }

            @Override
            void updateIndex(int offset, IndexMap indexMap, int oldIndex, int newIndex) {
                indexMap.stringIds[oldIndex] = newIndex;
            }

            @Override
            void write(String value) {
                ++((DexMerger)DexMerger.this).contentsOut.stringDatas.size;
                DexMerger.this.idsDefsOut.writeInt(DexMerger.this.stringDataOut.getPosition());
                DexMerger.this.stringDataOut.writeStringData(value);
            }
        }.mergeSorted();
    }

    private void mergeTypeIds() {
        new IdMerger<Integer>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.typeIds;
            }

            @Override
            Integer read(DexBuffer.Section in, IndexMap indexMap, int index) {
                int stringIndex = in.readInt();
                return indexMap.adjustString(stringIndex);
            }

            @Override
            void updateIndex(int offset, IndexMap indexMap, int oldIndex, int newIndex) {
                indexMap.typeIds[oldIndex] = (short)newIndex;
            }

            @Override
            void write(Integer value) {
                DexMerger.this.idsDefsOut.writeInt(value);
            }
        }.mergeSorted();
    }

    private void mergeTypeLists() {
        new IdMerger<TypeList>(this.typeListOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.typeLists;
            }

            @Override
            TypeList read(DexBuffer.Section in, IndexMap indexMap, int index) {
                return indexMap.adjustTypeList(in.readTypeList());
            }

            @Override
            void updateIndex(int offset, IndexMap indexMap, int oldIndex, int newIndex) {
                indexMap.putTypeListOffset(offset, DexMerger.this.typeListOut.getPosition());
            }

            @Override
            void write(TypeList value) {
                DexMerger.this.typeListOut.writeTypeList(value);
            }
        }.mergeUnsorted();
    }

    private void mergeProtoIds() {
        new IdMerger<ProtoId>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.protoIds;
            }

            @Override
            ProtoId read(DexBuffer.Section in, IndexMap indexMap, int index) {
                return indexMap.adjust(in.readProtoId());
            }

            @Override
            void updateIndex(int offset, IndexMap indexMap, int oldIndex, int newIndex) {
                indexMap.protoIds[oldIndex] = (short)newIndex;
            }

            @Override
            void write(ProtoId value) {
                value.writeTo(DexMerger.this.idsDefsOut);
            }
        }.mergeSorted();
    }

    private void mergeFieldIds() {
        new IdMerger<FieldId>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.fieldIds;
            }

            @Override
            FieldId read(DexBuffer.Section in, IndexMap indexMap, int index) {
                return indexMap.adjust(in.readFieldId());
            }

            @Override
            void updateIndex(int offset, IndexMap indexMap, int oldIndex, int newIndex) {
                indexMap.fieldIds[oldIndex] = (short)newIndex;
            }

            @Override
            void write(FieldId value) {
                value.writeTo(DexMerger.this.idsDefsOut);
            }
        }.mergeSorted();
    }

    private void mergeMethodIds() {
        new IdMerger<MethodId>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.methodIds;
            }

            @Override
            MethodId read(DexBuffer.Section in, IndexMap indexMap, int index) {
                return indexMap.adjust(in.readMethodId());
            }

            @Override
            void updateIndex(int offset, IndexMap indexMap, int oldIndex, int newIndex) {
                indexMap.methodIds[oldIndex] = (short)newIndex;
            }

            @Override
            void write(MethodId methodId) {
                methodId.writeTo(DexMerger.this.idsDefsOut);
            }
        }.mergeSorted();
    }

    private void mergeAnnotations() {
        new IdMerger<Annotation>(this.annotationOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.annotations;
            }

            @Override
            Annotation read(DexBuffer.Section in, IndexMap indexMap, int index) {
                return indexMap.adjust(in.readAnnotation());
            }

            @Override
            void updateIndex(int offset, IndexMap indexMap, int oldIndex, int newIndex) {
                indexMap.putAnnotationOffset(offset, DexMerger.this.annotationOut.getPosition());
            }

            @Override
            void write(Annotation value) {
                value.writeTo(DexMerger.this.annotationOut);
            }
        }.mergeUnsorted();
    }

    private void mergeClassDefs() {
        SortableType[] types = this.getSortedTypes();
        this.contentsOut.classDefs.off = this.idsDefsOut.getPosition();
        this.contentsOut.classDefs.size = types.length;
        for (SortableType type : types) {
            DexBuffer in = type.getBuffer();
            IndexMap indexMap = in == this.dexA ? this.aIndexMap : this.bIndexMap;
            this.transformClassDef(in, type.getClassDef(), indexMap);
        }
    }

    private SortableType[] getSortedTypes() {
        boolean allDone;
        SortableType[] sortableTypes = new SortableType[this.contentsOut.typeIds.size];
        this.readSortableTypes(sortableTypes, this.dexA, this.aIndexMap);
        this.readSortableTypes(sortableTypes, this.dexB, this.bIndexMap);
        do {
            allDone = true;
            for (SortableType sortableType : sortableTypes) {
                if (sortableType == null || sortableType.isDepthAssigned()) continue;
                allDone &= sortableType.tryAssignDepth(sortableTypes);
            }
        } while (!allDone);
        Arrays.sort(sortableTypes, SortableType.NULLS_LAST_ORDER);
        int firstNull = Arrays.asList(sortableTypes).indexOf(null);
        return firstNull != -1 ? Arrays.copyOfRange(sortableTypes, 0, firstNull) : sortableTypes;
    }

    private void readSortableTypes(SortableType[] sortableTypes, DexBuffer buffer, IndexMap indexMap) {
        for (ClassDef classDef : buffer.classDefs()) {
            SortableType sortableType = indexMap.adjust(new SortableType(buffer, classDef));
            int t = sortableType.getTypeIndex();
            if (sortableTypes[t] == null) {
                sortableTypes[t] = sortableType;
                continue;
            }
            if (this.collisionPolicy == CollisionPolicy.KEEP_FIRST) continue;
            throw new DexException("Multiple dex files define " + buffer.typeNames().get(classDef.getTypeIndex()));
        }
    }

    private void unionAnnotationSetsAndDirectories() {
        this.transformAnnotationSets(this.dexA, this.aIndexMap);
        this.transformAnnotationSets(this.dexB, this.bIndexMap);
        this.transformAnnotationDirectories(this.dexA, this.aIndexMap);
        this.transformAnnotationDirectories(this.dexB, this.bIndexMap);
    }

    private void transformAnnotationSets(DexBuffer in, IndexMap indexMap) {
        TableOfContents.Section section = in.getTableOfContents().annotationSets;
        if (section.exists()) {
            DexBuffer.Section setIn = in.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                this.transformAnnotationSet(indexMap, setIn);
            }
        }
    }

    private void transformAnnotationDirectories(DexBuffer in, IndexMap indexMap) {
        TableOfContents.Section section = in.getTableOfContents().annotationsDirectories;
        if (section.exists()) {
            DexBuffer.Section directoryIn = in.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                this.transformAnnotationDirectory(in, directoryIn, indexMap);
            }
        }
    }

    private void transformClassDef(DexBuffer in, ClassDef classDef, IndexMap indexMap) {
        this.idsDefsOut.assertFourByteAligned();
        this.idsDefsOut.writeInt(classDef.getTypeIndex());
        this.idsDefsOut.writeInt(classDef.getAccessFlags());
        this.idsDefsOut.writeInt(classDef.getSupertypeIndex());
        this.idsDefsOut.writeInt(classDef.getInterfacesOffset());
        int sourceFileIndex = indexMap.adjustString(classDef.getSourceFileIndex());
        this.idsDefsOut.writeInt(sourceFileIndex);
        int annotationsOff = classDef.getAnnotationsOffset();
        this.idsDefsOut.writeInt(indexMap.adjustAnnotationDirectory(annotationsOff));
        int classDataOff = classDef.getClassDataOffset();
        if (classDataOff == 0) {
            this.idsDefsOut.writeInt(0);
        } else {
            this.idsDefsOut.writeInt(this.classDataOut.getPosition());
            ClassData classData = in.readClassData(classDef);
            this.transformClassData(in, classData, indexMap);
        }
        int staticValuesOff = classDef.getStaticValuesOffset();
        if (staticValuesOff == 0) {
            this.idsDefsOut.writeInt(0);
        } else {
            DexBuffer.Section staticValuesIn = in.open(staticValuesOff);
            this.idsDefsOut.writeInt(this.encodedArrayOut.getPosition());
            this.transformStaticValues(staticValuesIn, indexMap);
        }
    }

    private void transformAnnotationDirectory(DexBuffer in, DexBuffer.Section directoryIn, IndexMap indexMap) {
        int i;
        ++this.contentsOut.annotationsDirectories.size;
        this.annotationsDirectoryOut.assertFourByteAligned();
        indexMap.putAnnotationDirectoryOffset(directoryIn.getPosition(), this.annotationsDirectoryOut.getPosition());
        int classAnnotationsOffset = indexMap.adjustAnnotationSet(directoryIn.readInt());
        this.annotationsDirectoryOut.writeInt(classAnnotationsOffset);
        int fieldsSize = directoryIn.readInt();
        this.annotationsDirectoryOut.writeInt(fieldsSize);
        int methodsSize = directoryIn.readInt();
        this.annotationsDirectoryOut.writeInt(methodsSize);
        int parameterListSize = directoryIn.readInt();
        this.annotationsDirectoryOut.writeInt(parameterListSize);
        for (i = 0; i < fieldsSize; ++i) {
            this.annotationsDirectoryOut.writeInt(indexMap.adjustField(directoryIn.readInt()));
            this.annotationsDirectoryOut.writeInt(indexMap.adjustAnnotationSet(directoryIn.readInt()));
        }
        for (i = 0; i < methodsSize; ++i) {
            this.annotationsDirectoryOut.writeInt(indexMap.adjustMethod(directoryIn.readInt()));
            this.annotationsDirectoryOut.writeInt(indexMap.adjustAnnotationSet(directoryIn.readInt()));
        }
        for (i = 0; i < parameterListSize; ++i) {
            ++this.contentsOut.annotationSetRefLists.size;
            this.annotationSetRefListOut.assertFourByteAligned();
            this.annotationsDirectoryOut.writeInt(indexMap.adjustMethod(directoryIn.readInt()));
            this.annotationsDirectoryOut.writeInt(this.annotationSetRefListOut.getPosition());
            DexBuffer.Section refListIn = in.open(directoryIn.readInt());
            int parameterCount = refListIn.readInt();
            this.annotationSetRefListOut.writeInt(parameterCount);
            for (int p = 0; p < parameterCount; ++p) {
                this.annotationSetRefListOut.writeInt(indexMap.adjustAnnotationSet(refListIn.readInt()));
            }
        }
    }

    private void transformAnnotationSet(IndexMap indexMap, DexBuffer.Section setIn) {
        ++this.contentsOut.annotationSets.size;
        this.annotationSetOut.assertFourByteAligned();
        indexMap.putAnnotationSetOffset(setIn.getPosition(), this.annotationSetOut.getPosition());
        int size = setIn.readInt();
        this.annotationSetOut.writeInt(size);
        for (int j = 0; j < size; ++j) {
            this.annotationSetOut.writeInt(indexMap.adjustAnnotation(setIn.readInt()));
        }
    }

    private void transformClassData(DexBuffer in, ClassData classData, IndexMap indexMap) {
        ++this.contentsOut.classDatas.size;
        ClassData.Field[] staticFields = classData.getStaticFields();
        ClassData.Field[] instanceFields = classData.getInstanceFields();
        ClassData.Method[] directMethods = classData.getDirectMethods();
        ClassData.Method[] virtualMethods = classData.getVirtualMethods();
        this.classDataOut.writeUleb128(staticFields.length);
        this.classDataOut.writeUleb128(instanceFields.length);
        this.classDataOut.writeUleb128(directMethods.length);
        this.classDataOut.writeUleb128(virtualMethods.length);
        this.transformFields(indexMap, staticFields);
        this.transformFields(indexMap, instanceFields);
        this.transformMethods(in, indexMap, directMethods);
        this.transformMethods(in, indexMap, virtualMethods);
    }

    private void transformFields(IndexMap indexMap, ClassData.Field[] fields) {
        int lastOutFieldIndex = 0;
        for (ClassData.Field field : fields) {
            int outFieldIndex = indexMap.adjustField(field.getFieldIndex());
            this.classDataOut.writeUleb128(outFieldIndex - lastOutFieldIndex);
            lastOutFieldIndex = outFieldIndex;
            this.classDataOut.writeUleb128(field.getAccessFlags());
        }
    }

    private void transformMethods(DexBuffer in, IndexMap indexMap, ClassData.Method[] methods) {
        int lastOutMethodIndex = 0;
        for (ClassData.Method method : methods) {
            int outMethodIndex = indexMap.adjustMethod(method.getMethodIndex());
            this.classDataOut.writeUleb128(outMethodIndex - lastOutMethodIndex);
            lastOutMethodIndex = outMethodIndex;
            this.classDataOut.writeUleb128(method.getAccessFlags());
            if (method.getCodeOffset() == 0) {
                this.classDataOut.writeUleb128(0);
                continue;
            }
            this.codeOut.alignToFourBytes();
            this.classDataOut.writeUleb128(this.codeOut.getPosition());
            this.transformCode(in, in.readCode(method), indexMap);
        }
    }

    private void transformCode(DexBuffer in, Code code, IndexMap indexMap) {
        ++this.contentsOut.codes.size;
        this.codeOut.assertFourByteAligned();
        this.codeOut.writeUnsignedShort(code.getRegistersSize());
        this.codeOut.writeUnsignedShort(code.getInsSize());
        this.codeOut.writeUnsignedShort(code.getOutsSize());
        Code.Try[] tries = code.getTries();
        this.codeOut.writeUnsignedShort(tries.length);
        this.codeOut.writeInt(0);
        short[] instructions = code.getInstructions();
        InstructionTransformer transformer = in == this.dexA ? this.aInstructionTransformer : this.bInstructionTransformer;
        short[] newInstructions = transformer.transform(instructions);
        this.codeOut.writeInt(newInstructions.length);
        this.codeOut.write(newInstructions);
        if (tries.length > 0) {
            if (newInstructions.length % 2 == 1) {
                this.codeOut.writeShort((short)0);
            }
            for (Code.Try tryItem : tries) {
                this.codeOut.writeInt(tryItem.getStartAddress());
                this.codeOut.writeUnsignedShort(tryItem.getInstructionCount());
                this.codeOut.writeUnsignedShort(tryItem.getHandlerOffset());
            }
            Code.CatchHandler[] catchHandlers = code.getCatchHandlers();
            this.codeOut.writeUleb128(catchHandlers.length);
            for (Code.CatchHandler catchHandler : catchHandlers) {
                this.transformEncodedCatchHandler(catchHandler, indexMap);
            }
        }
    }

    private void transformEncodedCatchHandler(Code.CatchHandler catchHandler, IndexMap indexMap) {
        int catchAllAddress = catchHandler.getCatchAllAddress();
        int[] typeIndexes = catchHandler.getTypeIndexes();
        int[] addresses = catchHandler.getAddresses();
        if (catchAllAddress != -1) {
            this.codeOut.writeSleb128(-typeIndexes.length);
        } else {
            this.codeOut.writeSleb128(typeIndexes.length);
        }
        for (int i = 0; i < typeIndexes.length; ++i) {
            this.codeOut.writeUleb128(indexMap.adjustType(typeIndexes[i]));
            this.codeOut.writeUleb128(addresses[i]);
        }
        if (catchAllAddress != -1) {
            this.codeOut.writeUleb128(catchAllAddress);
        }
    }

    private void transformStaticValues(DexBuffer.Section in, IndexMap indexMap) {
        ++this.contentsOut.encodedArrays.size;
        indexMap.adjustEncodedArray(in.readEncodedArray()).writeTo(this.encodedArrayOut);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            DexMerger.printUsage();
            return;
        }
        DexBuffer dexA = new DexBuffer(new File(args[1]));
        DexBuffer dexB = new DexBuffer(new File(args[2]));
        DexBuffer merged = new DexMerger(dexA, dexB, CollisionPolicy.KEEP_FIRST).merge();
        merged.writeTo(new File(args[0]));
    }

    private static void printUsage() {
        System.out.println("Usage: DexMerger <out.dex> <a.dex> <b.dex>");
        System.out.println();
        System.out.println("If both a and b define the same classes, a's copy will be used.");
    }

    private static class WriterSizes
    implements Cloneable {
        private int header = 112;
        private int idsDefs;
        private int mapList;
        private int typeList;
        private int classData;
        private int code;
        private int stringData;
        private int debugInfo;
        private int encodedArray;
        private int annotationsDirectory;
        private int annotationsSet;
        private int annotationsSetRefList;
        private int annotation;

        public WriterSizes(DexBuffer a, DexBuffer b) {
            this.plus(a.getTableOfContents(), false);
            this.plus(b.getTableOfContents(), false);
        }

        public WriterSizes clone() {
            try {
                return (WriterSizes)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        public void plus(TableOfContents contents, boolean exact) {
            this.idsDefs += contents.stringIds.size * 4 + contents.typeIds.size * 4 + contents.protoIds.size * 12 + contents.fieldIds.size * 8 + contents.methodIds.size * 8 + contents.classDefs.size * 32;
            this.mapList = 4 + contents.sections.length * 12;
            this.typeList += contents.typeLists.byteCount;
            this.stringData += contents.stringDatas.byteCount;
            this.debugInfo += contents.debugInfos.byteCount;
            this.annotationsDirectory += contents.annotationsDirectories.byteCount;
            this.annotationsSet += contents.annotationSets.byteCount;
            this.annotationsSetRefList += contents.annotationSetRefLists.byteCount;
            if (exact) {
                this.code += contents.codes.byteCount;
                this.classData += contents.classDatas.byteCount;
                this.encodedArray += contents.encodedArrays.byteCount;
                this.annotation += contents.annotations.byteCount;
            } else {
                this.code += (int)Math.ceil((double)contents.codes.byteCount * 1.25);
                this.classData += (int)Math.ceil((double)contents.classDatas.byteCount * 1.34);
                this.encodedArray += contents.encodedArrays.byteCount * 2;
                this.annotation += (int)Math.ceil((double)contents.annotations.byteCount * 1.34);
            }
        }

        public void minusWaste(DexMerger dexMerger) {
            this.header -= dexMerger.headerOut.remaining();
            this.idsDefs -= dexMerger.idsDefsOut.remaining();
            this.mapList -= dexMerger.mapListOut.remaining();
            this.typeList -= dexMerger.typeListOut.remaining();
            this.classData -= dexMerger.classDataOut.remaining();
            this.code -= dexMerger.codeOut.remaining();
            this.stringData -= dexMerger.stringDataOut.remaining();
            this.debugInfo -= dexMerger.debugInfoOut.remaining();
            this.encodedArray -= dexMerger.encodedArrayOut.remaining();
            this.annotationsDirectory -= dexMerger.annotationsDirectoryOut.remaining();
            this.annotationsSet -= dexMerger.annotationSetOut.remaining();
            this.annotationsSetRefList -= dexMerger.annotationSetRefListOut.remaining();
            this.annotation -= dexMerger.annotationOut.remaining();
        }

        public int size() {
            return this.header + this.idsDefs + this.mapList + this.typeList + this.classData + this.code + this.stringData + this.debugInfo + this.encodedArray + this.annotationsDirectory + this.annotationsSet + this.annotationsSetRefList + this.annotation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class IdMerger<T extends Comparable<T>> {
        private final DexBuffer.Section out;

        protected IdMerger(DexBuffer.Section out) {
            this.out = out;
        }

        public final void mergeSorted() {
            TableOfContents.Section aSection = this.getSection(DexMerger.this.dexA.getTableOfContents());
            TableOfContents.Section bSection = this.getSection(DexMerger.this.dexB.getTableOfContents());
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).off = this.out.getPosition();
            DexBuffer.Section inA = aSection.exists() ? DexMerger.this.dexA.open(aSection.off) : null;
            DexBuffer.Section inB = bSection.exists() ? DexMerger.this.dexB.open(bSection.off) : null;
            int aOffset = -1;
            int bOffset = -1;
            int aIndex = 0;
            int bIndex = 0;
            int outCount = 0;
            Comparable a = null;
            Object b = null;
            while (true) {
                boolean advanceB;
                boolean advanceA;
                if (a == null && aIndex < aSection.size) {
                    aOffset = inA.getPosition();
                    a = this.read(inA, DexMerger.this.aIndexMap, aIndex);
                }
                if (b == null && bIndex < bSection.size) {
                    bOffset = inB.getPosition();
                    b = this.read(inB, DexMerger.this.bIndexMap, bIndex);
                }
                if (a != null && b != null) {
                    int compare = a.compareTo(b);
                    advanceA = compare <= 0;
                    advanceB = compare >= 0;
                } else {
                    advanceA = a != null;
                    advanceB = b != null;
                }
                Comparable toWrite = null;
                if (advanceA) {
                    toWrite = a;
                    this.updateIndex(aOffset, DexMerger.this.aIndexMap, aIndex++, outCount);
                    a = null;
                    aOffset = -1;
                }
                if (advanceB) {
                    toWrite = b;
                    this.updateIndex(bOffset, DexMerger.this.bIndexMap, bIndex++, outCount);
                    b = null;
                    bOffset = -1;
                }
                if (toWrite == null) break;
                this.write(toWrite);
                ++outCount;
            }
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).size = outCount;
        }

        public final void mergeUnsorted() {
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).off = this.out.getPosition();
            ArrayList<UnsortedValue> all = new ArrayList<UnsortedValue>();
            all.addAll(this.readUnsortedValues(DexMerger.this.dexA, DexMerger.this.aIndexMap));
            all.addAll(this.readUnsortedValues(DexMerger.this.dexB, DexMerger.this.bIndexMap));
            Collections.sort(all);
            int outCount = 0;
            int i = 0;
            while (i < all.size()) {
                UnsortedValue e1 = (UnsortedValue)all.get(i++);
                this.updateIndex(e1.offset, DexMerger.this.getIndexMap(e1.source), e1.index, outCount - 1);
                while (i < all.size() && e1.compareTo((UnsortedValue)all.get(i)) == 0) {
                    UnsortedValue e2 = (UnsortedValue)all.get(i++);
                    this.updateIndex(e2.offset, DexMerger.this.getIndexMap(e2.source), e2.index, outCount - 1);
                }
                this.write(e1.value);
                ++outCount;
            }
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).size = outCount;
        }

        private List<UnsortedValue> readUnsortedValues(DexBuffer source, IndexMap indexMap) {
            TableOfContents.Section section = this.getSection(source.getTableOfContents());
            if (!section.exists()) {
                return Collections.emptyList();
            }
            ArrayList<UnsortedValue> result = new ArrayList<UnsortedValue>();
            DexBuffer.Section in = source.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                int offset = in.getPosition();
                T value = this.read(in, indexMap, 0);
                result.add(new UnsortedValue(this, source, indexMap, value, i, offset));
            }
            return result;
        }

        abstract TableOfContents.Section getSection(TableOfContents var1);

        abstract T read(DexBuffer.Section var1, IndexMap var2, int var3);

        abstract void updateIndex(int var1, IndexMap var2, int var3, int var4);

        abstract void write(T var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UnsortedValue
        implements Comparable<UnsortedValue> {
            final DexBuffer source;
            final IndexMap indexMap;
            final T value;
            final int index;
            final int offset;
            final /* synthetic */ IdMerger this$1;

            /*
             * WARNING - Possible parameter corruption
             */
            UnsortedValue(DexBuffer source, IndexMap indexMap, T value, int index, int offset) {
                this.this$1 = (IdMerger)n;
                this.source = source;
                this.indexMap = indexMap;
                this.value = value;
                this.index = index;
                this.offset = offset;
            }

            @Override
            public int compareTo(UnsortedValue unsortedValue) {
                return this.value.compareTo(unsortedValue.value);
            }
        }
    }
}

