/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@BaseCmd.Syntax(cmd="d2j-decrypt-string", syntax="[options] <jar>", desc="Decrypt in class file", onlineHelp="https://code.google.com/p/dex2jar/wiki/DecryptStrings")
public class DecryptStringCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output of .jar files, default is $current_dir/[jar-name]-decrypted.jar", argName="out")
    private Path output;
    @BaseCmd.Opt(opt="mo", longOpt="decrypt-method-owner", description="the owner of the mothed which can decrypt the stings, example: java.lang.String", argName="owner")
    private String methodOwner;
    @BaseCmd.Opt(opt="mn", longOpt="decrypt-method-name", description="the owner of the mothed which can decrypt the stings, the method's signature must be static (Ljava/lang/String;)Ljava/lang/String;", argName="name")
    private String methodName;
    @BaseCmd.Opt(opt="cp", longOpt="classpath", description="", argName="cp")
    private String classpath;

    public static void main(String ... args) {
        new DecryptStringCmd().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        Method jmethod;
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        Path jar = new File(this.remainingArgs[0]).toPath();
        if (!Files.exists(jar, new LinkOption[0])) {
            System.err.println(jar + " is not exists");
            return;
        }
        if (this.methodName == null || this.methodOwner == null) {
            System.err.println("Please set --decrypt-method-owner and --decrypt-method-name");
            return;
        }
        if (this.output == null) {
            this.output = Files.isDirectory(jar, new LinkOption[0]) ? new File(jar.getFileName() + "-decrypted.jar").toPath() : new File(String.valueOf(DecryptStringCmd.getBaseName((String)jar.getFileName().toString())) + "-decrypted.jar").toPath();
        }
        if (Files.exists(this.output, new LinkOption[0]) && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            return;
        }
        System.err.println(jar + " -> " + this.output);
        ArrayList<String> list = new ArrayList<String>();
        if (this.classpath != null) {
            list.addAll(Arrays.asList(this.classpath.split(";|:")));
        }
        list.add(jar.toAbsolutePath().toString());
        URL[] urls = new URL[list.size()];
        int i = 0;
        while (i < list.size()) {
            urls[i] = new File((String)list.get(i)).toURI().toURL();
            ++i;
        }
        try {
            URLClassLoader cl = new URLClassLoader(urls);
            jmethod = cl.loadClass(this.methodOwner).getMethod(this.methodName, String.class);
            jmethod.setAccessible(true);
        }
        catch (Exception ex) {
            System.err.println("can't load method: String " + this.methodOwner + "." + this.methodName + "(String), message:" + ex.getMessage());
            return;
        }
        final String methodOwnerInternalType = this.methodOwner.replace('.', '/');
        Throwable throwable = null;
        Object var7_10 = null;
        try (FileSystem outputFileSystem = DecryptStringCmd.createZip((Path)this.output);){
            final Path outputBase = outputFileSystem.getPath("/", new String[0]);
            DecryptStringCmd.walkJarOrDir((Path)jar, (BaseCmd.FileVisitorX)new BaseCmd.FileVisitorX(){

                public void visitFile(Path file, Path relative) throws IOException {
                    if (file.getFileName().toString().endsWith(".class")) {
                        ClassReader cr = new ClassReader(Files.readAllBytes(file));
                        ClassNode cn = new ClassNode();
                        cr.accept((ClassVisitor)cn, 0);
                        for (Object m0 : cn.methods) {
                            MethodNode m = (MethodNode)m0;
                            if (m.instructions == null) continue;
                            AbstractInsnNode p = m.instructions.getFirst();
                            while (p != null) {
                                if (p.getOpcode() == 18) {
                                    LdcInsnNode ldc = (LdcInsnNode)p;
                                    if (ldc.cst instanceof String) {
                                        String v = (String)ldc.cst;
                                        AbstractInsnNode q = p.getNext();
                                        if (q.getOpcode() == 184) {
                                            MethodInsnNode mn = (MethodInsnNode)q;
                                            if (mn.name.equals(DecryptStringCmd.this.methodName) && mn.desc.equals("(Ljava/lang/String;)Ljava/lang/String;") && mn.owner.equals(methodOwnerInternalType)) {
                                                try {
                                                    Object newValue;
                                                    ldc.cst = newValue = jmethod.invoke(null, v);
                                                }
                                                catch (Exception exception) {}
                                                m.instructions.remove(q);
                                            }
                                        }
                                    }
                                }
                                p = p.getNext();
                            }
                        }
                        ClassWriter cw = new ClassWriter(0);
                        cn.accept((ClassVisitor)cw);
                        Files.write(outputBase.resolve(relative), cw.toByteArray(), new OpenOption[0]);
                    } else {
                        Files.copy(file, outputBase.resolve(relative), new CopyOption[0]);
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

