/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

public class WindowsTreePatch
implements LookAndFeelPatch {
    public boolean isApplicable(Environment env) {
        return env.isWindowsLookAndFeel();
    }

    public void patch(Environment env) {
        Color selectionColor = UIManager.getColor("Tree.selectionBackground");
        Color noSelectionColor = UIManager.getColor("Tree.textBackground");
        ColorUIResource focusedSelectedBorderColor = new ColorUIResource(255 - selectionColor.getRed(), 255 - selectionColor.getGreen(), 255 - selectionColor.getBlue());
        ColorUIResource focusedNonSelectedBorderColor = new ColorUIResource(255 - noSelectionColor.getRed(), 255 - noSelectionColor.getGreen(), 255 - noSelectionColor.getBlue());
        UIManager.put("Tree.focusedSelectedBorderColor", focusedSelectedBorderColor);
        UIManager.put("Tree.focusedNonSelectedBorderColor", focusedNonSelectedBorderColor);
        UIManager.put("TreeUI", "net.java.plaf.windows.common.WindowsTreeUI");
    }

    public void unpatch() {
    }
}

