/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.MultilineMessageHelper;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.MissingProjectException;
import org.apache.maven.lifecycle.internal.DependencyContext;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleDependencyResolver;
import org.apache.maven.lifecycle.internal.PhaseRecorder;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginIncompatibleException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.SessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=MojoExecutor.class)
public class MojoExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MojoExecutor.class);
    @Requirement
    private BuildPluginManager pluginManager;
    @Requirement
    private MavenPluginManager mavenPluginManager;
    @Requirement
    private LifecycleDependencyResolver lifeCycleDependencyResolver;
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    private final OwnerReentrantReadWriteLock aggregatorLock = new OwnerReentrantReadWriteLock();
    private final Map<Thread, MojoDescriptor> mojos = new ConcurrentHashMap<Thread, MojoDescriptor>();

    public DependencyContext newDependencyContext(MavenSession session2, List<MojoExecution> mojoExecutions) {
        TreeSet<String> scopesToCollect = new TreeSet<String>();
        TreeSet<String> scopesToResolve = new TreeSet<String>();
        this.collectDependencyRequirements(scopesToResolve, scopesToCollect, mojoExecutions);
        return new DependencyContext(session2.getCurrentProject(), scopesToCollect, scopesToResolve);
    }

    private void collectDependencyRequirements(Set<String> scopesToResolve, Set<String> scopesToCollect, Collection<MojoExecution> mojoExecutions) {
        for (MojoExecution mojoExecution : mojoExecutions) {
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            scopesToResolve.addAll(this.toScopes(mojoDescriptor.getDependencyResolutionRequired()));
            scopesToCollect.addAll(this.toScopes(mojoDescriptor.getDependencyCollectionRequired()));
        }
    }

    private Collection<String> toScopes(String classpath) {
        List<Object> scopes = Collections.emptyList();
        if (StringUtils.isNotEmpty(classpath)) {
            if ("compile".equals(classpath)) {
                scopes = Arrays.asList("compile", "system", "provided");
            } else if ("runtime".equals(classpath)) {
                scopes = Arrays.asList("compile", "runtime");
            } else if ("compile+runtime".equals(classpath)) {
                scopes = Arrays.asList("compile", "system", "provided", "runtime");
            } else if ("runtime+system".equals(classpath)) {
                scopes = Arrays.asList("compile", "system", "runtime");
            } else if ("test".equals(classpath)) {
                scopes = Arrays.asList("compile", "system", "provided", "runtime", "test");
            }
        }
        return Collections.unmodifiableCollection(scopes);
    }

    public void execute(MavenSession session2, List<MojoExecution> mojoExecutions, ProjectIndex projectIndex) throws LifecycleExecutionException {
        DependencyContext dependencyContext = this.newDependencyContext(session2, mojoExecutions);
        PhaseRecorder phaseRecorder = new PhaseRecorder(session2.getCurrentProject());
        for (MojoExecution mojoExecution : mojoExecutions) {
            this.execute(session2, mojoExecution, projectIndex, dependencyContext, phaseRecorder);
        }
    }

    public void execute(MavenSession session2, MojoExecution mojoExecution, ProjectIndex projectIndex, DependencyContext dependencyContext, PhaseRecorder phaseRecorder) throws LifecycleExecutionException {
        this.execute(session2, mojoExecution, projectIndex, dependencyContext);
        phaseRecorder.observeExecution(mojoExecution);
    }

    private void execute(MavenSession session2, MojoExecution mojoExecution, ProjectIndex projectIndex, DependencyContext dependencyContext) throws LifecycleExecutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        try {
            this.mavenPluginManager.checkRequiredMavenVersion(mojoDescriptor.getPluginDescriptor());
        }
        catch (PluginIncompatibleException e2) {
            throw new LifecycleExecutionException(mojoExecution, session2.getCurrentProject(), e2);
        }
        if (mojoDescriptor.isProjectRequired() && !session2.getRequest().isProjectPresent()) {
            MissingProjectException cause = new MissingProjectException("Goal requires a project to execute but there is no POM in this directory (" + session2.getExecutionRootDirectory() + "). Please verify you invoked Maven from the correct directory.");
            throw new LifecycleExecutionException(mojoExecution, null, cause);
        }
        if (mojoDescriptor.isOnlineRequired() && session2.isOffline()) {
            if (MojoExecution.Source.CLI.equals((Object)mojoExecution.getSource())) {
                IllegalStateException cause = new IllegalStateException("Goal requires online mode for execution but Maven is currently offline.");
                throw new LifecycleExecutionException(mojoExecution, session2.getCurrentProject(), cause);
            }
            this.eventCatapult.fire(ExecutionEvent.Type.MojoSkipped, session2, mojoExecution);
            return;
        }
        this.doExecute(session2, mojoExecution, projectIndex, dependencyContext);
    }

    private static void warn(String msg) {
        for (String s : MultilineMessageHelper.format(msg)) {
            LOGGER.warn(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(MavenSession session2, MojoExecution mojoExecution, ProjectIndex projectIndex, DependencyContext dependencyContext) throws LifecycleExecutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        List<MavenProject> forkedProjects = this.executeForkedExecutions(mojoExecution, session2, projectIndex);
        this.ensureDependenciesAreResolved(mojoDescriptor, session2, dependencyContext);
        try (ProjectLock lock = new ProjectLock(session2, mojoDescriptor);){
            this.doExecute2(session2, mojoExecution);
        }
        finally {
            for (MavenProject forkedProject : forkedProjects) {
                forkedProject.setExecutionProject(null);
            }
        }
    }

    private void doExecute2(MavenSession session2, MojoExecution mojoExecution) throws LifecycleExecutionException {
        this.eventCatapult.fire(ExecutionEvent.Type.MojoStarted, session2, mojoExecution);
        try {
            try {
                this.pluginManager.executeMojo(session2, mojoExecution);
            }
            catch (MojoExecutionException | MojoFailureException | PluginConfigurationException | PluginManagerException e2) {
                throw new LifecycleExecutionException(mojoExecution, session2.getCurrentProject(), e2);
            }
            this.eventCatapult.fire(ExecutionEvent.Type.MojoSucceeded, session2, mojoExecution);
        }
        catch (LifecycleExecutionException e3) {
            this.eventCatapult.fire(ExecutionEvent.Type.MojoFailed, session2, mojoExecution, e3);
            throw e3;
        }
    }

    public void ensureDependenciesAreResolved(MojoDescriptor mojoDescriptor, MavenSession session2, DependencyContext dependencyContext) throws LifecycleExecutionException {
        Collection<String> scopesToResolve;
        Collection<String> scopesToCollect;
        MavenProject project2 = dependencyContext.getProject();
        boolean aggregating = mojoDescriptor.isAggregator();
        if (dependencyContext.isResolutionRequiredForCurrentProject()) {
            scopesToCollect = dependencyContext.getScopesToCollectForCurrentProject();
            scopesToResolve = dependencyContext.getScopesToResolveForCurrentProject();
            this.lifeCycleDependencyResolver.resolveProjectDependencies(project2, scopesToCollect, scopesToResolve, session2, aggregating, Collections.emptySet());
            dependencyContext.synchronizeWithProjectState();
        }
        if (aggregating && dependencyContext.isResolutionRequiredForAggregatedProjects(scopesToCollect = this.toScopes(mojoDescriptor.getDependencyCollectionRequired()), scopesToResolve = this.toScopes(mojoDescriptor.getDependencyResolutionRequired()))) {
            for (MavenProject aggregatedProject : session2.getProjects()) {
                if (aggregatedProject == project2) continue;
                this.lifeCycleDependencyResolver.resolveProjectDependencies(aggregatedProject, scopesToCollect, scopesToResolve, session2, aggregating, Collections.emptySet());
            }
        }
        ArtifactFilter artifactFilter = this.getArtifactFilter(mojoDescriptor);
        List<MavenProject> projectsToResolve = LifecycleDependencyResolver.getProjects(session2.getCurrentProject(), session2, mojoDescriptor.isAggregator());
        for (MavenProject projectToResolve : projectsToResolve) {
            projectToResolve.setArtifactFilter(artifactFilter);
        }
    }

    private ArtifactFilter getArtifactFilter(MojoDescriptor mojoDescriptor) {
        String scopeToResolve = mojoDescriptor.getDependencyResolutionRequired();
        String scopeToCollect = mojoDescriptor.getDependencyCollectionRequired();
        ArrayList<String> scopes = new ArrayList<String>(2);
        if (StringUtils.isNotEmpty(scopeToCollect)) {
            scopes.add(scopeToCollect);
        }
        if (StringUtils.isNotEmpty(scopeToResolve)) {
            scopes.add(scopeToResolve);
        }
        if (scopes.isEmpty()) {
            return null;
        }
        return new CumulativeScopeArtifactFilter(scopes);
    }

    public List<MavenProject> executeForkedExecutions(MojoExecution mojoExecution, MavenSession session2, ProjectIndex projectIndex) throws LifecycleExecutionException {
        List<MavenProject> forkedProjects = Collections.emptyList();
        Map<String, List<MojoExecution>> forkedExecutions = mojoExecution.getForkedExecutions();
        if (!forkedExecutions.isEmpty()) {
            this.eventCatapult.fire(ExecutionEvent.Type.ForkStarted, session2, mojoExecution);
            MavenProject project2 = session2.getCurrentProject();
            forkedProjects = new ArrayList<MavenProject>(forkedExecutions.size());
            try {
                for (Map.Entry<String, List<MojoExecution>> fork : forkedExecutions.entrySet()) {
                    String projectId = fork.getKey();
                    int index2 = projectIndex.getIndices().get(projectId);
                    MavenProject forkedProject = projectIndex.getProjects().get(projectId);
                    forkedProjects.add(forkedProject);
                    MavenProject executedProject = forkedProject.clone();
                    forkedProject.setExecutionProject(executedProject);
                    List<MojoExecution> mojoExecutions = fork.getValue();
                    if (mojoExecutions.isEmpty()) continue;
                    try {
                        session2.setCurrentProject(executedProject);
                        session2.getProjects().set(index2, executedProject);
                        projectIndex.getProjects().put(projectId, executedProject);
                        this.eventCatapult.fire(ExecutionEvent.Type.ForkedProjectStarted, session2, mojoExecution);
                        this.execute(session2, mojoExecutions, projectIndex);
                        this.eventCatapult.fire(ExecutionEvent.Type.ForkedProjectSucceeded, session2, mojoExecution);
                    }
                    catch (LifecycleExecutionException e2) {
                        this.eventCatapult.fire(ExecutionEvent.Type.ForkedProjectFailed, session2, mojoExecution, e2);
                        throw e2;
                    }
                    finally {
                        projectIndex.getProjects().put(projectId, forkedProject);
                        session2.getProjects().set(index2, forkedProject);
                        session2.setCurrentProject(project2);
                    }
                }
                this.eventCatapult.fire(ExecutionEvent.Type.ForkSucceeded, session2, mojoExecution);
            }
            catch (LifecycleExecutionException e3) {
                this.eventCatapult.fire(ExecutionEvent.Type.ForkFailed, session2, mojoExecution, e3);
                throw e3;
            }
        }
        return forkedProjects;
    }

    static class OwnerReentrantReadWriteLock
    extends ReentrantReadWriteLock {
        OwnerReentrantReadWriteLock() {
        }

        @Override
        public Thread getOwner() {
            return super.getOwner();
        }
    }

    static class OwnerReentrantLock
    extends ReentrantLock {
        OwnerReentrantLock() {
        }

        @Override
        public Thread getOwner() {
            return super.getOwner();
        }
    }

    private class ProjectLock
    implements AutoCloseable {
        final Lock acquiredAggregatorLock;
        final OwnerReentrantLock acquiredProjectLock;

        ProjectLock(MavenSession session2, MojoDescriptor mojoDescriptor) {
            MojoExecutor.this.mojos.put(Thread.currentThread(), mojoDescriptor);
            if (session2.getRequest().getDegreeOfConcurrency() > 1) {
                String msg;
                String str2;
                MojoDescriptor ownerMojo;
                Thread owner;
                boolean aggregator = mojoDescriptor.isAggregator();
                this.acquiredAggregatorLock = aggregator ? MojoExecutor.this.aggregatorLock.writeLock() : MojoExecutor.this.aggregatorLock.readLock();
                this.acquiredProjectLock = this.getProjectLock(session2);
                if (!this.acquiredAggregatorLock.tryLock()) {
                    owner = MojoExecutor.this.aggregatorLock.getOwner();
                    ownerMojo = owner != null ? (MojoDescriptor)MojoExecutor.this.mojos.get(owner) : null;
                    str2 = ownerMojo != null ? " The " + ownerMojo.getId() : "An";
                    msg = str2 + " aggregator mojo is already being executed in this parallel build, those kind of mojos require exclusive access to reactor to prevent race conditions. This mojo execution will be blocked until the aggregator mojo is done.";
                    MojoExecutor.warn(msg);
                    this.acquiredAggregatorLock.lock();
                }
                if (!this.acquiredProjectLock.tryLock()) {
                    owner = this.acquiredProjectLock.getOwner();
                    ownerMojo = owner != null ? (MojoDescriptor)MojoExecutor.this.mojos.get(owner) : null;
                    str2 = ownerMojo != null ? " The " + ownerMojo.getId() : "A";
                    msg = str2 + " mojo is already being executed on the project " + session2.getCurrentProject().getGroupId() + ":" + session2.getCurrentProject().getArtifactId() + ". This mojo execution will be blocked until the mojo is done.";
                    MojoExecutor.warn(msg);
                    this.acquiredProjectLock.lock();
                }
            } else {
                this.acquiredAggregatorLock = null;
                this.acquiredProjectLock = null;
            }
        }

        @Override
        public void close() {
            if (this.acquiredProjectLock != null) {
                this.acquiredProjectLock.unlock();
            }
            if (this.acquiredAggregatorLock != null) {
                this.acquiredAggregatorLock.unlock();
            }
            MojoExecutor.this.mojos.remove(Thread.currentThread());
        }

        private OwnerReentrantLock getProjectLock(MavenSession session2) {
            OwnerReentrantLock acquiredProjectLock;
            SessionData data2 = session2.getRepositorySession().getData();
            ConcurrentMap locks = (ConcurrentMap)data2.get(ProjectLock.class);
            if (locks == null) {
                data2.set(ProjectLock.class, null, new ConcurrentHashMap());
                locks = (ConcurrentMap)data2.get(ProjectLock.class);
            }
            if ((acquiredProjectLock = (OwnerReentrantLock)locks.get(session2.getCurrentProject())) == null) {
                acquiredProjectLock = new OwnerReentrantLock();
                OwnerReentrantLock prev2 = locks.putIfAbsent(session2.getCurrentProject(), acquiredProjectLock);
                if (prev2 != null) {
                    acquiredProjectLock = prev2;
                }
            }
            return acquiredProjectLock;
        }
    }
}

