/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class TokenMap {
    private int size;
    private TokenMapToken[] tokenMap;
    private boolean ignoreCase;
    private static final int DEFAULT_TOKEN_MAP_SIZE = 52;

    public TokenMap() {
        this(52);
    }

    public TokenMap(int n) {
        this(n, false);
    }

    public TokenMap(boolean bl) {
        this(52, bl);
    }

    public TokenMap(int n, boolean bl) {
        this.size = n;
        this.tokenMap = new TokenMapToken[n];
        this.ignoreCase = bl;
    }

    private void addTokenToBucket(int n, TokenMapToken tokenMapToken) {
        TokenMapToken tokenMapToken2;
        tokenMapToken.nextToken = tokenMapToken2 = this.tokenMap[n];
        this.tokenMap[n] = tokenMapToken;
    }

    public int get(Segment segment, int n, int n2) {
        return this.get(segment.array, n, n2);
    }

    public int get(char[] cArray, int n, int n2) {
        int n3 = n2 - n + 1;
        int n4 = this.getHashCode(cArray, n, n3);
        TokenMapToken tokenMapToken = this.tokenMap[n4];
        if (!this.ignoreCase) {
            block0: while (tokenMapToken != null) {
                if (tokenMapToken.length == n3) {
                    char[] cArray2 = tokenMapToken.text;
                    int n5 = tokenMapToken.offset;
                    int n6 = n;
                    int n7 = n3;
                    while (n7-- > 0) {
                        if (cArray[n6++] == cArray2[n5++]) continue;
                        tokenMapToken = tokenMapToken.nextToken;
                        continue block0;
                    }
                    return tokenMapToken.tokenType;
                }
                tokenMapToken = tokenMapToken.nextToken;
            }
        } else {
            block2: while (tokenMapToken != null) {
                if (tokenMapToken.length == n3) {
                    char[] cArray3 = tokenMapToken.text;
                    int n8 = tokenMapToken.offset;
                    int n9 = n;
                    int n10 = n3;
                    while (n10-- > 0) {
                        if (RSyntaxUtilities.toLowerCase(cArray[n9++]) == cArray3[n8++]) continue;
                        tokenMapToken = tokenMapToken.nextToken;
                        continue block2;
                    }
                    return tokenMapToken.tokenType;
                }
                tokenMapToken = tokenMapToken.nextToken;
            }
        }
        return -1;
    }

    private final int getHashCode(char[] cArray, int n, int n2) {
        return (RSyntaxUtilities.toLowerCase(cArray[n]) + RSyntaxUtilities.toLowerCase(cArray[n + n2 - 1])) % this.size;
    }

    protected boolean isIgnoringCase() {
        return this.ignoreCase;
    }

    public void put(String string, int n) {
        if (this.isIgnoringCase()) {
            this.put(string.toLowerCase().toCharArray(), n);
        } else {
            this.put(string.toCharArray(), n);
        }
    }

    private void put(char[] cArray, int n) {
        int n2 = this.getHashCode(cArray, 0, cArray.length);
        this.addTokenToBucket(n2, new TokenMapToken(cArray, n));
    }

    private static class TokenMapToken {
        char[] text;
        int offset;
        int length;
        int tokenType;
        TokenMapToken nextToken;

        TokenMapToken(char[] cArray, int n) {
            this.text = cArray;
            this.offset = 0;
            this.length = cArray.length;
            this.tokenType = n;
        }

        public String toString() {
            return "[TokenMapToken: " + new String(this.text, this.offset, this.length) + "]";
        }
    }
}

