/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.concurrent;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.concurrent.SessionInformation;
import org.springframework.security.concurrent.SessionRegistry;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.SpringSecurityFilter;
import org.springframework.security.ui.logout.LogoutHandler;
import org.springframework.security.ui.logout.SecurityContextLogoutHandler;
import org.springframework.security.util.UrlUtils;
import org.springframework.util.Assert;

public class ConcurrentSessionFilter
extends SpringSecurityFilter
implements InitializingBean {
    private SessionRegistry sessionRegistry;
    private String expiredUrl;
    private LogoutHandler[] handlers = new LogoutHandler[]{new SecurityContextLogoutHandler()};

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sessionRegistry, (String)"SessionRegistry required");
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl(this.expiredUrl), (String)(this.expiredUrl + " isn't a valid redirect URL"));
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        SessionInformation info;
        HttpSession session = request.getSession(false);
        if (session != null && (info = this.sessionRegistry.getSessionInformation(session.getId())) != null) {
            if (info.isExpired()) {
                this.doLogout(request, response);
                String targetUrl = this.determineExpiredUrl(request, info);
                if (targetUrl != null) {
                    targetUrl = request.getContextPath() + targetUrl;
                    response.sendRedirect(response.encodeRedirectURL(targetUrl));
                } else {
                    response.getWriter().print("This session has been expired (possibly due to multiple concurrent logins being attempted as the same user).");
                    response.flushBuffer();
                }
                return;
            }
            info.refreshLastRequest();
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String determineExpiredUrl(HttpServletRequest request, SessionInformation info) {
        return this.expiredUrl;
    }

    private void doLogout(HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        for (int i = 0; i < this.handlers.length; ++i) {
            this.handlers[i].logout(request, response, auth);
        }
    }

    public void setExpiredUrl(String expiredUrl) {
        this.expiredUrl = expiredUrl;
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public void setLogoutHandlers(LogoutHandler[] handlers) {
        Assert.notNull((Object)handlers);
        this.handlers = handlers;
    }

    public int getOrder() {
        return FilterChainOrder.CONCURRENT_SESSION_FILTER;
    }
}

