/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.jdbcwrapper.ConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLServer2000DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLServer2005DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLServer2008DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLServerDatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLServerPreparedStatementDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLServerStatementDecorator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SQLServerConnectionDecorator
extends ConnectionDecorator {
    private static final Logger logger = Logger.getLogger(SQLServerConnectionDecorator.class);

    protected SQLServerConnectionDecorator(Connection delegate) {
        super(delegate);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.databaseMetaDataDecorator == null) {
            DatabaseMetaData rawDBMD = super.getMetaData();
            if (rawDBMD.getDatabaseProductVersion().startsWith("8")) {
                this.databaseMetaDataDecorator = new SQLServer2000DatabaseMetaDataDecorator(rawDBMD, this);
            } else if (rawDBMD.getDatabaseProductVersion().startsWith("9")) {
                this.databaseMetaDataDecorator = new SQLServer2005DatabaseMetaDataDecorator(rawDBMD, this);
            } else if (rawDBMD.getDatabaseProductVersion().startsWith("10")) {
                this.databaseMetaDataDecorator = new SQLServer2008DatabaseMetaDataDecorator(rawDBMD, this);
            } else {
                logger.warn((Object)("Unknown database product version: " + rawDBMD.getDatabaseProductVersion() + " -- returning generic SQL Server wrapper"));
                this.databaseMetaDataDecorator = new SQLServerDatabaseMetaDataDecorator(rawDBMD, this);
            }
        }
        return this.databaseMetaDataDecorator;
    }

    @Override
    protected PreparedStatement makePreparedStatementDecorator(PreparedStatement pstmt) {
        return new SQLServerPreparedStatementDecorator(this, pstmt);
    }

    @Override
    protected Statement makeStatementDecorator(Statement stmt) {
        return new SQLServerStatementDecorator(this, stmt);
    }
}

