/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPResolverRegistry;
import ca.sqlpower.object.SPVariableResolver;
import ca.sqlpower.object.SPVariableResolverProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.log4j.Logger;
import org.olap4j.OlapConnection;
import org.olap4j.PreparedOlapStatement;

public class SPVariableHelper
implements SPVariableResolver {
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private static final Logger logger = Logger.getLogger(SPVariableHelper.class);
    private boolean globalCollectionResolve = false;
    private final SPObject contextSource;

    public SPVariableHelper(SPObject contextSource) {
        this.contextSource = contextSource;
    }

    public SPObject getContextSource() {
        return this.contextSource;
    }

    public String substitute(String textWithVars) {
        return SPVariableHelper.substitute(textWithVars, this);
    }

    public static String substitute(String textWithVars, SPVariableHelper variableHelper) {
        logger.debug((Object)("Performing variable substitution on " + textWithVars));
        SPResolverRegistry.init(variableHelper.getContextSource());
        StringBuilder text = new StringBuilder();
        Matcher matcher = varPattern.matcher(textWithVars);
        int currentIndex = 0;
        while (!matcher.hitEnd()) {
            if (!matcher.find()) continue;
            String variableName = matcher.group(1);
            Object variableValue = variableName.equals("$") ? "$" : variableHelper.resolve(variableName);
            logger.debug((Object)("Found variable " + variableName + " = " + variableValue));
            text.append(textWithVars.substring(currentIndex, matcher.start()));
            text.append(variableValue);
            currentIndex = matcher.end();
        }
        text.append(textWithVars.substring(currentIndex));
        return text.toString();
    }

    public PreparedStatement substituteForDb(Connection connection, String sql) throws SQLException {
        return SPVariableHelper.substituteForDb(connection, sql, this);
    }

    public static PreparedStatement substituteForDb(Connection connection, String sql, SPVariableHelper variableHelper) throws SQLException {
        SPResolverRegistry.init(variableHelper.getContextSource());
        StringBuilder text = new StringBuilder();
        Matcher matcher = varPattern.matcher(sql);
        LinkedList<Object> vars = new LinkedList<Object>();
        int currentIndex = 0;
        while (!matcher.hitEnd()) {
            if (!matcher.find()) continue;
            String variableName = matcher.group(1);
            if (variableName.equals("$")) {
                vars.add("$");
            } else {
                vars.add(variableHelper.resolve(variableName));
            }
            text.append(sql.substring(currentIndex, matcher.start()));
            text.append("?");
            currentIndex = matcher.end();
        }
        text.append(sql.substring(currentIndex));
        PreparedStatement ps = connection.prepareStatement(text.toString());
        for (int i = 0; i < vars.size(); ++i) {
            ps.setObject(i + 1, vars.get(i));
        }
        return ps;
    }

    public PreparedOlapStatement substituteForDb(OlapConnection connection, String mdxQuery) throws SQLException {
        return SPVariableHelper.substituteForDb(connection, mdxQuery, this);
    }

    public static PreparedOlapStatement substituteForDb(OlapConnection connection, String mdxQuery, SPVariableHelper variableHelper) throws SQLException {
        SPResolverRegistry.init(variableHelper.getContextSource());
        StringBuilder text = new StringBuilder();
        Matcher matcher = varPattern.matcher(mdxQuery);
        LinkedList<Object> vars = new LinkedList<Object>();
        int currentIndex = 0;
        while (!matcher.hitEnd()) {
            if (!matcher.find()) continue;
            String variableName = matcher.group(1);
            if (variableName.equals("$")) {
                vars.add("$");
            } else {
                vars.add(variableHelper.resolve(variableName));
            }
            text.append(mdxQuery.substring(currentIndex, matcher.start()));
            text.append("?");
            currentIndex = matcher.end();
        }
        text.append(mdxQuery.substring(currentIndex));
        PreparedOlapStatement ps = connection.prepareOlapStatement(text.toString());
        for (int i = 0; i < vars.size(); ++i) {
            ps.setObject(i + 1, vars.get(i));
        }
        return ps;
    }

    public static String getNamespace(String varDef) {
        int index = varDef.indexOf("::");
        if (index != -1) {
            return varDef.substring(0, index);
        }
        return null;
    }

    public static String getKey(String varDef) {
        int defValueIndex;
        String returnValue = varDef;
        int namespaceIndex = varDef.indexOf("::");
        if (namespaceIndex != -1) {
            returnValue = returnValue.substring(namespaceIndex + "::".length(), varDef.length());
        }
        if ((defValueIndex = returnValue.indexOf("->")) != -1) {
            returnValue = returnValue.substring(0, defValueIndex);
        }
        return returnValue;
    }

    public static String getDefaultValue(String varDef) {
        int defValueIndex = varDef.indexOf("->");
        if (defValueIndex != -1) {
            return varDef.substring(defValueIndex + "->".length(), varDef.length());
        }
        return null;
    }

    public static String stripDefaultValue(String varDef) {
        int defValueIndex = varDef.indexOf("->");
        if (defValueIndex != -1) {
            return varDef.substring(0, defValueIndex);
        }
        return varDef;
    }

    public SPVariableResolver getResolverForNamespace(String namespace) {
        return SPResolverRegistry.getResolver(this.contextSource, namespace);
    }

    public void setGlobalCollectionResolve(boolean globalCollectionResolve) {
        this.globalCollectionResolve = globalCollectionResolve;
    }

    @Override
    public Object resolve(String key) {
        return this.resolve(SPVariableHelper.stripDefaultValue(key), SPVariableHelper.getDefaultValue(key));
    }

    @Override
    public Object resolve(String key, Object defaultValue) {
        String namespace = SPVariableHelper.getNamespace(key);
        try {
            if (namespace != null) {
                SPVariableResolver resolver = SPResolverRegistry.getResolver(this.contextSource, namespace);
                if (resolver == null) {
                    return defaultValue;
                }
                return resolver.resolve(key, defaultValue);
            }
            SPObject node = this.contextSource;
            do {
                SPVariableResolver resolver;
                if (!(node instanceof SPVariableResolverProvider) || !(resolver = ((SPVariableResolverProvider)((Object)node)).getVariableResolver()).resolves(key)) continue;
                return resolver.resolve(key, defaultValue);
            } while ((node = node.getParent()) != null);
            return defaultValue;
        }
        catch (StackOverflowError soe) {
            throw new RecursiveVariableException();
        }
    }

    @Override
    public Collection<Object> resolveCollection(String key) {
        return this.resolveCollection(SPVariableHelper.stripDefaultValue(key), SPVariableHelper.getDefaultValue(key));
    }

    @Override
    public Collection<Object> resolveCollection(String key, Object defaultValue) {
        LinkedHashSet<Object> results = new LinkedHashSet<Object>();
        String namespace = SPVariableHelper.getNamespace(key);
        try {
            if (namespace != null) {
                List<SPVariableResolver> resolvers = SPResolverRegistry.getResolvers(this.contextSource, namespace);
                for (SPVariableResolver resolver : resolvers) {
                    if (!resolver.resolves(key)) continue;
                    results.addAll(resolver.resolveCollection(key));
                    if (this.globalCollectionResolve) continue;
                    break;
                }
            } else {
                SPObject node = this.contextSource;
                do {
                    SPVariableResolver resolver;
                    if (!(node instanceof SPVariableResolverProvider) || !(resolver = ((SPVariableResolverProvider)((Object)node)).getVariableResolver()).resolves(key)) continue;
                    results.addAll(resolver.resolveCollection(key));
                    if (!this.globalCollectionResolve) break;
                } while ((node = node.getParent()) != null);
            }
            if (results.size() == 0) {
                if (defaultValue == null) {
                    return Collections.emptySet();
                }
                return Collections.singleton(defaultValue);
            }
            return results;
        }
        catch (StackOverflowError soe) {
            throw new RecursiveVariableException();
        }
    }

    @Override
    public boolean resolves(String key) {
        String namespace = SPVariableHelper.getNamespace(key);
        if (namespace != null) {
            return SPResolverRegistry.getResolver(this.contextSource, namespace) != null;
        }
        SPObject node = this.contextSource;
        do {
            SPVariableResolver resolver;
            if (!(node instanceof SPVariableResolverProvider) || !(resolver = ((SPVariableResolverProvider)((Object)node)).getVariableResolver()).resolves(key)) continue;
            return true;
        } while ((node = node.getParent()) != null);
        return false;
    }

    @Override
    public boolean resolvesNamespace(String namespace) {
        return SPResolverRegistry.getResolver(this.contextSource, namespace) != null;
    }

    @Override
    public Collection<Object> matches(String key, String partialValue) {
        HashSet<Object> matches = new HashSet<Object>();
        String namespace = SPVariableHelper.getNamespace(key);
        try {
            if (namespace != null) {
                for (SPVariableResolver resolver : SPResolverRegistry.getResolvers(this.contextSource, namespace)) {
                    if (!resolver.resolves(key)) continue;
                    matches.addAll(resolver.matches(key, partialValue));
                    if (this.globalCollectionResolve) continue;
                    break;
                }
                return matches;
            }
            SPObject node = this.contextSource;
            do {
                SPVariableResolver resolver;
                if (!(node instanceof SPVariableResolverProvider) || !(resolver = ((SPVariableResolverProvider)((Object)node)).getVariableResolver()).resolves(key)) continue;
                matches.addAll(resolver.matches(key, partialValue));
                if (!this.globalCollectionResolve) break;
            } while ((node = node.getParent()) != null);
            return matches;
        }
        catch (StackOverflowError soe) {
            throw new RecursiveVariableException();
        }
    }

    @Override
    public Collection<String> keySet(String namespace) {
        ArrayList<String> results = new ArrayList<String>();
        if (namespace != null) {
            for (SPVariableResolver resolver : SPResolverRegistry.getResolvers(this.contextSource, namespace)) {
                if (!resolver.resolvesNamespace(namespace)) continue;
                results.addAll(resolver.keySet(namespace));
            }
            return results;
        }
        SPObject node = this.contextSource;
        do {
            if (!(node instanceof SPVariableResolverProvider)) continue;
            SPVariableResolver resolver = ((SPVariableResolverProvider)((Object)node)).getVariableResolver();
            results.addAll(resolver.keySet(namespace));
        } while ((node = node.getParent()) != null);
        return results;
    }

    @Override
    public String getNamespace() {
        throw new UnsupportedOperationException("SPVariableHelper is not bound to a namespace.");
    }

    public MultiValueMap getNamespaces() {
        return SPResolverRegistry.getNamespaces(this.contextSource);
    }

    @Override
    public String getUserFriendlyName() {
        return null;
    }

    @Override
    public void delete(String key) {
        throw new UnsupportedOperationException("SPVariableHelper cannot store variables.");
    }

    @Override
    public void store(String key, Object value) {
        throw new UnsupportedOperationException("SPVariableHelper cannot store variables.");
    }

    @Override
    public void update(String key, Object value) {
        throw new UnsupportedOperationException("SPVariableHelper cannot store variables.");
    }

    public class RecursiveVariableException
    extends RuntimeException {
    }
}

