/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.parameters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;

public class NamedParamsDefault
implements NamedParams {
    private Map<String, OneNamedParam> params = new HashMap<String, OneNamedParam>();

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        if (this.params.get(key) != null) {
            throw new DuplicateParamException("Duplicate parameter '" + key + "' detected.");
        }
        OneNamedParam oneParam = new OneNamedParam();
        oneParam.key = key;
        oneParam.defaultValue = defValue;
        oneParam.description = description;
        oneParam.value = "";
        this.params.put(key, oneParam);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        String description = null;
        OneNamedParam theParam = this.params.get(key);
        if (theParam != null) {
            description = theParam.description;
        }
        return description;
    }

    public String getParameterValue(String key) throws UnknownParamException {
        String value = null;
        OneNamedParam theParam = this.params.get(key);
        if (theParam != null) {
            value = theParam.value;
        }
        return value;
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        String value = null;
        OneNamedParam theParam = this.params.get(key);
        if (theParam != null) {
            value = theParam.defaultValue;
        }
        return value;
    }

    public String[] listParameters() {
        Set<String> keySet = this.params.keySet();
        Object[] paramArray = keySet.toArray(new String[0]);
        Arrays.sort(paramArray);
        return paramArray;
    }

    public void setParameterValue(String key, String value) {
        OneNamedParam theParam = this.params.get(key);
        if (theParam != null) {
            theParam.value = value;
        }
    }

    public void eraseParameters() {
        this.params.clear();
    }

    public void clearParameters() {
        String[] keys = this.listParameters();
        for (int idx = 0; idx < keys.length; ++idx) {
            OneNamedParam theParam = this.params.get(keys[idx]);
            if (theParam == null) continue;
            theParam.value = "";
        }
    }

    public void activateParameters() {
    }

    public void copyParametersFrom(NamedParams aParam) {
        if (this.params != null) {
            this.params.clear();
            String[] keys = aParam.listParameters();
            for (int idx = 0; idx < keys.length; ++idx) {
                String value;
                String defValue;
                String desc;
                try {
                    desc = aParam.getParameterDescription(keys[idx]);
                }
                catch (UnknownParamException e) {
                    desc = "";
                }
                try {
                    defValue = aParam.getParameterDefault(keys[idx]);
                }
                catch (UnknownParamException e) {
                    defValue = "";
                }
                try {
                    value = aParam.getParameterValue(keys[idx]);
                }
                catch (UnknownParamException e) {
                    value = "";
                }
                try {
                    this.addParameterDefinition(keys[idx], defValue, desc);
                }
                catch (DuplicateParamException e) {
                    // empty catch block
                }
                this.setParameterValue(keys[idx], value);
            }
        }
    }

    class OneNamedParam {
        public String key;
        public String description;
        public String defaultValue;
        public String value;

        OneNamedParam() {
        }
    }
}

