/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.janino;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

public class JaninoMetaFunction
implements Cloneable {
    public static final String XML_TAG = "formula";
    private String fieldName;
    private String formula;
    private int valueType;
    private int valueLength;
    private int valuePrecision;
    private String replaceField;

    public JaninoMetaFunction(String fieldName, String formula, int valueType, int valueLength, int valuePrecision, String replaceField) {
        this.fieldName = fieldName;
        this.formula = formula;
        this.valueType = valueType;
        this.valueLength = valueLength;
        this.valuePrecision = valuePrecision;
        this.replaceField = replaceField;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            JaninoMetaFunction mf = (JaninoMetaFunction)obj;
            return this.getXML() == mf.getXML();
        }
        return false;
    }

    public Object clone() {
        try {
            JaninoMetaFunction retval = (JaninoMetaFunction)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getXML() {
        String xml = "";
        xml = xml + "<formula>";
        xml = xml + XMLHandler.addTagValue((String)"field_name", (String)this.fieldName);
        xml = xml + XMLHandler.addTagValue((String)"formula_string", (String)this.formula);
        xml = xml + XMLHandler.addTagValue((String)"value_type", (String)ValueMeta.getTypeDesc((int)this.valueType));
        xml = xml + XMLHandler.addTagValue((String)"value_length", (int)this.valueLength);
        xml = xml + XMLHandler.addTagValue((String)"value_precision", (int)this.valuePrecision);
        xml = xml + XMLHandler.addTagValue((String)"replace_field", (String)this.replaceField);
        xml = xml + "</formula>";
        return xml;
    }

    public JaninoMetaFunction(Node calcnode) {
        this.fieldName = XMLHandler.getTagValue((Node)calcnode, (String)"field_name");
        this.formula = XMLHandler.getTagValue((Node)calcnode, (String)"formula_string");
        this.valueType = ValueMeta.getType((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_type"));
        this.valueLength = Const.toInt((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_length"), (int)-1);
        this.valuePrecision = Const.toInt((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_precision"), (int)-1);
        this.replaceField = XMLHandler.getTagValue((Node)calcnode, (String)"replace_field");
    }

    public void saveRep(Repository rep, long id_transformation, long id_step, int nr) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "field_name", this.fieldName);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "formula_string", this.formula);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "value_type", ValueMeta.getTypeDesc((int)this.valueType));
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "value_length", this.valueLength);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "value_precision", this.valuePrecision);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "replace_field", this.replaceField);
    }

    public JaninoMetaFunction(Repository rep, long id_step, int nr) throws KettleException {
        this.fieldName = rep.getStepAttributeString(id_step, nr, "field_name");
        this.formula = rep.getStepAttributeString(id_step, nr, "formula_string");
        this.valueType = ValueMeta.getType((String)rep.getStepAttributeString(id_step, nr, "value_type"));
        this.valueLength = (int)rep.getStepAttributeInteger(id_step, nr, "value_length");
        this.valuePrecision = (int)rep.getStepAttributeInteger(id_step, nr, "value_precision");
        this.replaceField = rep.getStepAttributeString(id_step, nr, "replace_field");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public void setValueLength(int valueLength) {
        this.valueLength = valueLength;
    }

    public int getValuePrecision() {
        return this.valuePrecision;
    }

    public void setValuePrecision(int valuePrecision) {
        this.valuePrecision = valuePrecision;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getReplaceField() {
        return this.replaceField;
    }

    public void setReplaceField(String replaceField) {
        this.replaceField = replaceField;
    }
}

