/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.infobrightoutput;

import com.infobright.etl.model.BrighthouseRecord;
import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.infobrightoutput.KettleValueConverter;

public class KettleRecordPopulator {
    private KettleValueConverter[] conv = null;

    public void populate(BrighthouseRecord record, Object[] row, RowMetaInterface rowMeta) throws KettleValueException {
        if (this.conv == null) {
            this.init(rowMeta);
        }
        for (int colidx = 0; colidx < record.size(); ++colidx) {
            Object value = row[colidx];
            try {
                record.setData(colidx, value, (ValueConverter)this.conv[colidx]);
                continue;
            }
            catch (ValueConverterException e) {
                Throwable cause = e.getCause();
                if (cause instanceof KettleValueException) {
                    throw (KettleValueException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw e;
            }
        }
    }

    private void init(RowMetaInterface rowMeta) {
        int size = rowMeta.size();
        this.conv = new KettleValueConverter[size];
        for (int colidx = 0; colidx < size; ++colidx) {
            ValueMetaInterface meta = rowMeta.getValueMeta(colidx);
            this.conv[colidx] = new KettleValueConverter(meta);
        }
    }
}

