/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.olap.CubeEditPanel;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class EditCubeAction
extends AbstractArchitectAction {
    private final MondrianModel.Cube cube;
    private final Window dialogOwner;

    public EditCubeAction(ArchitectSwingSession session, MondrianModel.Cube cube, PlayPen pp) {
        super(session, pp, "Cube Properties...", "Edit the properties of " + cube.getName() + " in a dialog", (String)null);
        this.dialogOwner = SwingUtilities.getWindowAncestor(pp);
        this.cube = cube;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            CubeEditPanel panel = new CubeEditPanel(this.cube, this.getPlaypen(), this.getSession());
            JDialog dialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)panel, (Component)this.dialogOwner, (String)"Cube Properties", (String)DataEntryPanelBuilder.OK_BUTTON_LABEL);
            dialog.setLocationRelativeTo(this.getSession().getArchitectFrame());
            dialog.setVisible(true);
        }
        catch (SQLObjectException ex) {
            ASUtils.showExceptionDialogNoReport(this.dialogOwner, "Failed to get list of tables in your database. Perhaps the server is not currently accessible.", ex);
        }
    }
}

