/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.layout;

import ca.sqlpower.architect.layout.AbstractLayout;
import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.layout.LayoutNode;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BasicTreeAutoLayout
extends AbstractLayout {
    private static final Logger logger = Logger.getLogger(BasicTreeAutoLayout.class);
    private boolean animationEnabled = true;
    private int numFramesInAnim = 50;
    private Map<LayoutNode, Point> newLocations;
    private Map<LayoutNode, Point> origLocations;
    private int frame = 0;

    private Point doRecursiveLayout(Collection<? extends LayoutNode> nodes, Point startPoint, Map<LayoutNode, Point> alreadyDone) {
        Rectangle b = new Rectangle();
        int x = startPoint.x;
        int y = startPoint.y;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting layout. nodeList=" + nodes + "; startPoint=" + startPoint));
        }
        for (LayoutNode layoutNode : nodes) {
            LayoutNode adjacentNode;
            if (alreadyDone.containsKey(layoutNode)) continue;
            layoutNode.getBounds(b);
            Point newLoc = new Point(x, y);
            alreadyDone.put(layoutNode, newLoc);
            ArrayList<LayoutNode> adjacentNodes = new ArrayList<LayoutNode>();
            for (LayoutEdge edge : layoutNode.getOutboundEdges()) {
                adjacentNode = edge.getHeadNode();
                if (alreadyDone.containsKey(adjacentNode)) continue;
                adjacentNodes.add(adjacentNode);
            }
            for (LayoutEdge edge : layoutNode.getInboundEdges()) {
                adjacentNode = edge.getTailNode();
                if (alreadyDone.containsKey(adjacentNode)) continue;
                adjacentNodes.add(adjacentNode);
            }
            Point finishPoint = this.doRecursiveLayout(adjacentNodes, new Point(x + b.width + 60, y), alreadyDone);
            x = startPoint.x;
            y = Math.max(y + b.height + 10, finishPoint.y);
        }
        return new Point(x, y);
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
    }

    @Override
    public void setup(Collection<? extends LayoutNode> nodes, Collection<? extends LayoutEdge> edges, Rectangle frame) {
        this.origLocations = new HashMap<LayoutNode, Point>();
        for (LayoutNode layoutNode : nodes) {
            this.origLocations.put(layoutNode, layoutNode.getLocation());
        }
        Point p = new Point();
        this.newLocations = new HashMap<LayoutNode, Point>();
        this.doRecursiveLayout(nodes, p, this.newLocations);
        if (logger.isDebugEnabled()) {
            for (Map.Entry<LayoutNode, Point> entry : this.newLocations.entrySet()) {
                LayoutNode node = entry.getKey();
                Point newLoc = entry.getValue();
                Point oldLoc = this.origLocations.get(node);
                logger.debug((Object)("Table " + node.getNodeName() + ": old=" + oldLoc.x + "," + oldLoc.y + "; new=" + newLoc.x + "," + newLoc.y));
            }
        }
    }

    @Override
    public void done() {
        for (Map.Entry<LayoutNode, Point> entry : this.newLocations.entrySet()) {
            entry.getKey().setLocation(entry.getValue().x, entry.getValue().y);
        }
        this.frame = this.numFramesInAnim;
    }

    @Override
    public boolean isDone() {
        return this.frame >= this.numFramesInAnim;
    }

    @Override
    public void nextFrame() {
        ++this.frame;
        double progress = (double)this.frame / (double)this.numFramesInAnim;
        logger.debug((Object)progress);
        for (Map.Entry<LayoutNode, Point> entry : this.newLocations.entrySet()) {
            LayoutNode node = entry.getKey();
            Point newLoc = entry.getValue();
            Point oldLoc = this.origLocations.get(node);
            int x = (int)((double)oldLoc.x + (double)(newLoc.x - oldLoc.x) * progress);
            int y = (int)((double)oldLoc.y + (double)(newLoc.y - oldLoc.y) * progress);
            node.setLocation(x, y);
        }
    }
}

