# This file was automatically generated by bifcl from /usr/obj/ports/zeek-8.0.1/zeek-8.0.1/src/probabilistic/top-k.bif (alternative mode).

export {
##! Functions to probabilistically determine top-k elements.



## Creates a top-k data structure which tracks *size* elements.
##
## size: number of elements to track.
##
## Returns: Opaque pointer to the data structure.
##
## .. zeek:see:: topk_add topk_get_top topk_count topk_epsilon
##    topk_size topk_sum topk_merge topk_merge_prune
global topk_init: function(size: count ): opaque of topk ;


## Add a new observed object to the data structure.
##
## .. note:: The first added object sets the type of data tracked by
##    the top-k data structure. All following values have to be of the same
##    type.
##
## handle: the TopK handle.
##
## value: observed value.
##
## .. zeek:see:: topk_init topk_get_top topk_count topk_epsilon
##    topk_size topk_sum topk_merge topk_merge_prune
global topk_add: function(handle: opaque of topk , value: any ): any ;


## Get the first *k* elements of the top-k data structure.
##
## handle: the TopK handle.
##
## k: number of elements to return.
##
## Returns: vector of the first k elements.
##
## .. zeek:see:: topk_init topk_add topk_count topk_epsilon
##    topk_size topk_sum topk_merge topk_merge_prune
global topk_get_top: function(handle: opaque of topk , k: count ): any_vec ;


## Get an overestimated count of how often a value has been encountered.
##
## .. note:: The value has to be part of the currently tracked elements,
##    otherwise 0 will be returned and an error message will be added to
##    reporter.
##
## handle: the TopK handle.
##
## value: Value to look up count for.
##
## Returns: Overestimated number for how often the element has been encountered.
##
## .. zeek:see:: topk_init topk_add topk_get_top topk_epsilon
##    topk_size topk_sum topk_merge topk_merge_prune
global topk_count: function(handle: opaque of topk , value: any ): count ;


## Get the maximal overestimation for count.
##
## .. note:: Same restrictions as for :zeek:id:`topk_count` apply.
##
## handle: the TopK handle.
##
## value: Value to look up epsilon for.
##
## Returns: Number which represents the maximal overestimation for the count of
##          this element.
##
## .. zeek:see:: topk_init topk_add topk_get_top topk_count
##    topk_size topk_sum topk_merge topk_merge_prune
global topk_epsilon: function(handle: opaque of topk , value: any ): count ;


## Get the number of elements this data structure is supposed to track (given
## on init).
##
## .. note:: Note that the actual number of elements in the data structure can
##    be lower or higher (due to non-pruned merges) than this.
##
## handle: the TopK handle.
##
## Returns: size given during initialization.
##
## .. zeek:see:: topk_init topk_add topk_get_top topk_count topk_epsilon
##    topk_sum topk_merge topk_merge_prune
global topk_size: function(handle: opaque of topk ): count ;


## Get the sum of all counts of all elements in the data structure.
##
## .. note:: This is equal to the number of all inserted objects if the data
##    structure never has been pruned. Do not use after
##    calling :zeek:id:`topk_merge_prune` (will throw a warning message if used
##    afterwards).
##
## handle: the TopK handle.
##
## Returns: sum of all counts.
##
## .. zeek:see:: topk_init topk_add topk_get_top topk_count topk_epsilon
##    topk_size topk_merge topk_merge_prune
global topk_sum: function(handle: opaque of topk ): count ;


## Merge the second top-k data structure into the first.
##
## handle1: the first TopK handle.
##
## handle2: the second TopK handle.
##
## .. note:: This does not remove any elements, the resulting data structure
##    can be bigger than the maximum size given on initialization.
##
## .. zeek:see:: topk_init topk_add topk_get_top topk_count topk_epsilon
##    topk_size topk_sum topk_merge_prune
global topk_merge: function(handle1: opaque of topk , handle2: opaque of topk ): any ;


## Merge the second top-k data structure into the first and prunes the final
## data structure back to the size given on initialization.
##
## .. note:: Use with care and only when being aware of the restrictions this
##    entails. Do not call :zeek:id:`topk_size` or :zeek:id:`topk_add` afterwards,
##    results will probably not be what you expect.
##
## handle1: the TopK handle in which the second TopK structure is merged.
##
## handle2: the TopK handle in which is merged into the first TopK structure.
##
## .. zeek:see:: topk_init topk_add topk_get_top topk_count topk_epsilon
##    topk_size topk_sum topk_merge
global topk_merge_prune: function(handle1: opaque of topk , handle2: opaque of topk ): any ;

} # end of export section
module GLOBAL;
