/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.panelsearch;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.zaproxy.zap.view.panelsearch.ComponentHighlighterProvider;
import org.zaproxy.zap.view.panelsearch.ComponentSearchProvider;
import org.zaproxy.zap.view.panelsearch.FoundComponent;
import org.zaproxy.zap.view.panelsearch.Highlighter;
import org.zaproxy.zap.view.panelsearch.HighlighterResult;
import org.zaproxy.zap.view.panelsearch.InStringSearchQuery;
import org.zaproxy.zap.view.panelsearch.Search;
import org.zaproxy.zap.view.panelsearch.SearchQuery;
import org.zaproxy.zap.view.panelsearch.items.ComponentHighlighter;
import org.zaproxy.zap.view.panelsearch.items.ComponentSearch;

public class SearchAndHighlight {
    private Search search;
    private Highlighter highlighter;
    private HighlighterResult currentHighlighterResult;
    private Component parent;

    public SearchAndHighlight(Component parent) {
        this.parent = parent;
        this.search = new Search(Search.DefaultComponentSearchItems);
        this.highlighter = new Highlighter(Highlighter.DefaultComponentHighlighterItems);
    }

    public void searchAndHighlight(String text) {
        this.clearHighlight();
        if (text != null && !text.isEmpty()) {
            InStringSearchQuery query = new InStringSearchQuery(text);
            ArrayList<FoundComponent> findings = this.search.searchFor(new Object[]{this.parent}, (SearchQuery)query);
            this.currentHighlighterResult = this.highlighter.highlight(findings);
            SwingUtilities.invokeLater(() -> this.parent.repaint());
        }
    }

    public void clearHighlight() {
        if (this.currentHighlighterResult != null) {
            this.highlighter.undoHighlight(this.currentHighlighterResult);
            this.currentHighlighterResult = null;
            SwingUtilities.invokeLater(() -> this.parent.repaint());
        }
    }

    public void registerComponentSearch(ComponentSearch componentSearch) {
        this.search.registerComponentSearch(componentSearch);
    }

    public void registerComponentSearch(ComponentSearchProvider componentSearchProvider) {
        this.search.registerComponentSearch(componentSearchProvider);
    }

    public void removeComponentSearch(ComponentSearch componentSearch) {
        this.search.removeComponentSearch(componentSearch);
    }

    public void removeComponentSearch(ComponentSearchProvider componentSearchProvider) {
        this.search.removeComponentSearch(componentSearchProvider);
    }

    public void registerComponentHighlighter(ComponentHighlighter componentHighlighter) {
        this.clearHighlight();
        this.highlighter.registerComponentHighlighter(componentHighlighter);
    }

    public void registerComponentHighlighter(ComponentHighlighterProvider componentHighlighterProvider) {
        this.clearHighlight();
        this.highlighter.registerComponentHighlighter(componentHighlighterProvider);
    }

    public void removeComponentHighlighter(ComponentHighlighter componentHighlighter) {
        this.clearHighlight();
        this.highlighter.removeComponentHighlighter(componentHighlighter);
    }

    public void removeComponentHighlighter(ComponentHighlighterProvider componentHighlighterProvider) {
        this.clearHighlight();
        this.highlighter.removeComponentHighlighter(componentHighlighterProvider);
    }
}

