/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.table.TableModel;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderEventPublisher;
import org.zaproxy.zap.extension.spider.SpiderMessagesTableModel;
import org.zaproxy.zap.extension.spider.SpiderPanelTableModel;
import org.zaproxy.zap.extension.spider.SpiderResource;
import org.zaproxy.zap.extension.spider.SpiderThread;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.ScanListenner;
import org.zaproxy.zap.model.ScanListenner2;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.spider.SpiderListener;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.SpiderTaskResult;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.Stats;

public class SpiderScan
implements ScanListenner,
SpiderListener,
GenericScanner2 {
    public static final String SPIDER_SCAN_STARTED_STATS = "stats.spider.started";
    public static final String SPIDER_SCAN_STOPPED_STATS = "stats.spider.stopped";
    public static final String SPIDER_SCAN_TIME_STATS = "stats.spider.time";
    public static final String SPIDER_URL_FOUND_STATS = "stats.spider.url.found";
    public static final String SPIDER_URL_ERROR_STATS = "stats.spider.url.error";
    private static final EnumSet<FetchFilter.FetchStatus> FETCH_STATUS_IN_SCOPE = EnumSet.of(FetchFilter.FetchStatus.VALID, FetchFilter.FetchStatus.SEED);
    private static final EnumSet<FetchFilter.FetchStatus> FETCH_STATUS_OUT_OF_SCOPE = EnumSet.of(FetchFilter.FetchStatus.OUT_OF_SCOPE, FetchFilter.FetchStatus.OUT_OF_CONTEXT, FetchFilter.FetchStatus.USER_RULES);
    private final Lock lock = new ReentrantLock();
    private int scanId;
    private Target target;
    private User user;
    private String displayName = "";
    private AtomicInteger numberOfURIsFound;
    private Set<String> foundURIs;
    private List<SpiderResource> resourcesFound;
    private List<SpiderResource> resourcesIoErrors;
    private Set<String> foundURIsOutOfScope;
    private SpiderThread spiderThread = null;
    private State state;
    private int progress;
    private ScanListenner2 listener = null;
    private volatile boolean cleared;
    private SpiderMessagesTableModel messagesTableModel;

    @Deprecated
    public SpiderScan(ExtensionSpider extension, SpiderParam spiderParams, Target target, URI spiderURI, User scanUser, int scanId) {
        this(extension, spiderParams, target, spiderURI, scanUser, scanId, "SpiderScan" + scanId);
    }

    public SpiderScan(ExtensionSpider extension, SpiderParam spiderParams, Target target, URI spiderURI, User scanUser, int scanId, String name) {
        this.scanId = scanId;
        this.target = target;
        this.user = scanUser;
        this.setDisplayName(name);
        this.numberOfURIsFound = new AtomicInteger();
        this.foundURIs = Collections.synchronizedSet(new HashSet());
        this.resourcesFound = Collections.synchronizedList(new ArrayList());
        this.resourcesIoErrors = Collections.synchronizedList(new ArrayList());
        this.foundURIsOutOfScope = Collections.synchronizedSet(new HashSet());
        this.state = State.NOT_STARTED;
        this.spiderThread = new SpiderThread(Integer.toString(scanId), extension, spiderParams, name, this);
        this.spiderThread.setStartURI(spiderURI);
        this.spiderThread.setStartNode(target.getStartNode());
        this.spiderThread.setScanContext(target.getContext());
        this.spiderThread.setScanAsUser(scanUser);
        this.spiderThread.setJustScanInScope(target.isInScopeOnly());
        this.spiderThread.setScanChildren(target.isRecurse());
    }

    @Override
    public int getScanId() {
        return this.scanId;
    }

    public String getState() {
        this.lock.lock();
        try {
            String string = this.state.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public void start() {
        this.lock.lock();
        try {
            if (State.NOT_STARTED.equals((Object)this.state)) {
                this.spiderThread.addSpiderListener(this);
                this.spiderThread.start();
                this.state = State.RUNNING;
                SpiderEventPublisher.publishScanEvent("scan.started", this.scanId, this.target, this.user);
                Stats.incCounter(SPIDER_SCAN_STARTED_STATS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void pauseScan() {
        this.lock.lock();
        try {
            if (State.RUNNING.equals((Object)this.state)) {
                this.spiderThread.pauseScan();
                this.state = State.PAUSED;
                SpiderEventPublisher.publishScanEvent("scan.paused", this.scanId);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resumeScan() {
        this.lock.lock();
        try {
            if (State.PAUSED.equals((Object)this.state)) {
                this.spiderThread.resumeScan();
                this.state = State.RUNNING;
                SpiderEventPublisher.publishScanEvent("scan.resumed", this.scanId);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stopScan() {
        this.lock.lock();
        try {
            if (!State.NOT_STARTED.equals((Object)this.state) && !State.FINISHED.equals((Object)this.state)) {
                this.spiderThread.stopScan();
                this.state = State.FINISHED;
                SpiderEventPublisher.publishScanEvent("scan.stopped", this.scanId);
                Stats.incCounter(SPIDER_SCAN_STOPPED_STATS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<String> getResults() {
        return this.foundURIs;
    }

    public List<SpiderResource> getResourcesFound() {
        return this.resourcesFound;
    }

    public List<SpiderResource> getResourcesIoErrors() {
        return this.resourcesIoErrors;
    }

    public Set<String> getResultsOutOfScope() {
        return this.foundURIsOutOfScope;
    }

    @Override
    public void notifySpiderTaskResult(SpiderTaskResult spiderTaskResult) {
        HttpMessage msg = spiderTaskResult.getHttpMessage();
        HttpRequestHeader requestHeader = msg.getRequestHeader();
        HttpResponseHeader responseHeader = msg.getResponseHeader();
        SpiderResource resource = new SpiderResource(msg.getHistoryRef() != null ? msg.getHistoryRef().getHistoryId() : -1, requestHeader.getMethod(), requestHeader.getURI().toString(), responseHeader.getStatusCode(), responseHeader.getReasonPhrase(), spiderTaskResult.isProcessed(), spiderTaskResult.getReasonNotProcessed());
        if (msg.isResponseFromTargetHost()) {
            this.resourcesFound.add(resource);
            Stats.incCounter(SPIDER_URL_FOUND_STATS);
        } else {
            this.resourcesIoErrors.add(resource);
            Stats.incCounter(SPIDER_URL_ERROR_STATS);
        }
        if (View.isInitialised()) {
            this.addMessageToMessagesTableModel(spiderTaskResult);
        }
    }

    private void addMessageToMessagesTableModel(final SpiderTaskResult spiderTaskResult) {
        if (spiderTaskResult.getHttpMessage().getHistoryRef() == null) {
            return;
        }
        if (EventQueue.isDispatchThread() || this.cleared) {
            if (this.cleared) {
                return;
            }
            if (this.messagesTableModel == null) {
                this.messagesTableModel = new SpiderMessagesTableModel();
            }
            this.messagesTableModel.addHistoryReference(spiderTaskResult.getHttpMessage().getHistoryRef(), spiderTaskResult.isProcessed(), spiderTaskResult.getReasonNotProcessed());
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpiderScan.this.addMessageToMessagesTableModel(spiderTaskResult);
            }
        });
    }

    @Override
    public void spiderComplete(boolean successful) {
        this.lock.lock();
        try {
            this.state = State.FINISHED;
            SpiderEventPublisher.publishScanEvent("scan.completed", this.scanId);
        }
        finally {
            this.lock.unlock();
        }
        if (this.listener != null) {
            this.listener.scanFinshed(this.getScanId(), this.getDisplayName());
        }
    }

    @Override
    public void spiderProgress(int percentageComplete, int numberCrawled, int numberToCrawl) {
        if (this.progress != percentageComplete) {
            this.progress = percentageComplete;
            SpiderEventPublisher.publishScanProgressEvent(this.scanId, percentageComplete);
        }
        if (this.listener != null) {
            this.listener.scanProgress(this.getScanId(), this.getDisplayName(), percentageComplete, 100);
        }
    }

    @Override
    public void foundURI(String uri, String method, FetchFilter.FetchStatus status) {
        this.numberOfURIsFound.incrementAndGet();
        if (FETCH_STATUS_IN_SCOPE.contains((Object)status)) {
            this.foundURIs.add(uri);
        } else if (FETCH_STATUS_OUT_OF_SCOPE.contains((Object)status)) {
            this.foundURIsOutOfScope.add(uri);
        }
    }

    @Override
    public void run() {
    }

    @Override
    public void setScanId(int id) {
        this.scanId = id;
    }

    @Override
    public void setDisplayName(String name) {
        this.displayName = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isStopped() {
        return this.spiderThread.isStopped();
    }

    @Override
    public int getMaximum() {
        return 100;
    }

    public int getNumberOfURIsFound() {
        return this.numberOfURIsFound.get();
    }

    public int getNumberOfNodesAdded() {
        return this.spiderThread.getNumberOfNodesAdded();
    }

    @Override
    public boolean isPaused() {
        return this.spiderThread.isPaused();
    }

    @Override
    public boolean isRunning() {
        return this.spiderThread.isRunning();
    }

    @Override
    public void scanFinshed(String host) {
        this.spiderComplete(true);
        Stats.incCounter(SPIDER_SCAN_TIME_STATS, this.spiderThread.getTimeTakenInMs());
    }

    @Override
    public void scanProgress(String host, int progress, int maximum) {
    }

    public TableModel getResultsTableModel() {
        return this.spiderThread.getResultsTableModel();
    }

    public SpiderPanelTableModel getAddedNodesTableModel() {
        return this.spiderThread.getAddedNodesTableModel();
    }

    TableModel getMessagesTableModel() {
        if (this.messagesTableModel == null) {
            this.messagesTableModel = new SpiderMessagesTableModel();
        }
        return this.messagesTableModel;
    }

    public void setListener(ScanListenner2 listener) {
        this.listener = listener;
    }

    public void setCustomSpiderParsers(List<SpiderParser> customSpiderParsers) {
        this.spiderThread.setCustomSpiderParsers(customSpiderParsers);
    }

    public void setCustomFetchFilters(List<FetchFilter> customFetchFilters) {
        this.spiderThread.setCustomFetchFilters(customFetchFilters);
    }

    public void setCustomParseFilters(List<ParseFilter> customParseFilters) {
        this.spiderThread.setCustomParseFilters(customParseFilters);
    }

    void clear() {
        this.cleared = true;
        if (this.messagesTableModel != null) {
            this.messagesTableModel.clear();
            this.messagesTableModel = null;
        }
    }

    private static enum State {
        NOT_STARTED,
        RUNNING,
        PAUSED,
        FINISHED;

    }
}

