/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.proxies;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.proxies.ProxiesParamProxy;
import org.zaproxy.zap.view.AbstractMultipleOptionsTableModel;

public class OptionsProxiesTableModel
extends AbstractMultipleOptionsTableModel<ProxiesParamProxy> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("proxies.options.table.header.enabled"), Constant.messages.getString("proxies.options.table.header.address"), Constant.messages.getString("proxies.options.table.header.port")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private List<ProxiesParamProxy> proxies = new ArrayList<ProxiesParamProxy>(0);

    @Override
    public List<ProxiesParamProxy> getElements() {
        return this.proxies;
    }

    public void setProxies(List<ProxiesParamProxy> proxies) {
        this.proxies = new ArrayList<ProxiesParamProxy>(proxies.size());
        for (ProxiesParamProxy proxy : proxies) {
            this.proxies.add(new ProxiesParamProxy(proxy));
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.proxies.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((ProxiesParamProxy)this.getElement(rowIndex)).isEnabled();
            }
            case 1: {
                return ((ProxiesParamProxy)this.getElement(rowIndex)).getAddress();
            }
            case 2: {
                return Integer.toString(((ProxiesParamProxy)this.getElement(rowIndex)).getPort());
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && aValue instanceof Boolean) {
            this.proxies.get(rowIndex).setEnabled((Boolean)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

