/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk.impl.http;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointMessage;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointsUiManagerInterface;
import org.zaproxy.zap.view.StandardFieldsDialog;

public class BreakAddEditDialog
extends StandardFieldsDialog {
    private static final String FIELD_LOCATION = "brk.brkpoint.location.label";
    private static final String FIELD_MATCH = "brk.brkpoint.match.label";
    private static final String FIELD_STRING = "brk.brkpoint.string.label";
    private static final String FIELD_INVERSE = "brk.brkpoint.inverse.label";
    private static final String FIELD_IGNORECASE = "brk.brkpoint.ignorecase.label";
    private static final long serialVersionUID = 1L;
    private HttpBreakpointsUiManagerInterface breakPointsManager;
    private boolean add = false;
    private HttpBreakpointMessage breakpoint;

    public BreakAddEditDialog(HttpBreakpointsUiManagerInterface breakPointsManager, Frame owner, Dimension dim) {
        super((Window)owner, "brk.brkpoint.add.title", dim, true);
        this.breakPointsManager = breakPointsManager;
        this.setDefaultCloseOperation(2);
    }

    public void init(HttpBreakpointMessage breakpoint, boolean add) {
        this.add = add;
        this.breakpoint = breakpoint;
        this.removeAllFields();
        if (add) {
            this.setTitle(Constant.messages.getString("brk.brkpoint.add.title"));
        } else {
            this.setTitle(Constant.messages.getString("brk.brkpoint.edit.title"));
        }
        this.addComboField(FIELD_LOCATION, this.getLocations(), this.locToStr(breakpoint.getLocation()));
        this.addComboField(FIELD_MATCH, this.getMatches(), this.matchToStr(breakpoint.getMatch()));
        this.addTextField(FIELD_STRING, breakpoint.getString());
        this.addCheckBoxField(FIELD_INVERSE, breakpoint.isInverse());
        this.addCheckBoxField(FIELD_IGNORECASE, breakpoint.isIgnoreCase());
        this.addPadding();
    }

    private List<String> getLocations() {
        ArrayList<String> list = new ArrayList<String>();
        for (HttpBreakpointMessage.Location loc : HttpBreakpointMessage.Location.values()) {
            list.add(this.locToStr(loc));
        }
        return list;
    }

    private String locToStr(HttpBreakpointMessage.Location loc) {
        return Constant.messages.getString("brk.brkpoint.location." + loc.name());
    }

    private HttpBreakpointMessage.Location strToLoc(String str) {
        for (HttpBreakpointMessage.Location loc : HttpBreakpointMessage.Location.values()) {
            if (!this.locToStr(loc).equals(str)) continue;
            return loc;
        }
        return null;
    }

    private List<String> getMatches() {
        ArrayList<String> list = new ArrayList<String>();
        for (HttpBreakpointMessage.Match match : HttpBreakpointMessage.Match.values()) {
            list.add(this.matchToStr(match));
        }
        return list;
    }

    private String matchToStr(HttpBreakpointMessage.Match match) {
        return Constant.messages.getString("brk.brkpoint.match." + match.name());
    }

    private HttpBreakpointMessage.Match strToMatch(String str) {
        for (HttpBreakpointMessage.Match match : HttpBreakpointMessage.Match.values()) {
            if (!this.matchToStr(match).equals(str)) continue;
            return match;
        }
        return null;
    }

    @Override
    public void save() {
        HttpBreakpointMessage brk = new HttpBreakpointMessage(this.getStringValue(FIELD_STRING), this.strToLoc(this.getStringValue(FIELD_LOCATION)), this.strToMatch(this.getStringValue(FIELD_MATCH)), this.getBoolValue(FIELD_INVERSE), this.getBoolValue(FIELD_IGNORECASE));
        if (this.add) {
            this.breakPointsManager.addBreakpoint(brk);
            this.dispose();
        } else {
            this.breakPointsManager.editBreakpoint(this.breakpoint, brk);
            this.breakpoint = null;
            this.dispose();
        }
    }

    @Override
    public String validateFields() {
        if (this.isEmptyField(FIELD_STRING)) {
            return Constant.messages.getString("brk.brkpoint.error.nostr");
        }
        if (HttpBreakpointMessage.Match.regex.equals((Object)this.strToMatch(this.getStringValue(FIELD_MATCH)))) {
            try {
                Pattern.compile(this.getStringValue(FIELD_STRING));
            }
            catch (Exception e) {
                return Constant.messages.getString("brk.brkpoint.error.regex");
            }
        }
        if (this.getStringValue(FIELD_STRING).contains("#") && HttpBreakpointMessage.Location.url.equals((Object)this.strToLoc(this.getStringValue(FIELD_LOCATION))) && HttpBreakpointMessage.Match.contains.equals((Object)this.strToMatch(this.getStringValue(FIELD_MATCH)))) {
            return Constant.messages.getString("brk.brkpoint.warn.urlfragment");
        }
        return null;
    }

    @Override
    public void cancelPressed() {
        this.dispose();
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.addbreak";
    }
}

