/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.parosproxy.paros.model.FileCopier;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.control.ControlOverrides;
import org.zaproxy.zap.utils.I18N;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public final class Constant {
    public static final String PROGRAM_NAME = "OWASP ZAP";
    public static final String PROGRAM_NAME_SHORT = "ZAP";
    @Deprecated
    public static final String ZAP_HOMEPAGE = "http://www.owasp.org/index.php/ZAP";
    @Deprecated
    public static final String ZAP_EXTENSIONS_PAGE = "https://github.com/zaproxy/zap-extensions";
    public static final String ZAP_TEAM = "ZAP Dev Team";
    public static final String PAROS_TEAM = "Chinotec Technologies";
    private static final String DEV_VERSION = "Dev Build";
    public static final String ALPHA_VERSION = "alpha";
    public static final String BETA_VERSION = "beta";
    private static final String VERSION_ELEMENT = "version";
    static final long VERSION_TAG = 20011001L;
    private static final long V_2_10_0_TAG = 20010000L;
    private static final long V_2_9_0_TAG = 2009000L;
    private static final long V_2_8_0_TAG = 2008000L;
    private static final long V_2_7_0_TAG = 2007000L;
    private static final long V_2_5_0_TAG = 2005000L;
    private static final long V_2_4_3_TAG = 2004003L;
    private static final long V_2_3_1_TAG = 2003001L;
    private static final long V_2_2_2_TAG = 2002002L;
    private static final long V_2_2_0_TAG = 2002000L;
    private static final long V_2_1_0_TAG = 2001000L;
    private static final long V_2_0_0_TAG = 2000000L;
    private static final long V_1_4_1_TAG = 1004001L;
    private static final long V_1_3_1_TAG = 1003001L;
    private static final long V_1_3_0_TAG = 1003000L;
    private static final long V_1_2_1_TAG = 1002001L;
    private static final long V_1_2_0_TAG = 1002000L;
    private static final long V_1_1_0_TAG = 1001000L;
    private static final long V_1_0_0_TAG = 1000000L;
    private static final long V_PAROS_TAG = 30020013L;
    public static String PROGRAM_VERSION = "Dev Build";
    public static String PROGRAM_TITLE = "OWASP ZAP " + PROGRAM_VERSION;
    public static final String SYSTEM_PAROS_USER_LOG = "zap.user.log";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    @Deprecated
    public static final String FILE_CONFIG_DEFAULT = "xml/config.xml";
    public static final String FILE_CONFIG_NAME = "config.xml";
    public static final String FOLDER_PLUGIN = "plugin";
    @Deprecated
    public static final String FOLDER_FILTER = "filter";
    public static final String FOLDER_SESSION_DEFAULT = "session";
    public static final String DBNAME_TEMPLATE = "db" + System.getProperty("file.separator") + "zapdb";
    public static final String MESSAGES_PREFIX = "Messages";
    public static final String MESSAGES_EXTENSION = ".properties";
    public static final String DBNAME_UNTITLED_DEFAULT = "session" + System.getProperty("file.separator") + "untitled";
    public String FILE_CONFIG = "config.xml";
    public String FOLDER_SESSION = "session";
    public String DBNAME_UNTITLED = this.FOLDER_SESSION + System.getProperty("file.separator") + "untitled";
    public static final String FILE_PROGRAM_SPLASH = "resource/zap128x128.png";
    public static String ACCELERATOR_UNDO = "control Z";
    public static String ACCELERATOR_REDO = "control Y";
    public static String ACCELERATOR_TRIGGER_KEY = "Control";
    private static Constant instance = null;
    public static final int MAX_HOST_CONNECTION = 15;
    public static final int MAX_THREADS_PER_SCAN = 50;
    public static final String USER_AGENT = "";
    private static String staticEyeCatcher = "0W45pz4p";
    private static final String USER_CONTEXTS_DIR = "contexts";
    private static final String USER_POLICIES_DIR = "policies";
    private static final String ZAP_CONTAINER_FILE = "/zap/container";
    private static final String FLATPAK_FILE = "/.flatpak-info";
    public static final String FLATPAK_NAME = "flatpak";
    private static final String SNAP_FILE = "meta/snap.yaml";
    public static final String SNAP_NAME = "snapcraft";
    private static final String WEBSWING_ENVVAR = "WEBSWING_VERSION";
    public static final String WEBSWING_NAME = "webswing";
    private static String zapHome = null;
    private static String zapStd = null;
    private static String zapInstall = null;
    private static Boolean onKali = null;
    private static Boolean inContainer = null;
    private static String containerName;
    private static Boolean lowMemoryOption;
    public static I18N messages;
    private static final Locale SYSTEMS_LOCALE;
    private static final String PATH_BUNDLED_CONFIG_XML = "/org/zaproxy/zap/resources/config.xml";
    public static final String LANG_DIR = "lang";
    public static final String VULNERABILITIES_PREFIX = "vulnerabilities";
    @Deprecated
    public static String VULNS_BASE;
    public static final String VULNERABILITIES_EXTENSION = ".xml";
    private static boolean devMode;
    private static boolean silent;
    public String DIRBUSTER_DIR;
    public String DIRBUSTER_CUSTOM_DIR = this.DIRBUSTER_DIR = "dirbuster";
    public String FUZZER_DIR = "fuzzers";
    public static String FOLDER_LOCAL_PLUGIN;
    public static final URL OK_FLAG_IMAGE_URL;
    public static final URL INFO_FLAG_IMAGE_URL;
    public static final URL LOW_FLAG_IMAGE_URL;
    public static final URL MED_FLAG_IMAGE_URL;
    public static final URL HIGH_FLAG_IMAGE_URL;
    public static final URL BLANK_IMAGE_URL;
    public static final URL SPIDER_IMAGE_URL;
    private static Logger LOG;
    private static final Pattern patternWindows;
    private static final Pattern patternLinux;
    private static final Pattern patternMacOsX;

    public static String getEyeCatcher() {
        return staticEyeCatcher;
    }

    public static void setEyeCatcher(String eyeCatcher) {
        staticEyeCatcher = eyeCatcher;
    }

    public Constant() {
        this(null);
    }

    private Constant(ControlOverrides overrides) {
        this.initializeFilesAndDirectories(overrides);
        this.setAcceleratorKeys();
    }

    public static String getDefaultHomeDirectory(boolean incDevOption) {
        if (zapStd == null) {
            zapStd = System.getProperty("user.home");
            if (zapStd == null) {
                zapStd = ".";
            }
            zapStd = Constant.isLinux() ? zapStd + FILE_SEPARATOR + "." + PROGRAM_NAME_SHORT : (Constant.isMacOsX() ? zapStd + FILE_SEPARATOR + "Library" + FILE_SEPARATOR + "Application Support" + FILE_SEPARATOR + PROGRAM_NAME_SHORT : zapStd + FILE_SEPARATOR + PROGRAM_NAME);
        }
        if (incDevOption && (Constant.isDevMode() || Constant.isDailyBuild())) {
            return zapStd + "_D";
        }
        return zapStd;
    }

    public void copyDefaultConfigs(File f, boolean forceReset) throws IOException, ConfigurationException {
        FileCopier copier = new FileCopier();
        File oldf = Constant.isDevMode() || Constant.isDailyBuild() ? new File(Constant.getDefaultHomeDirectory(false) + FILE_SEPARATOR + FILE_CONFIG_NAME) : new File(zapHome + FILE_SEPARATOR + "zap" + FILE_SEPARATOR + FILE_CONFIG_NAME);
        if (!forceReset && oldf.exists() && Paths.get(zapHome, new String[0]).equals(Paths.get(Constant.getDefaultHomeDirectory(true), new String[0]))) {
            LOG.info("Copying defaults from " + oldf.getAbsolutePath() + " to " + this.FILE_CONFIG);
            copier.copy(oldf, f);
            if (Constant.isDevMode() || Constant.isDailyBuild()) {
                ZapXmlConfiguration newConfig = new ZapXmlConfiguration(f);
                newConfig.setProperty("start.downloadDir", FOLDER_LOCAL_PLUGIN);
                newConfig.save();
            }
        } else {
            LOG.info("Copying default configuration to " + this.FILE_CONFIG);
            this.copyDefaultConfigFile();
        }
    }

    private void copyDefaultConfigFile() throws IOException {
        Path configFile = Paths.get(this.FILE_CONFIG, new String[0]);
        Constant.copyFileToHome(configFile, FILE_CONFIG_DEFAULT, PATH_BUNDLED_CONFIG_XML);
        try {
            Constant.setLatestVersion(new ZapXmlConfiguration(configFile.toFile()));
        }
        catch (ConfigurationException e) {
            throw new IOException("Failed to set the latest version:", e);
        }
    }

    private static void setLatestVersion(XMLConfiguration config) throws ConfigurationException {
        config.setProperty(VERSION_ELEMENT, 20011001L);
        config.save();
    }

    private static void copyFileToHome(Path targetFile, String sourceFilePath, String fallbackResource) throws IOException {
        Path defaultConfig = Paths.get(Constant.getZapInstall(), sourceFilePath);
        if (Files.exists(defaultConfig, new LinkOption[0])) {
            Files.copy(defaultConfig, targetFile, StandardCopyOption.REPLACE_EXISTING);
        } else {
            try (InputStream is = Constant.class.getResourceAsStream(fallbackResource);){
                if (is == null) {
                    throw new IOException("Bundled resource not found: " + fallbackResource);
                }
                Files.copy(is, targetFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static URL getUrlDefaultConfigFile() {
        Path path = Constant.getPathDefaultConfigFile();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException e) {
                LOG.debug("Failed to convert file system path:", (Throwable)e);
            }
        }
        return Constant.class.getResource(PATH_BUNDLED_CONFIG_XML);
    }

    public void initializeFilesAndDirectories() {
        this.initializeFilesAndDirectories(null);
    }

    private void initializeFilesAndDirectories(ControlOverrides overrides) {
        block44: {
            FileCopier copier = new FileCopier();
            File f = null;
            PROGRAM_VERSION = Constant.getVersionFromManifest();
            PROGRAM_TITLE = "OWASP ZAP " + PROGRAM_VERSION;
            if (zapHome == null) {
                zapHome = Constant.getDefaultHomeDirectory(true);
            }
            zapHome = Constant.getAbsolutePath(zapHome);
            f = new File(zapHome);
            this.FILE_CONFIG = zapHome + this.FILE_CONFIG;
            this.FOLDER_SESSION = zapHome + this.FOLDER_SESSION;
            this.DBNAME_UNTITLED = zapHome + this.DBNAME_UNTITLED;
            this.DIRBUSTER_CUSTOM_DIR = zapHome + this.DIRBUSTER_DIR;
            this.FUZZER_DIR = zapHome + this.FUZZER_DIR;
            FOLDER_LOCAL_PLUGIN = zapHome + FOLDER_PLUGIN;
            try {
                System.setProperty(SYSTEM_PAROS_USER_LOG, zapHome);
                if (!f.isDirectory()) {
                    if (f.exists()) {
                        System.err.println("The home path is not a directory: " + zapHome);
                        System.exit(1);
                    }
                    if (!f.mkdir()) {
                        System.err.println("Unable to create home directory: " + zapHome);
                        System.err.println("Is the path correct and there's write permission?");
                        System.exit(1);
                    }
                } else if (!f.canWrite()) {
                    System.err.println("The home path is not writable: " + zapHome);
                    System.exit(1);
                } else {
                    Path installDir = Paths.get(Constant.getZapInstall(), new String[0]).toRealPath(new LinkOption[0]);
                    if (installDir.equals(Paths.get(zapHome, new String[0]).toRealPath(new LinkOption[0]))) {
                        System.err.println("The install dir should not be used as home dir: " + installDir);
                        System.exit(1);
                    }
                }
                this.setUpLogging();
                f = new File(this.FILE_CONFIG);
                if (!f.isFile()) {
                    this.copyDefaultConfigs(f, false);
                }
                if (!(f = new File(this.FOLDER_SESSION)).isDirectory()) {
                    LOG.info("Creating directory " + this.FOLDER_SESSION);
                    if (!f.mkdir()) {
                        System.out.println("Failed to create directory " + f.getAbsolutePath());
                    }
                }
                if (!(f = new File(this.DIRBUSTER_CUSTOM_DIR)).isDirectory()) {
                    LOG.info("Creating directory " + this.DIRBUSTER_CUSTOM_DIR);
                    if (!f.mkdir()) {
                        System.out.println("Failed to create directory " + f.getAbsolutePath());
                    }
                }
                if (!(f = new File(this.FUZZER_DIR)).isDirectory()) {
                    LOG.info("Creating directory " + this.FUZZER_DIR);
                    if (!f.mkdir()) {
                        System.out.println("Failed to create directory " + f.getAbsolutePath());
                    }
                }
                if (!(f = new File(FOLDER_LOCAL_PLUGIN)).isDirectory()) {
                    LOG.info("Creating directory " + FOLDER_LOCAL_PLUGIN);
                    if (!f.mkdir()) {
                        System.out.println("Failed to create directory " + f.getAbsolutePath());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Unable to initialize home directory! " + e.getMessage());
                e.printStackTrace(System.err);
                System.exit(1);
            }
            try {
                try {
                    ZapXmlConfiguration config = new ZapXmlConfiguration(this.FILE_CONFIG);
                    config.setAutoSave(false);
                    long ver = config.getLong(VERSION_ELEMENT);
                    if (ver == 20011001L || Constant.isDevMode() || Constant.isDailyBuild()) break block44;
                    LOG.info("Backing up config file to " + this.FILE_CONFIG + ".bak");
                    f = new File(this.FILE_CONFIG);
                    try {
                        copier.copy(f, new File(this.FILE_CONFIG + ".bak"));
                    }
                    catch (IOException e) {
                        String msg = "Failed to backup config file " + this.FILE_CONFIG + " to " + this.FILE_CONFIG + ".bak " + e.getMessage();
                        System.err.println(msg);
                        LOG.error(msg, (Throwable)e);
                    }
                    if (ver == 30020013L) {
                        this.upgradeFrom1_1_0(config);
                        this.upgradeFrom1_2_0(config);
                    }
                    if (ver <= 1000000L) {
                        // empty if block
                    }
                    if (ver <= 1001000L) {
                        this.upgradeFrom1_1_0(config);
                    }
                    if (ver <= 1002000L) {
                        this.upgradeFrom1_2_0(config);
                    }
                    if (ver <= 1002001L) {
                        // empty if block
                    }
                    if (ver <= 1003000L) {
                        // empty if block
                    }
                    if (ver <= 1003001L) {
                        // empty if block
                    }
                    if (ver <= 1004001L) {
                        this.upgradeFrom1_4_1(config);
                    }
                    if (ver <= 2000000L) {
                        this.upgradeFrom2_0_0(config);
                    }
                    if (ver <= 2001000L) {
                        // empty if block
                    }
                    if (ver <= 2002000L) {
                        this.upgradeFrom2_2_0(config);
                    }
                    if (ver <= 2002002L) {
                        this.upgradeFrom2_2_2(config);
                    }
                    if (ver <= 2003001L) {
                        this.upgradeFrom2_3_1(config);
                    }
                    if (ver <= 2004003L) {
                        this.upgradeFrom2_4_3(config);
                    }
                    if (ver <= 2005000L) {
                        Constant.upgradeFrom2_5_0(config);
                    }
                    if (ver <= 2007000L) {
                        Constant.upgradeFrom2_7_0(config);
                    }
                    if (ver <= 2008000L) {
                        Constant.upgradeFrom2_8_0(config);
                    }
                    if (ver <= 2009000L) {
                        Constant.upgradeFrom2_9_0(config);
                    }
                    if (ver <= 20010000L) {
                        Constant.upgradeFrom2_10_0(config);
                    }
                    Constant.updateCfuFromDefaultConfig(config);
                    LOG.info("Upgraded from " + ver);
                    Constant.setLatestVersion(config);
                }
                catch (NoSuchElementException | ConfigurationException | ConversionException e) {
                    this.handleMalformedConfigFile(e);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to upgrade config file " + this.FILE_CONFIG + " " + e.getMessage());
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
        Locale locale = this.loadLocale(overrides);
        Locale.setDefault(locale);
        messages = new I18N(locale);
    }

    private Locale loadLocale(ControlOverrides overrides) {
        try {
            String lang = null;
            if (overrides != null) {
                lang = overrides.getOrderedConfigs().get("view.locale");
            }
            if (lang == null || lang.isEmpty()) {
                ZapXmlConfiguration config = new ZapXmlConfiguration(this.FILE_CONFIG);
                config.setAutoSave(false);
                lang = config.getString("view.locale", "en_GB");
                if (lang.length() == 0) {
                    lang = "en_GB";
                }
            }
            String[] langArray = lang.split("_");
            return new Locale(langArray[0], langArray[1]);
        }
        catch (Exception e) {
            System.out.println("Failed to load locale " + e);
            return Locale.ENGLISH;
        }
    }

    private void setUpLogging() throws IOException {
        Constant.backupLegacyLog4jConfig();
        String fileName = "log4j2.properties";
        File logFile = new File(zapHome, fileName);
        if (!logFile.exists()) {
            String defaultConfig = "/org/zaproxy/zap/resources/log4j2-home.properties";
            Constant.copyFileToHome(logFile.toPath(), "xml/" + fileName, defaultConfig);
        }
        Configurator.reconfigure(logFile.toURI());
    }

    private static void backupLegacyLog4jConfig() {
        String fileName = "log4j.properties";
        Path backupLegacyConfig = Paths.get(zapHome, fileName + ".bak");
        if (Files.exists(backupLegacyConfig, new LinkOption[0])) {
            Constant.logAndPrintInfo("Ignoring legacy log4j.properties file, backup already exists.");
            return;
        }
        Path legacyConfig = Paths.get(zapHome, fileName);
        if (Files.exists(legacyConfig, new LinkOption[0])) {
            Constant.logAndPrintInfo("Creating backup of legacy log4j.properties file...");
            try {
                Files.move(legacyConfig, backupLegacyConfig, new CopyOption[0]);
            }
            catch (IOException e) {
                Constant.logAndPrintError("Failed to backup legacy Log4j configuration file:", e);
            }
        }
    }

    private void handleMalformedConfigFile(Exception e) throws IOException {
        Constant.logAndPrintError("Failed to load/upgrade config file:", e);
        try {
            Path backupPath = Paths.get(zapHome, "config-" + Math.random() + ".xml.bak");
            Constant.logAndPrintInfo("Creating back up for user inspection: " + backupPath);
            Files.copy(Paths.get(this.FILE_CONFIG, new String[0]), backupPath, new CopyOption[0]);
            Constant.logAndPrintInfo("Back up successfully created.");
        }
        catch (IOException ioe) {
            Constant.logAndPrintError("Failed to backup file:", ioe);
        }
        Constant.logAndPrintInfo("Using default config file...");
        this.copyDefaultConfigFile();
    }

    private static void logAndPrintError(String message, Exception e) {
        LOG.error(message, (Throwable)e);
        System.err.println(message);
        e.printStackTrace();
    }

    private static void logAndPrintInfo(String message) {
        LOG.info(message);
        System.out.println(message);
    }

    private void copyProperty(XMLConfiguration fromConfig, XMLConfiguration toConfig, String key) {
        toConfig.setProperty(key, fromConfig.getProperty(key));
    }

    private void copyAllProperties(XMLConfiguration fromConfig, XMLConfiguration toConfig, String prefix) {
        Iterator<String> iter = fromConfig.getKeys(prefix);
        while (iter.hasNext()) {
            String key = iter.next();
            this.copyProperty(fromConfig, toConfig, key);
        }
    }

    private void upgradeFrom1_1_0(XMLConfiguration config) throws ConfigurationException {
        ZapXmlConfiguration newConfig = new ZapXmlConfiguration(Constant.getUrlDefaultConfigFile());
        newConfig.setAutoSave(false);
        this.copyAllProperties(newConfig, config, "pscans");
    }

    private void upgradeFrom1_2_0(XMLConfiguration config) throws ConfigurationException {
        ZapXmlConfiguration newConfig = new ZapXmlConfiguration(Constant.getUrlDefaultConfigFile());
        newConfig.setAutoSave(false);
        this.copyProperty(newConfig, config, "view.brkPanelView");
        this.copyProperty(newConfig, config, "view.showMainToolbar");
    }

    private void upgradeFrom1_4_1(XMLConfiguration config) {
        String elementBaseKey;
        Object[] data;
        String baseKey;
        String host;
        String elementBaseKey2;
        int i;
        Object postForm = config.getProperty("spider.postform");
        if (postForm != null) {
            boolean enabled = !"0".equals(postForm.toString());
            config.setProperty("spider.postform", enabled);
            config.setProperty("spider.processform", enabled);
        }
        String[] tokens = config.getStringArray("session.tokens");
        for (i = 0; i < tokens.length; ++i) {
            elementBaseKey2 = "httpsessions.tokens.token(" + i + ").";
            config.setProperty(elementBaseKey2 + "name", tokens[i]);
            config.setProperty(elementBaseKey2 + "enabled", Boolean.TRUE);
        }
        config.clearTree(FOLDER_SESSION_DEFAULT);
        tokens = config.getStringArray("anticsrf.tokens");
        config.clearTree("anticsrf.tokens");
        for (i = 0; i < tokens.length; ++i) {
            elementBaseKey2 = "anticsrf.tokens.token(" + i + ").";
            config.setProperty(elementBaseKey2 + "name", tokens[i]);
            config.setProperty(elementBaseKey2 + "enabled", Boolean.TRUE);
        }
        ArrayList<Object[]> oldData = new ArrayList<Object[]>();
        int i2 = 0;
        while ((host = config.getString((baseKey = "invoke.A" + i2 + ".") + "name")) != null && !USER_AGENT.equals(host)) {
            data = new Object[]{host, config.getString(baseKey + "directory", USER_AGENT), config.getString(baseKey + "command"), config.getString(baseKey + "parameters"), config.getBoolean(baseKey + "output", true), config.getBoolean(baseKey + "note", false)};
            oldData.add(data);
            ++i2;
        }
        config.clearTree("invoke.A");
        int size = oldData.size();
        for (i2 = 0; i2 < size; ++i2) {
            elementBaseKey = "invoke.apps.app(" + i2 + ").";
            data = (Object[])oldData.get(i2);
            config.setProperty(elementBaseKey + "name", data[0]);
            config.setProperty(elementBaseKey + "directory", data[1]);
            config.setProperty(elementBaseKey + "command", data[2]);
            config.setProperty(elementBaseKey + "parameters", data[3]);
            config.setProperty(elementBaseKey + "output", data[4]);
            config.setProperty(elementBaseKey + "note", data[5]);
            config.setProperty(elementBaseKey + "enabled", Boolean.TRUE);
        }
        oldData = new ArrayList();
        i2 = 0;
        while ((host = config.getString((baseKey = "connection.auth.A" + i2 + ".") + "hostName")) != null && !USER_AGENT.equals(host)) {
            data = new Object[]{host, Integer.valueOf(config.getString(baseKey + "port", "80")), config.getString(baseKey + "userName"), config.getString(baseKey + "password"), config.getString(baseKey + "realm")};
            oldData.add(data);
            ++i2;
        }
        config.clearTree("connection.auth.A");
        size = oldData.size();
        for (i2 = 0; i2 < size; ++i2) {
            elementBaseKey = "connection.auths.auth(" + i2 + ").";
            data = (Object[])oldData.get(i2);
            config.setProperty(elementBaseKey + "name", "Auth " + i2);
            config.setProperty(elementBaseKey + "hostName", data[0]);
            config.setProperty(elementBaseKey + "port", data[1]);
            config.setProperty(elementBaseKey + "userName", data[2]);
            config.setProperty(elementBaseKey + "password", data[3]);
            config.setProperty(elementBaseKey + "realm", data[4]);
            config.setProperty(elementBaseKey + "enabled", Boolean.TRUE);
        }
        String[] names = config.getStringArray("pscans.names");
        oldData = new ArrayList();
        for (String pscanName : names) {
            String baseKey2 = "pscans." + pscanName + ".";
            Object[] data2 = new Object[]{pscanName, config.getString(baseKey2 + "type"), config.getString(baseKey2 + "config"), config.getString(baseKey2 + "reqUrlRegex"), config.getString(baseKey2 + "reqHeadRegex"), config.getString(baseKey2 + "resHeadRegex"), config.getString(baseKey2 + "resBodyRegex"), config.getBoolean(baseKey2 + "enabled")};
            oldData.add(data2);
        }
        config.clearTree("pscans.names");
        for (String pscanName : names) {
            config.clearTree("pscans." + pscanName);
        }
        int size2 = oldData.size();
        for (int i3 = 0; i3 < size2; ++i3) {
            String elementBaseKey3 = "pscans.autoTagScanners.scanner(" + i3 + ").";
            Object[] data3 = (Object[])oldData.get(i3);
            config.setProperty(elementBaseKey3 + "name", data3[0]);
            config.setProperty(elementBaseKey3 + "type", data3[1]);
            config.setProperty(elementBaseKey3 + "config", data3[2]);
            config.setProperty(elementBaseKey3 + "reqUrlRegex", data3[3]);
            config.setProperty(elementBaseKey3 + "reqHeadRegex", data3[4]);
            config.setProperty(elementBaseKey3 + "resHeadRegex", data3[5]);
            config.setProperty(elementBaseKey3 + "resBodyRegex", data3[6]);
            config.setProperty(elementBaseKey3 + "enabled", data3[7]);
        }
    }

    private void upgradeFrom2_0_0(XMLConfiguration config) {
        String forcedBrowseFile = config.getString("bruteforce.defaultFile", USER_AGENT);
        if (!USER_AGENT.equals(forcedBrowseFile)) {
            String absolutePath = USER_AGENT;
            File f = new File(this.DIRBUSTER_CUSTOM_DIR + File.separator + forcedBrowseFile);
            if (!f.exists()) {
                f = new File(this.DIRBUSTER_DIR + File.separator + forcedBrowseFile);
            }
            if (f.exists()) {
                absolutePath = f.getAbsolutePath();
            }
            config.setProperty("bruteforce.defaultFile", absolutePath);
        }
        config.clearTree("nullrequest");
        config.clearTree("nullresponse");
    }

    private void upgradeFrom2_2_0(XMLConfiguration config) {
        try {
            if (config.getInt("start.checkForUpdates", 0) == 0) {
                config.setProperty("start.dayLastChecked", USER_AGENT);
            }
        }
        catch (ConversionException e) {
            LOG.debug("The option start.checkForUpdates is not an int.", (Throwable)e);
        }
        config.setProperty("addons.block", USER_AGENT);
    }

    private void upgradeFrom2_2_2(XMLConfiguration config) {
        try {
            int oldValue = config.getInt("start.checkForUpdates", 1);
            config.setProperty("start.checkForUpdates", oldValue != 0);
        }
        catch (ConversionException e) {
            LOG.debug("The option start.checkForUpdates is no longer an int.", (Throwable)e);
        }
    }

    private void upgradeFrom2_3_1(XMLConfiguration config) {
        config.clearProperty("connection.confirmRemoveAuth");
        config.clearTree("options.auth");
    }

    private void upgradeFrom2_4_3(XMLConfiguration config) {
        ArrayList<Object[]> oldData = new ArrayList<Object[]>();
        Iterator<String> it = config.getKeys("ext");
        while (it.hasNext()) {
            String key = it.next();
            Object[] data = new Object[]{key.substring(4), config.getBoolean(key)};
            oldData.add(data);
        }
        config.clearTree("ext");
        int size = oldData.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "extensions.extension(" + i + ").";
            Object[] data = (Object[])oldData.get(i);
            config.setProperty(elementBaseKey + "name", data[0]);
            config.setProperty(elementBaseKey + "enabled", data[1]);
        }
    }

    private static void upgradeFrom2_5_0(XMLConfiguration config) {
        String oldConfigKey = "proxy.modifyAcceptEncoding";
        config.setProperty("proxy.removeUnsupportedEncodings", config.getBoolean(oldConfigKey, true));
        config.clearProperty(oldConfigKey);
        HashSet<String> classnames = new HashSet<String>();
        Iterator<String> it = config.getKeys();
        while (it.hasNext()) {
            String key = it.next();
            if (!key.startsWith("pscans.org")) continue;
            classnames.add(key.substring(7, key.lastIndexOf(46)));
        }
        ArrayList<Object[]> oldData = new ArrayList<Object[]>();
        for (String classname : classnames) {
            Object[] data = new Object[]{classname, config.getBoolean("pscans." + classname + ".enabled", true), config.getString("pscans." + classname + ".level", USER_AGENT)};
            oldData.add(data);
        }
        config.clearTree("pscans.org");
        int size = oldData.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "pscans.pscanner(" + i + ").";
            Object[] data = (Object[])oldData.get(i);
            config.setProperty(elementBaseKey + "classname", data[0]);
            config.setProperty(elementBaseKey + "enabled", data[1]);
            config.setProperty(elementBaseKey + "level", data[2]);
        }
    }

    private static void upgradeFrom2_7_0(XMLConfiguration config) {
        config.clearTree("sniterm");
        String certUseKey = "certificate.use";
        try {
            int oldValue = config.getInt(certUseKey, 0);
            config.setProperty(certUseKey, oldValue != 0);
        }
        catch (ConversionException e) {
            LOG.debug("The option " + certUseKey + " is no longer an int.", (Throwable)e);
        }
    }

    private static void upgradeFrom2_8_0(XMLConfiguration config) {
        config.setProperty("connection.defaultUserAgent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:92.0) Gecko/20100101 Firefox/92.0");
        Constant.updatePscanTagMailtoPattern(config);
    }

    static void upgradeFrom2_9_0(XMLConfiguration config) {
        String oldKeyName = ".markocurrences";
        String newKeyName = ".markoccurrences";
        config.getKeys().forEachRemaining(key -> {
            if (key.endsWith(oldKeyName)) {
                config.setProperty(key.replace(oldKeyName, newKeyName), config.getProperty((String)key));
                config.clearProperty((String)key);
            }
        });
        config.setProperty("connection.defaultUserAgent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:92.0) Gecko/20100101 Firefox/92.0");
        config.setProperty("view.lookAndFeel", "Flat Light");
        config.setProperty("view.lookAndFeelClass", "com.formdev.flatlaf.FlatLightLaf");
    }

    private static void upgradeFrom2_10_0(XMLConfiguration config) {
        config.setProperty("connection.defaultUserAgent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:92.0) Gecko/20100101 Firefox/92.0");
    }

    private static void updatePscanTagMailtoPattern(XMLConfiguration config) {
        String autoTagScannersKey = "pscans.autoTagScanners.scanner";
        List<HierarchicalConfiguration> tagScanners = config.configurationsAt(autoTagScannersKey);
        String badPattern = "<.*href\\s*['\"]?mailto:";
        String goodPattern = "<.*href\\s*=\\s*['\"]?mailto:";
        int size = tagScanners.size();
        for (int i = 0; i < size; ++i) {
            String currentKeyResBodyRegex = autoTagScannersKey + "(" + i + ").resBodyRegex";
            if (!config.getProperty(currentKeyResBodyRegex).equals(badPattern)) continue;
            config.setProperty(currentKeyResBodyRegex, goodPattern);
            break;
        }
    }

    private static void updateCfuFromDefaultConfig(XMLConfiguration config) {
        ZapXmlConfiguration defaultConfig;
        Path path = Constant.getPathDefaultConfigFile();
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            defaultConfig = new ZapXmlConfiguration(path.toFile());
        }
        catch (ConfigurationException e) {
            Constant.logAndPrintError("Failed to read default configuration file " + path, e);
            return;
        }
        Constant.copyPropertyIfSet(defaultConfig, config, "start.checkForUpdates");
        Constant.copyPropertyIfSet(defaultConfig, config, "start.downloadNewRelease");
        Constant.copyPropertyIfSet(defaultConfig, config, "start.checkAddonUpdates");
        Constant.copyPropertyIfSet(defaultConfig, config, "start.installAddonUpdates");
        Constant.copyPropertyIfSet(defaultConfig, config, "start.installScannerRules");
        Constant.copyPropertyIfSet(defaultConfig, config, "start.reportReleaseAddons");
        Constant.copyPropertyIfSet(defaultConfig, config, "start.reportBetaAddons");
        Constant.copyPropertyIfSet(defaultConfig, config, "start.reportAlphaAddons");
    }

    private static void copyPropertyIfSet(XMLConfiguration from, XMLConfiguration to, String key) {
        Object value = from.getProperty(key);
        if (value != null) {
            to.setProperty(key, value);
        }
    }

    public static void setLocale(String loc) {
        String[] langArray = loc.split("_");
        Locale locale = new Locale(langArray[0], langArray[1]);
        Locale.setDefault(locale);
        if (messages == null) {
            messages = new I18N(locale);
        } else {
            messages.setLocale(locale);
        }
    }

    public static Locale getLocale() {
        return messages.getLocal();
    }

    public static Locale getSystemsLocale() {
        return SYSTEMS_LOCALE;
    }

    public static Constant getInstance() {
        if (instance == null) {
            Constant.createInstance(null);
        }
        return instance;
    }

    public static synchronized void createInstance(ControlOverrides overrides) {
        if (instance == null) {
            instance = new Constant(overrides);
        }
    }

    private void setAcceleratorKeys() {
        if (Constant.isMacOsX()) {
            ACCELERATOR_UNDO = "meta Z";
            ACCELERATOR_REDO = "meta shift Z";
            ACCELERATOR_TRIGGER_KEY = "Meta";
        } else {
            ACCELERATOR_UNDO = "control Z";
            ACCELERATOR_REDO = "control Y";
            ACCELERATOR_TRIGGER_KEY = "Control";
        }
    }

    public static boolean isWindows() {
        String os_name = System.getProperty("os.name");
        Matcher matcher = patternWindows.matcher(os_name);
        return matcher.find();
    }

    public static boolean isLinux() {
        String os_name = System.getProperty("os.name");
        Matcher matcher = patternLinux.matcher(os_name);
        return matcher.find();
    }

    public static boolean isMacOsX() {
        String os_name = System.getProperty("os.name");
        Matcher matcher = patternMacOsX.matcher(os_name);
        return matcher.find();
    }

    public static void setZapHome(String dir) {
        zapHome = Constant.getAbsolutePath(dir);
    }

    private static String getAbsolutePath(String directory) {
        String separator;
        String realPath = Paths.get(directory, new String[0]).toAbsolutePath().toString();
        if (!realPath.endsWith(separator = FileSystems.getDefault().getSeparator())) {
            realPath = realPath + separator;
        }
        return realPath;
    }

    public static String getZapHome() {
        return zapHome;
    }

    public static Path getPathDefaultConfigFile() {
        return Paths.get(Constant.getZapInstall(), "xml", FILE_CONFIG_NAME);
    }

    public static File getContextsDir() {
        return Constant.getFromHomeDir(USER_CONTEXTS_DIR);
    }

    public static File getPoliciesDir() {
        return Constant.getFromHomeDir(USER_POLICIES_DIR);
    }

    private static File getFromHomeDir(String subDir) {
        Path path = Paths.get(Constant.getZapHome(), subDir);
        try {
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (Files.isDirectory(path, new LinkOption[0]) && Files.isWritable(path)) {
            return path.toFile();
        }
        return Model.getSingleton().getOptionsParam().getUserDirectory();
    }

    public static void setZapInstall(String dir) {
        zapInstall = Constant.getAbsolutePath(dir);
    }

    public static String getZapInstall() {
        if (zapInstall == null) {
            String path = ".";
            Path localDir = Paths.get(path, new String[0]);
            if (!Files.isDirectory(localDir.resolve("db"), new LinkOption[0]) || !Files.isDirectory(localDir.resolve(LANG_DIR), new LinkOption[0])) {
                try {
                    Path sourceLocation = Paths.get(ZAP.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    if (!Files.isDirectory(sourceLocation, new LinkOption[0])) {
                        sourceLocation = sourceLocation.getParent();
                    }
                    path = sourceLocation.toString();
                }
                catch (URISyntaxException e) {
                    System.err.println("Failed to determine the ZAP installation dir: " + e.getMessage());
                    path = localDir.toAbsolutePath().toString();
                }
                System.out.println("Defaulting ZAP install dir to " + path);
            }
            zapInstall = Constant.getAbsolutePath(path);
        }
        return zapInstall;
    }

    private static Manifest getManifest() {
        String className = Constant.class.getSimpleName() + ".class";
        String classPath = Constant.class.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            return new Manifest(new URL(manifestPath).openStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getVersionFromManifest() {
        Manifest manifest = Constant.getManifest();
        if (manifest != null) {
            Attributes attr = manifest.getMainAttributes();
            return attr.getValue("Implementation-Version");
        }
        return DEV_VERSION;
    }

    public static Date getReleaseCreateDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Manifest manifest = Constant.getManifest();
        if (manifest != null) {
            Attributes attr = manifest.getMainAttributes();
            try {
                return sdf.parse(attr.getValue("Create-Date"));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date getInstallDate() {
        File f;
        String className = Constant.class.getSimpleName() + ".class";
        String classPath = Constant.class.getResource(className).toString();
        if (!classPath.startsWith("jar:file:")) {
            return null;
        }
        int ind = (classPath = classPath.substring(9)).indexOf("!");
        if (ind > 0) {
            classPath = classPath.substring(0, ind);
        }
        if ((f = new File(classPath)).exists()) {
            return new Date(f.getParentFile().lastModified());
        }
        return null;
    }

    public static boolean isDevMode() {
        return devMode || Constant.isDevBuild();
    }

    public static void setDevMode(boolean devMode) {
        Constant.devMode = devMode;
    }

    public static void setSilent(boolean silent) {
        Constant.silent = silent;
    }

    public static boolean isDevBuild() {
        return Constant.isDevBuild(PROGRAM_VERSION);
    }

    public static boolean isDevBuild(String version) {
        return DEV_VERSION.equals(version);
    }

    public static boolean isDailyBuild(String version) {
        return version.startsWith("D-");
    }

    public static boolean isDailyBuild() {
        return Constant.isDailyBuild(PROGRAM_VERSION);
    }

    public static boolean isSilent() {
        return silent;
    }

    public static void setLowMemoryOption(boolean lowMem) {
        if (lowMemoryOption != null) {
            throw new InvalidParameterException("Low memory option already set to " + lowMemoryOption);
        }
        lowMemoryOption = lowMem;
    }

    public static boolean isLowMemoryOptionSet() {
        return lowMemoryOption != null && lowMemoryOption != false;
    }

    public static boolean isKali() {
        block11: {
            if (onKali == null) {
                onKali = Boolean.FALSE;
                File osReleaseFile = new File("/etc/os-release");
                if (Constant.isLinux() && !Constant.isDailyBuild() && osReleaseFile.exists()) {
                    try (InputStream in = Files.newInputStream(osReleaseFile.toPath(), new OpenOption[0]);){
                        String[] oSLikes;
                        Properties osProps = new Properties();
                        osProps.load(in);
                        String osLikeValue = osProps.getProperty("ID");
                        if (osLikeValue == null) break block11;
                        for (String osLike : oSLikes = osLikeValue.split(" ")) {
                            if (!osLike.equalsIgnoreCase("kali")) continue;
                            onKali = Boolean.TRUE;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return onKali;
    }

    public static boolean isInContainer() {
        if (inContainer == null) {
            File containerFile = new File(ZAP_CONTAINER_FILE);
            File flatpakFile = new File(FLATPAK_FILE);
            File snapFile = new File(SNAP_FILE);
            if (Constant.isLinux() && containerFile.exists()) {
                inContainer = true;
                boolean inWebSwing = System.getenv(WEBSWING_ENVVAR) != null;
                try {
                    containerName = new String(Files.readAllBytes(containerFile.toPath()), StandardCharsets.UTF_8).trim();
                    if (inWebSwing) {
                        containerName = containerName + ".webswing";
                    }
                }
                catch (IOException iOException) {}
            } else if (flatpakFile.exists()) {
                inContainer = true;
                containerName = FLATPAK_NAME;
            } else if (snapFile.exists()) {
                inContainer = true;
                containerName = SNAP_NAME;
            } else {
                inContainer = false;
            }
        }
        return inContainer;
    }

    public static String getContainerName() {
        Constant.isInContainer();
        return containerName;
    }

    static {
        lowMemoryOption = null;
        messages = null;
        SYSTEMS_LOCALE = Locale.getDefault();
        VULNS_BASE = VULNERABILITIES_PREFIX;
        FOLDER_LOCAL_PLUGIN = FOLDER_PLUGIN;
        OK_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/072.png");
        INFO_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/073.png");
        LOW_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/074.png");
        MED_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/076.png");
        HIGH_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/071.png");
        BLANK_IMAGE_URL = Constant.class.getResource("/resource/icon/10/blank.png");
        SPIDER_IMAGE_URL = Constant.class.getResource("/resource/icon/10/spider.png");
        LOG = LogManager.getLogger(Constant.class);
        patternWindows = Pattern.compile("window", 2);
        patternLinux = Pattern.compile("linux", 2);
        patternMacOsX = Pattern.compile("mac", 2);
    }
}

