/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Command;

public class GetDefiningClassLoaderCommand
extends Command {
    private String className;
    private int classLoaderId;

    public GetDefiningClassLoaderCommand(String className, int classLoaderId) {
        super(35);
        this.className = className.replace('/', '.');
        this.classLoaderId = classLoaderId;
    }

    GetDefiningClassLoaderCommand() {
        super(35);
    }

    public int getClassLoaderId() {
        return this.classLoaderId;
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        return super.toString() + ", className: " + this.className + ", classLoaderId: " + this.classLoaderId;
    }

    void readObject(ObjectInputStream in) throws IOException {
        this.className = in.readUTF();
        this.classLoaderId = in.readInt();
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.className);
        out.writeInt(this.classLoaderId);
    }
}

