/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu;

import java.text.NumberFormat;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNode;

public class PrestimeCPUCCTNodeFree
extends PrestimeCPUCCTNode {
    private static NumberFormat percentFormat = null;

    protected PrestimeCPUCCTNodeFree(CPUCCTContainer container, PrestimeCPUCCTNode parent, int methodId) {
        super(container, parent, methodId);
    }

    PrestimeCPUCCTNodeFree() {
    }

    @Override
    PrestimeCPUCCTNode createCopy() {
        PrestimeCPUCCTNodeFree copy = new PrestimeCPUCCTNodeFree();
        this.setupCopy(copy);
        return copy;
    }

    @Override
    public CCTNode createFilteredNode() {
        PrestimeCPUCCTNodeFree filtered = new PrestimeCPUCCTNodeFree();
        this.setupFilteredNode(filtered);
        return filtered;
    }

    public void setMethodId(int methodId) {
        this.methodId = methodId;
    }

    @Override
    public float getTotalTime0InPerCent() {
        float result = (float)((double)this.totalTime0 / (double)this.container.getWholeGraphNetTime0() * 100.0);
        return result < 100.0f ? result : 100.0f;
    }

    @Override
    public float getTotalTime1InPerCent() {
        return (float)((double)this.totalTime1 / (double)this.container.getWholeGraphNetTime1() * 100.0);
    }

    public void addChild(PrestimeCPUCCTNodeFree node) {
        if (this.children == null) {
            this.children = new PrestimeCPUCCTNodeFree[1];
        } else {
            PrestimeCPUCCTNodeFree[] newch = new PrestimeCPUCCTNodeFree[this.children.length + 1];
            System.arraycopy(this.children, 0, newch, 0, this.children.length);
            this.children = newch;
        }
        this.children[this.children.length - 1] = node;
    }

    public PrestimeCPUCCTNodeFree createChildlessCopy() {
        try {
            PrestimeCPUCCTNodeFree res = (PrestimeCPUCCTNodeFree)this.clone();
            res.children = null;
            return res;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public void exportXMLData(ExportDataDumper eDD, String indent) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(indent + "<node>" + newline);
        result.append(indent).append(" <Name>").append(this.replaceHTMLCharacters(this.getNodeName())).append("</Name>").append(newline);
        CCTNode p = this.getParent();
        result.append(indent).append(" <Parent>").append(this.replaceHTMLCharacters(p == null ? "none" : ((PrestimeCPUCCTNodeFree)this.getParent()).getNodeName())).append("</Parent>").append(newline);
        result.append(indent).append(" <Time_Relative>").append(percentFormat.format(p == null ? (double)this.getTotalTime0InPerCent() / 100.0 : 100.0)).append("</Time_Relative>").append(newline);
        result.append(indent).append(" <Time>").append(p == null ? Long.valueOf(this.getTotalTime0()) : "N/A").append("</Time>").append(newline);
        if (this.container.collectingTwoTimeStamps) {
            result.append(indent).append(" <Time-CPU>").append(this.getTotalTime1()).append("</Time-CPU>").append(newline);
        }
        result.append(indent).append(" <Invocations>").append(p == null ? this.getNCalls() : 1).append("</Invocations>").append(newline);
        eDD.dumpData(result);
        if (this.children != null) {
            for (int i = 0; i < this.getNChildren(); ++i) {
                ((PrestimeCPUCCTNodeFree)this.children[i]).exportXMLData(eDD, indent + "  ");
            }
        }
        result = new StringBuffer(indent + "</node>");
        eDD.dumpData(result);
    }

    public void exportHTMLData(ExportDataDumper eDD, int depth) {
        int i;
        StringBuffer result = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">");
        for (i = 0; i < depth; ++i) {
            result.append(".");
        }
        result.append(this.replaceHTMLCharacters(this.getNodeName())).append("</pre></td><td class=\"right\">").append(percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0)).append("</td><td class=\"right\">").append(this.getTotalTime0());
        if (this.container.collectingTwoTimeStamps) {
            result.append("</td><td class=\"right\">").append(this.getTotalTime1());
        }
        result.append("</td><td class=\"right\">").append(this.getNCalls()).append("</td></tr>");
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.getNChildren(); ++i) {
                ((PrestimeCPUCCTNodeFree)this.children[i]).exportHTMLData(eDD, depth + 1);
            }
        }
    }

    private String replaceHTMLCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void exportCSVData(String separator, int depth, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        String indent = " ";
        result.append(quote);
        for (i = 0; i < depth; ++i) {
            result.append(indent);
        }
        result.append(this.getNodeName()).append(quote).append(separator);
        result.append(quote).append(this.getTotalTime0InPerCent()).append(quote).append(separator);
        result.append(quote).append(this.getTotalTime0()).append(quote).append(separator);
        if (this.container.collectingTwoTimeStamps) {
            result.append(quote).append(this.getTotalTime1()).append(quote).append(separator);
        }
        result.append(quote).append(this.getNCalls()).append(quote).append(newLine);
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.getNChildren(); ++i) {
                ((PrestimeCPUCCTNodeFree)this.children[i]).exportCSVData(separator, depth + 1, eDD);
            }
        }
    }

    public static void setPercentFormat(NumberFormat percentFormat) {
        PrestimeCPUCCTNodeFree.percentFormat = percentFormat;
    }
}

