/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.DisplayFormatter;

public class StructContentType<T>
extends ContentType<T> {
    private final List<IAttribute<?>> m_attributes = new ArrayList();
    private final Map<IAccessorKey<?>, AccessorEntry<T>> m_accessors = new LinkedHashMap();
    private final String description;

    public StructContentType(String identifier, String name, String description) {
        super(identifier, name == null ? StructContentType.lookupNameFor(identifier) : name);
        this.description = (description != null ? description + " [" : "[") + identifier + ']';
        this.addFormatter(new DisplayFormatter(this, "auto", "Value"));
    }

    protected StructContentType(String identifier, String name) {
        super(identifier, name == null ? StructContentType.lookupNameFor(identifier) : name);
        this.description = "";
    }

    public <M> void addField(String identifier, ContentType<M> contentType, String name, String desc, IMemberAccessor<M, T> accessor) {
        IAttribute<M> attr = Attribute.attr(identifier, name, desc, contentType);
        this.m_attributes.add(attr);
        this.m_accessors.put(attr.getKey(), new AccessorEntry<T>(accessor, name, desc));
    }

    @Deprecated
    public <M> void addExtraAttribute(int atIndex, IAttribute<M> attribute) {
        this.m_attributes.add(atIndex, attribute);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<IAttribute<?>> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public Map<IAccessorKey<?>, ? extends IDescribable> getAccessorKeys() {
        return this.m_accessors;
    }

    @Override
    public <M> IMemberAccessor<M, T> getAccessor(IAccessorKey<M> attribute) {
        AccessorEntry<T> accessorEntry = this.m_accessors.get(attribute);
        if (accessorEntry != null) {
            IMemberAccessor typedAccessor = accessorEntry.accessor;
            return typedAccessor;
        }
        return null;
    }

    private static final class AccessorEntry<T>
    implements IDescribable {
        final IMemberAccessor<?, T> accessor;
        final String name;
        final String description;

        AccessorEntry(IMemberAccessor<?, T> accessor, String name, String description) {
            this.accessor = accessor;
            this.name = name;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

