/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IMutableConstrainedMap;
import org.openjdk.jmc.common.unit.MutableConstrainedMap;

public class SimpleConstrainedMap<K>
extends MutableConstrainedMap<K> {
    protected final Map<K, IConstraint<?>> constraints;
    protected final IConstraint<?> fallback;

    public SimpleConstrainedMap() {
        this((IConstraint<?>)null);
    }

    public SimpleConstrainedMap(IConstraint<?> fallback) {
        this.constraints = new HashMap();
        this.fallback = fallback;
    }

    public SimpleConstrainedMap(Map<K, IConstraint<?>> constraints, IConstraint<?> fallback) {
        this.constraints = new HashMap(constraints);
        this.fallback = fallback;
    }

    protected SimpleConstrainedMap(Map<K, IConstraint<?>> constraints, IConstraint<?> fallback, Map<K, Object> values) {
        this(constraints, fallback);
        this.values.putAll(values);
    }

    @Override
    public IConstraint<?> getConstraint(K key) {
        return this.constraints.get(key);
    }

    @Override
    protected IConstraint<?> getSuggestedConstraint(K key) {
        return this.fallback;
    }

    @Override
    protected void addConstraint(K key, IConstraint<?> constraint) {
        this.constraints.put(key, constraint);
    }

    @Override
    public IMutableConstrainedMap<K> emptyWithSameConstraints() {
        return new SimpleConstrainedMap<K>(this.constraints, this.fallback);
    }

    @Override
    public IMutableConstrainedMap<K> mutableCopy() {
        return new SimpleConstrainedMap<K>(this.constraints, this.fallback, this.values);
    }
}

