/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.console.r;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.UIManager;

class MultiSplitContainer
extends JPanel {
    private static final int DIVIDER_SIZE = 6;
    private static final Color SEPARATOR_COLOR = UIManager.getColor("Separator.foreground");
    private final Map<Component, Double> componentsWeights = new HashMap<Component, Double>();
    private final List<Integer> dividerOffsets = new ArrayList<Integer>();
    private final List<Component> visibleComponents = new ArrayList<Component>();

    MultiSplitContainer() {
        super(null);
        MouseHandler mHandler = new MouseHandler();
        this.addMouseListener(mHandler);
        this.addMouseMotionListener(mHandler);
    }

    @Override
    public void doLayout() {
        if (this.visibleComponents.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        int visiblesCount = this.visibleComponents.size();
        if (visiblesCount == 1) {
            this.visibleComponents.get(0).setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        } else {
            Component comp;
            Dimension size = this.getSize();
            int h = size.height - insets.top - insets.bottom;
            int x = insets.left;
            int dividersCount = this.dividerOffsets.size();
            for (int i = 0; i < dividersCount; ++i) {
                int xx = this.dividerOffsets.get(i);
                comp = this.visibleComponents.get(i);
                comp.setBounds(x, insets.top, xx - x, h);
                comp.validate();
                x = xx + 6;
            }
            x = this.dividerOffsets.get(dividersCount - 1) + 6;
            comp = this.visibleComponents.get(visiblesCount - 1);
            comp.setBounds(x, insets.top, this.getWidth() - insets.right - x, h);
            comp.validate();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.setupLayout();
        this.doLayout();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.dividerOffsets.isEmpty()) {
            Insets i = this.getInsets();
            g.setColor(SEPARATOR_COLOR);
            for (int o : this.dividerOffsets) {
                g.drawLine(o, i.top, o, this.getHeight() - i.bottom);
                g.drawLine(o += 5, i.top, o, this.getHeight() - i.bottom);
            }
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.componentsWeights.put(comp, constraints instanceof Number ? ((Number)constraints).doubleValue() : 0.5);
        super.addImpl(comp, constraints, index);
        this.invalidate();
    }

    @Override
    public void remove(int index) {
        Component comp = this.getComponent(index);
        super.remove(index);
        this.componentsWeights.remove(comp);
        this.invalidate();
    }

    private void setupLayout() {
        this.dividerOffsets.clear();
        this.visibleComponents.clear();
        Dimension size = this.getSize();
        if (size.height == 0 || size.width == 0) {
            return;
        }
        double visRel = 0.0;
        for (Component c : this.getComponents()) {
            if (!c.isVisible()) continue;
            this.visibleComponents.add(c);
            visRel += this.componentsWeights.get(c).doubleValue();
        }
        int visiblesCount = this.visibleComponents.size();
        if (visiblesCount < 2) {
            return;
        }
        Insets insets = this.getInsets();
        int w = size.width - insets.left - insets.right - (visiblesCount - 1) * 6;
        int x = insets.left;
        for (int i = 0; i < visiblesCount - 1; ++i) {
            x = (int)((double)x + (double)w / visRel * this.componentsWeights.get(this.visibleComponents.get(i)));
            this.dividerOffsets.add(x);
            x += 6;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private boolean inDivider;
        private int cursor;
        private boolean canDrag;
        private int offsetIdx;
        private int dragX;
        private int offsetX;
        private int minX;
        private int maxX;
        private Component c1;
        private Component c2;
        private double relWidth;

        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.canDrag) {
                this.updateMouse(e, true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.canDrag) {
                this.updateMouse(e, false);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateMouse(e, true);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.canDrag) {
                int oldX = (Integer)MultiSplitContainer.this.dividerOffsets.get(this.offsetIdx);
                int dx = this.dragX - e.getX();
                int newX = oldX - dx;
                newX = Math.max(newX, this.minX);
                newX = Math.min(newX, this.maxX);
                MultiSplitContainer.this.dividerOffsets.set(this.offsetIdx, newX);
                double c1width = this.c1.getWidth();
                double c1Rel = c1width * this.relWidth / (c1width + (double)this.c2.getWidth());
                MultiSplitContainer.this.componentsWeights.put(this.c1, c1Rel);
                MultiSplitContainer.this.componentsWeights.put(this.c2, this.relWidth - c1Rel);
                this.dragX = newX + this.offsetX;
                MultiSplitContainer.this.doLayout();
                MultiSplitContainer.this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.inDivider) {
                this.canDrag = true;
                this.dragX = e.getX();
                this.offsetX = this.dragX - (Integer)MultiSplitContainer.this.dividerOffsets.get(this.offsetIdx);
                Insets insets = MultiSplitContainer.this.getInsets();
                this.minX = this.offsetIdx == 0 ? insets.left : (Integer)MultiSplitContainer.this.dividerOffsets.get(this.offsetIdx - 1) + 6;
                this.maxX = this.offsetIdx == MultiSplitContainer.this.dividerOffsets.size() - 1 ? MultiSplitContainer.this.getWidth() - insets.right - 6 : (Integer)MultiSplitContainer.this.dividerOffsets.get(this.offsetIdx + 1) - 6;
                this.c1 = (Component)MultiSplitContainer.this.visibleComponents.get(this.offsetIdx);
                this.c2 = (Component)MultiSplitContainer.this.visibleComponents.get(this.offsetIdx + 1);
                this.relWidth = (Double)MultiSplitContainer.this.componentsWeights.get(this.c1) + (Double)MultiSplitContainer.this.componentsWeights.get(this.c2);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.canDrag = false;
            this.offsetIdx = -1;
            this.c1 = null;
            this.c2 = null;
            this.updateMouse(e, this.inDivider);
        }

        private void updateMouse(MouseEvent e, boolean onContainer) {
            this.inDivider = false;
            int origCursor = this.cursor;
            this.cursor = 0;
            if (onContainer) {
                int x = e.getX();
                for (int i = 0; i < MultiSplitContainer.this.dividerOffsets.size(); ++i) {
                    int divx = (Integer)MultiSplitContainer.this.dividerOffsets.get(i);
                    if (x < divx || x > divx + 6 - 1) continue;
                    this.inDivider = true;
                    this.offsetIdx = i;
                    this.cursor = 11;
                    break;
                }
            }
            if (origCursor != this.cursor) {
                MultiSplitContainer.this.setCursor(Cursor.getPredefinedCursor(this.cursor));
            }
        }
    }
}

