/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.StandardModule;

public final class JaveleonModule
extends StandardModule {
    private static final Logger LOG = Logger.getLogger(JaveleonModule.class.getName());
    public static final boolean isJaveleonPresent;
    private static final Method incrementGlobalId;
    private static final Method registerClassLoader;
    private static HashMap<String, ClassLoader> currentClassLoaders;

    public static boolean incrementGlobalId() {
        assert (isJaveleonPresent);
        try {
            incrementGlobalId.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Could not reload", exception);
            return false;
        }
    }

    static void registerClassLoader(ClassLoader classLoader, String string) {
        if (isJaveleonPresent) {
            try {
                registerClassLoader.invoke(null, classLoader, string);
            }
            catch (Exception exception) {
                LOG.log(Level.INFO, "Could not register " + string, exception);
            }
        }
    }

    public JaveleonModule(ModuleManager moduleManager, File file, Object object, Events events) throws IOException {
        super(moduleManager, events, file, object, true, false, false);
        this.setEnabled(true);
    }

    @Override
    protected ClassLoader createNewClassLoader(List<File> list, List<ClassLoader> list2) {
        ClassLoader classLoader = super.createNewClassLoader(list, list2);
        currentClassLoaders.put(this.getCodeNameBase(), classLoader);
        return classLoader;
    }

    @Override
    public void classLoaderUp(Set<Module> set) throws IOException {
        super.classLoaderUp(set);
    }

    @Override
    protected ClassLoader getParentLoader(Module module) {
        if (currentClassLoaders.containsKey(module.getCodeNameBase())) {
            return currentClassLoaders.get(module.getCodeNameBase());
        }
        return module.getClassLoader();
    }

    @Override
    public String toString() {
        return "Javeleon module " + this.getJarFile().toString();
    }

    @Override
    protected void classLoaderDown() {
    }

    @Override
    public final void reload() throws IOException {
    }

    @Override
    protected void cleanup() {
    }

    @Override
    public void destroy() {
    }

    static {
        Method method = null;
        Method method2 = null;
        try {
            method = Class.forName("org.javeleon.reload.ReloadModule").getDeclaredMethod("incrementGlobalId", new Class[0]);
            method2 = Class.forName("org.javeleon.reload.ReloadFacade").getDeclaredMethod("registerClassLoader", ClassLoader.class, String.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Could not load Javeleon integration", exception);
        }
        isJaveleonPresent = method != null && method2 != null;
        incrementGlobalId = method;
        registerClassLoader = method2;
        currentClassLoaders = new HashMap();
    }
}

