/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.arguments;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualvm.gotosource.arguments.SourceConfigArgument;
import org.graalvm.visualvm.gotosource.arguments.SourceRootsArgument;
import org.graalvm.visualvm.gotosource.arguments.SourceViewerArgument;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionGroups;
import org.netbeans.spi.sendopts.OptionProcessor;

public final class SourceArguments
extends OptionProcessor {
    protected Set<Option> getOptions() {
        return Collections.singleton(OptionGroups.anyOf((Option[])new Option[]{SourceRootsArgument.ARGUMENT, SourceViewerArgument.ARGUMENT, SourceConfigArgument.ARGUMENT}));
    }

    protected void process(Env env, Map<Option, String[]> maps) throws CommandException {
        String[] sourceRoots = maps.get(SourceRootsArgument.ARGUMENT);
        String[] sourceViewer = maps.get(SourceViewerArgument.ARGUMENT);
        String[] sourceConfig = maps.get(SourceConfigArgument.ARGUMENT);
        if (sourceConfig != null) {
            SourceConfigArgument.process(sourceConfig, sourceRoots, sourceViewer);
        }
        if (sourceRoots != null) {
            SourceRootsArgument.process(sourceRoots);
        }
        if (sourceViewer != null) {
            SourceViewerArgument.process(sourceViewer);
        }
    }

    static String decode(String value) {
        value = value.replace("%27", "'");
        value = value.replace("%22", "\"");
        value = value.replace("%20", " ");
        return value;
    }
}

