/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.threads;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ResourceBundle;
import org.graalvm.visualvm.lib.jfluid.results.threads.ThreadData;
import org.graalvm.visualvm.lib.ui.swing.renderer.BaseRenderer;
import org.graalvm.visualvm.lib.ui.threads.ViewManager;

public class TimelineRenderer
extends BaseRenderer {
    private static final Color TICK_COLOR = new Color(200, 200, 200);
    private static final int BAR_MARGIN = 3;
    private static final int BAR_MARGIN_X2 = 6;
    private final ViewManager view;
    private ViewManager.RowView rowView;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.threads.Bundle");
    }

    public TimelineRenderer(ViewManager view) {
        this.view = view;
        this.setOpaque(true);
        this.setHorizontalAlignment(11);
        this.putClientProperty("ProfilerTableHover_NoHover", this);
    }

    @Override
    public void setValue(Object value, int row) {
        this.rowView = (ViewManager.RowView)value;
    }

    @Override
    public String toString() {
        int lastIndex = this.rowView == null ? -1 : this.rowView.getLastIndex();
        return TimelineRenderer.getStateName(lastIndex == -1 ? -1 : this.rowView.getState(lastIndex));
    }

    @Override
    public void paint(Graphics g) {
        int x;
        super.paint(g);
        int w = this.size.width;
        int h = this.size.height;
        long time = this.view.getFirstTimeMark(false);
        long step = this.view.getTimeMarksStep();
        g.setColor(TICK_COLOR);
        int oldX = x = this.view.getTimePosition(time, false);
        while (x < w) {
            g.drawLine(x + this.location.x, this.location.y, x + this.location.x, h - 1 + this.location.y);
            x = this.view.getTimePosition(time += step, false);
            if (x <= oldX) break;
            oldX = x;
        }
        if (this.rowView == null) {
            return;
        }
        int i = this.rowView.getLastIndex();
        if (i == -1) {
            return;
        }
        int xx = (i == this.rowView.getMaxIndex() ? this.rowView.getMaxPosition() : this.rowView.getPosition(this.rowView.getTime(i + 1))) + this.location.x;
        while (i >= 0 && xx >= 0) {
            x = Math.max(0, this.rowView.getPosition(this.rowView.getTime(i))) + this.location.x;
            int ww = xx - x;
            if (ww > 0) {
                Color c = ThreadData.getThreadStateColor((int)this.rowView.getState(i));
                if (c != null) {
                    g.setColor(c);
                    g.fillRect(x, 3 + this.location.y, ww, h - 6);
                }
                xx = x;
            }
            --i;
        }
    }

    private static String getStateName(int state) {
        switch (state) {
            case 1: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateRunning");
            }
            case 2: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateSleeping");
            }
            case 3: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateMonitor");
            }
            case 4: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateWait");
            }
            case 5: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStatePark");
            }
        }
        return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateFinished");
    }
}

