/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.keystore;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.autoupdate.KeyStoreProvider;

public class CacertsKeyStoreProvider
implements KeyStoreProvider {
    private static String getCacerts() {
        String fs = File.separator;
        return System.getProperty("java.home") + fs + "lib" + fs + "security" + fs + "cacerts";
    }

    public KeyStore getKeyStore() {
        KeyStore keyStore = null;
        File file = new File(CacertsKeyStoreProvider.getCacerts());
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(file);){
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, null);
        }
        catch (Exception ex) {
            Logger.getLogger("global").log(Level.INFO, ex.getMessage(), ex);
        }
        return keyStore;
    }

    public KeyStoreProvider.TrustLevel getTrustLevel() {
        return KeyStoreProvider.TrustLevel.TRUST;
    }
}

