/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.actions;

import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.threads.ThreadDump;
import org.graalvm.visualvm.lib.profiler.ThreadDumpWindow;
import org.graalvm.visualvm.lib.profiler.actions.Bundle;
import org.graalvm.visualvm.lib.profiler.actions.ProfilingAwareAction;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

public class TakeThreadDumpAction
extends ProfilingAwareAction {
    private static final int[] ENABLED_STATES = new int[]{4};

    public static TakeThreadDumpAction getInstance() {
        return Singleton.INSTANCE;
    }

    public TakeThreadDumpAction() {
        this.setIcon(Icons.getIcon((String)"ProfilerIcons.SnapshotThreads"));
        this.putValue("iconBase", Icons.getResource((String)"ProfilerIcons.SnapshotThreads"));
        this.putProperty("ShortDescription", Bundle.HINT_TakeThreadDumpAction());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Bundle.LBL_TakeThreadDumpAction();
    }

    @Override
    protected int[] enabledStates() {
        return ENABLED_STATES;
    }

    public void performAction() {
        new SwingWorker<ThreadDump, Object>(){

            @Override
            protected ThreadDump doInBackground() throws Exception {
                try {
                    ProfilerClient client = Profiler.getDefault().getTargetAppRunner().getProfilerClient();
                    return client.takeThreadDump();
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    ProfilerLogger.log((String)ex.getMessage());
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    ThreadDump threadDump = (ThreadDump)this.get();
                    if (threadDump != null) {
                        ThreadDumpWindow win = new ThreadDumpWindow(threadDump);
                        win.open();
                        win.requestActive();
                    }
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }.execute();
    }

    private static final class Singleton {
        private static final TakeThreadDumpAction INSTANCE = new TakeThreadDumpAction();

        private Singleton() {
        }
    }
}

