/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graalvm.visualvm.lib.profiler.snaptracer.Positionable;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerPackage;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerPackageProvider;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.IdeSnapshot;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.packages.TestPackageProvider;
import org.openide.util.RequestProcessor;

public final class TracerSupportImpl {
    private static TracerSupportImpl INSTANCE;
    private static RequestProcessor PROCESSOR;
    private final Set<TracerPackageProvider> providers = new HashSet<TracerPackageProvider>();

    public static synchronized TracerSupportImpl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TracerSupportImpl();
            PROCESSOR = new RequestProcessor("Tracer Processor", 5);
        }
        return INSTANCE;
    }

    public synchronized void registerPackageProvider(TracerPackageProvider provider) {
        this.providers.add(provider);
    }

    public synchronized void unregisterPackageProvider(TracerPackageProvider provider) {
        this.providers.remove(provider);
    }

    public synchronized boolean hasPackages(Object target) {
        for (TracerPackageProvider provider : this.providers) {
            if (!provider.getScope().isInstance(target)) continue;
            return true;
        }
        return false;
    }

    public synchronized List<TracerPackage> getPackages(IdeSnapshot snapshot) {
        ArrayList<TracerPackage> packages = new ArrayList<TracerPackage>();
        for (TracerPackageProvider provider : this.providers) {
            packages.addAll(Arrays.asList(provider.getPackages(snapshot)));
        }
        Collections.sort(packages, Positionable.COMPARATOR);
        return packages;
    }

    public void perform(Runnable task) {
        PROCESSOR.post(task);
    }

    private TracerSupportImpl() {
        this.registerPackageProvider(new TestPackageProvider());
    }
}

