/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.canvas;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.charts.canvas.TransformableCanvasComponent;

public abstract class InteractiveCanvasComponent
extends TransformableCanvasComponent {
    public static final int ZOOM_ALL = 0;
    public static final int ZOOM_X = 1;
    public static final int ZOOM_Y = 2;
    private ScrollBarManager hScrollBarManager;
    private ScrollBarManager vScrollBarManager;
    private MousePanHandler mousePanHandler;
    private int mousePanningButton = 1;
    private Cursor mousePanningCursor = Cursor.getPredefinedCursor(13);
    private int zoomMode;
    private double mouseZoomingFactor;
    private MouseZoomHandler mouseZoomHandler;

    public InteractiveCanvasComponent() {
        this.enableMousePanning();
        this.zoomMode = 0;
        this.mouseZoomingFactor = 1.05;
        this.enableMouseZooming();
    }

    public final void attachHorizontalScrollBar(JScrollBar scrollBar) {
        if (this.hScrollBarManager == null) {
            this.hScrollBarManager = new ScrollBarManager();
        }
        this.hScrollBarManager.attachScrollBar(scrollBar, true);
    }

    public final void detachHorizontalScrollBar() {
        if (this.hScrollBarManager != null) {
            this.hScrollBarManager.detachScrollBar();
        }
        this.hScrollBarManager = null;
    }

    public final void attachVerticalScrollBar(JScrollBar scrollBar) {
        if (this.vScrollBarManager == null) {
            this.vScrollBarManager = new ScrollBarManager();
        }
        this.vScrollBarManager.attachScrollBar(scrollBar, false);
    }

    public final void detachVerticalScrollBar() {
        if (this.vScrollBarManager != null) {
            this.vScrollBarManager.detachScrollBar();
        }
        this.vScrollBarManager = null;
    }

    private void updateScrollBars(boolean valueOnly) {
        if (this.hScrollBarManager != null) {
            this.hScrollBarManager.syncScrollBar(valueOnly);
        }
        if (this.vScrollBarManager != null) {
            this.vScrollBarManager.syncScrollBar(valueOnly);
        }
    }

    @Override
    protected void offsetChanged(long oldOffsetX, long oldOffsetY, long newOffsetX, long newOffsetY) {
        super.offsetChanged(oldOffsetX, oldOffsetY, newOffsetX, newOffsetY);
        this.updateScrollBars(true);
    }

    @Override
    protected void scaleChanged(double oldScaleX, double oldScaleY, double newScaleX, double newScaleY) {
        super.scaleChanged(oldScaleX, oldScaleY, newScaleX, newScaleY);
        this.updateScrollBars(false);
    }

    @Override
    protected void dataBoundsChanged(long dataOffsetX, long dataOffsetY, long dataWidth, long dataHeight, long oldDataOffsetX, long oldDataOffsetY, long oldDataWidth, long oldDataHeight) {
        super.dataBoundsChanged(dataOffsetX, dataOffsetY, dataWidth, dataHeight, oldDataOffsetX, oldDataOffsetY, oldDataWidth, oldDataHeight);
        this.updateScrollBars(false);
    }

    @Override
    protected void reshaped(Rectangle oldBounds, Rectangle newBounds) {
        super.reshaped(oldBounds, newBounds);
        this.updateScrollBars(false);
    }

    public final void setMousePanningEnabled(boolean enabled) {
        if (enabled) {
            this.enableMousePanning();
        } else {
            this.disableMousePanning();
        }
    }

    public final void enableMousePanning() {
        if (this.mousePanHandler != null) {
            return;
        }
        this.mousePanHandler = new MousePanHandler();
        this.addMouseListener(this.mousePanHandler);
        this.addMouseMotionListener(this.mousePanHandler);
    }

    public final void disableMousePanning() {
        if (this.mousePanHandler == null) {
            return;
        }
        this.removeMouseListener(this.mousePanHandler);
        this.removeMouseMotionListener(this.mousePanHandler);
        this.mousePanHandler = null;
        this.setCursor(Cursor.getDefaultCursor());
    }

    public final boolean isMousePanningEnabled() {
        return this.mousePanHandler != null;
    }

    public final boolean panningPossible() {
        return this.getContentsWidth() > (long)this.getWidth() || this.getContentsHeight() > (long)this.getHeight();
    }

    public final void setMousePanningButton(int mousePanningButton) {
        this.mousePanningButton = mousePanningButton;
    }

    public final int getMousePanningButton() {
        return this.mousePanningButton;
    }

    public final void setMousePanningCursor(Cursor mousePanningCursor) {
        this.mousePanningCursor = mousePanningCursor;
    }

    public final Cursor getMousePanningCursor() {
        return this.mousePanningCursor;
    }

    public final void setZoomMode(int zoomMode) {
        this.zoomMode = zoomMode;
    }

    public final int getZoomMode() {
        return this.zoomMode;
    }

    public final void zoom(int centerX, int centerY, double factor) {
        double scaleY;
        boolean fitsWidth = this.fitsWidth();
        boolean fitsHeight = this.fitsHeight();
        if (fitsWidth && fitsHeight) {
            return;
        }
        double scaleX = this.getScaleX();
        if (scaleX * (scaleY = this.getScaleY()) == 0.0) {
            return;
        }
        double newScaleX = this.zoomMode == 2 || fitsWidth ? scaleX : scaleX * factor;
        double newScaleY = this.zoomMode == 1 || fitsHeight ? scaleY : scaleY * factor;
        double dataX = this.getDataX(centerX);
        double dataY = this.getDataY(centerY);
        this.setScale(newScaleX, newScaleY);
        long offsetX = this.getOffsetX();
        long offsetY = this.getOffsetY();
        if (!fitsWidth && this.zoomMode != 2) {
            double dataWidth = dataX - (double)this.getDataOffsetX();
            long viewWidth = (long)Math.ceil(this.getViewWidth(dataWidth));
            long l = offsetX = this.isRightBased() ? viewWidth - (long)this.getWidth() + (long)centerX : viewWidth - (long)centerX;
        }
        if (!fitsHeight && this.zoomMode != 1) {
            double dataHeight = dataY - (double)this.getDataOffsetY();
            long viewHeight = (long)Math.ceil(this.getViewHeight(dataHeight));
            offsetY = this.isBottomBased() ? viewHeight - (long)this.getHeight() + (long)centerY : viewHeight - (long)centerY;
        }
        this.setOffset(offsetX, offsetY);
    }

    public final void setMouseZoomingEnabled(boolean enabled) {
        if (enabled) {
            this.enableMouseZooming();
        } else {
            this.disableMouseZooming();
        }
    }

    public final void enableMouseZooming() {
        if (this.mouseZoomHandler != null) {
            return;
        }
        this.mouseZoomHandler = new MouseZoomHandler();
        this.addMouseWheelListener(this.mouseZoomHandler);
    }

    public final void disableMouseZooming() {
        if (this.mouseZoomHandler == null) {
            return;
        }
        this.removeMouseWheelListener(this.mouseZoomHandler);
        this.mouseZoomHandler = null;
    }

    public final boolean isMouseZoomingEnabled() {
        return this.mouseZoomHandler != null;
    }

    public final double getMouseZoomingFactor() {
        return this.mouseZoomingFactor;
    }

    public final void setMouseZoomingFactor(double mouseZoomingFactor) {
        this.mouseZoomingFactor = mouseZoomingFactor;
    }

    private class MouseZoomHandler
    implements MouseWheelListener {
        private MouseZoomHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollType() == 0) {
                InteractiveCanvasComponent.this.zoom(e.getX(), e.getY(), Math.pow(InteractiveCanvasComponent.this.mouseZoomingFactor, -e.getUnitsToScroll()));
                InteractiveCanvasComponent.this.repaintDirty();
            }
        }
    }

    private class MousePanHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean dragging;
        private int lastMouseDragX;
        private int lastMouseDragY;

        private MousePanHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            boolean bl = this.dragging = InteractiveCanvasComponent.this.panningPossible() && e.getButton() == InteractiveCanvasComponent.this.mousePanningButton;
            if (!this.dragging) {
                return;
            }
            this.lastMouseDragX = e.getX();
            this.lastMouseDragY = e.getY();
            if (InteractiveCanvasComponent.this.mousePanningCursor != null && InteractiveCanvasComponent.this.isMousePanningEnabled()) {
                InteractiveCanvasComponent.this.setCursor(InteractiveCanvasComponent.this.mousePanningCursor);
            }
            if (!InteractiveCanvasComponent.this.isOffsetAdjusting()) {
                InteractiveCanvasComponent.this.offsetAdjustingStarted();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dragging = false;
            if (InteractiveCanvasComponent.this.mousePanningCursor != null) {
                InteractiveCanvasComponent.this.setCursor(Cursor.getDefaultCursor());
            }
            if (InteractiveCanvasComponent.this.isOffsetAdjusting()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InteractiveCanvasComponent.this.offsetAdjustingFinished();
                        InteractiveCanvasComponent.this.repaintDirty();
                    }
                });
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.dragging) {
                return;
            }
            int mouseDragX = e.getX();
            int mouseDragY = e.getY();
            long oldOffsetX = InteractiveCanvasComponent.this.getOffsetX();
            long oldOffsetY = InteractiveCanvasComponent.this.getOffsetY();
            if (this.lastMouseDragX != 0 && this.lastMouseDragY != 0) {
                int mouseDragDx = InteractiveCanvasComponent.this.isRightBased() ? mouseDragX - this.lastMouseDragX : this.lastMouseDragX - mouseDragX;
                int mouseDragDy = InteractiveCanvasComponent.this.isBottomBased() ? mouseDragY - this.lastMouseDragY : this.lastMouseDragY - mouseDragY;
                InteractiveCanvasComponent.this.setOffset(oldOffsetX + (long)mouseDragDx, oldOffsetY + (long)mouseDragDy);
                InteractiveCanvasComponent.this.repaintDirtyAccel();
            }
            if (InteractiveCanvasComponent.this.getOffsetX() != oldOffsetX) {
                this.lastMouseDragX = mouseDragX;
            }
            if (InteractiveCanvasComponent.this.getOffsetY() != oldOffsetY) {
                this.lastMouseDragY = mouseDragY;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class ScrollBarManager
    implements AdjustmentListener,
    MouseWheelListener {
        private static final int SCROLLBAR_UNIT_INCREMENT = 20;
        private JScrollBar scrollBar;
        private double scrollBarFactor;
        boolean horizontal;
        boolean internalChange;

        private ScrollBarManager() {
        }

        public void attachScrollBar(JScrollBar scrollBar, boolean horizontal) {
            if (this.scrollBar == scrollBar) {
                return;
            }
            if (this.scrollBar != null) {
                this.detachScrollBar();
            }
            this.scrollBar = scrollBar;
            this.horizontal = horizontal;
            scrollBar.addAdjustmentListener(this);
            scrollBar.addMouseWheelListener(this);
            if (!horizontal) {
                InteractiveCanvasComponent.this.addMouseWheelListener(this);
            }
        }

        public void detachScrollBar() {
            if (this.scrollBar == null) {
                return;
            }
            if (!this.horizontal) {
                InteractiveCanvasComponent.this.removeMouseWheelListener(this);
            }
            this.scrollBar.removeMouseWheelListener(this);
            this.scrollBar.removeAdjustmentListener(this);
            this.scrollBar = null;
        }

        public void syncScrollBar(boolean valueOnly) {
            this.internalChange = true;
            if (valueOnly) {
                int value;
                long offsetX = InteractiveCanvasComponent.this.getOffsetX();
                long offsetY = InteractiveCanvasComponent.this.getOffsetY();
                int n = value = this.horizontal ? this.getInt(offsetX) : this.getInt(offsetY);
                if (this.reversedValue()) {
                    value = this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount() - value;
                }
                this.scrollBar.setValue(value);
            } else {
                int blockIncr;
                this.updateFactor();
                long offsetX = InteractiveCanvasComponent.this.getOffsetX();
                long offsetY = InteractiveCanvasComponent.this.getOffsetY();
                long maxOffsetX = InteractiveCanvasComponent.this.getMaxOffsetX();
                long maxOffsetY = InteractiveCanvasComponent.this.getMaxOffsetY();
                int value = this.horizontal ? this.getInt(offsetX) : this.getInt(offsetY);
                int extent = this.horizontal ? this.getInt(InteractiveCanvasComponent.this.getWidth()) : this.getInt(InteractiveCanvasComponent.this.getHeight());
                int maximum = this.horizontal ? this.getInt(maxOffsetX) : this.getInt(maxOffsetY);
                int unitIncr = this.horizontal ? this.getInt(20L) : this.getInt(20L);
                int n = blockIncr = this.horizontal ? this.getInt(InteractiveCanvasComponent.this.getWidth() - 20) : this.getInt(InteractiveCanvasComponent.this.getHeight() - 20);
                if (this.reversedValue()) {
                    value = maximum - value;
                }
                this.scrollBar.setEnabled(maximum > 0);
                this.scrollBar.setValues(value, extent, 0, maximum + extent);
                this.scrollBar.setUnitIncrement(unitIncr);
                this.scrollBar.setBlockIncrement(blockIncr);
            }
            this.internalChange = false;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            boolean offsetAdjusting;
            if (this.internalChange) {
                return;
            }
            boolean valueAdjusting = e.getValueIsAdjusting();
            if (this.horizontal) {
                offsetAdjusting = InteractiveCanvasComponent.this.isHOffsetAdjusting();
                if (valueAdjusting && !offsetAdjusting) {
                    InteractiveCanvasComponent.this.hOffsetAdjustingStarted();
                }
                InteractiveCanvasComponent.this.setOffset(this.getValue(), InteractiveCanvasComponent.this.getOffsetY());
            } else {
                offsetAdjusting = InteractiveCanvasComponent.this.isVOffsetAdjusting();
                if (valueAdjusting && !offsetAdjusting) {
                    InteractiveCanvasComponent.this.vOffsetAdjustingStarted();
                }
                InteractiveCanvasComponent.this.setOffset(InteractiveCanvasComponent.this.getOffsetX(), this.getValue());
            }
            InteractiveCanvasComponent.this.repaintDirtyAccel();
            if (!valueAdjusting && offsetAdjusting) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ScrollBarManager.this.horizontal) {
                            InteractiveCanvasComponent.this.hOffsetAdjustingFinished();
                        } else {
                            InteractiveCanvasComponent.this.vOffsetAdjustingFinished();
                        }
                        InteractiveCanvasComponent.this.repaintDirty();
                    }
                });
            }
        }

        public long getValue() {
            long value = this.scrollBar.getValue();
            if (this.reversedValue()) {
                value = (long)(this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount()) - value;
            }
            return (long)((double)value / this.scrollBarFactor);
        }

        private void updateFactor() {
            int height;
            int width;
            long maxOffsetX = InteractiveCanvasComponent.this.getMaxOffsetX();
            long maxOffsetY = InteractiveCanvasComponent.this.getMaxOffsetY();
            this.scrollBarFactor = this.horizontal ? (maxOffsetX + (long)(width = InteractiveCanvasComponent.this.getWidth()) > Integer.MAX_VALUE ? 2.147483647E9 / (double)(maxOffsetX + (long)width) : 1.0) : (maxOffsetY + (long)(height = InteractiveCanvasComponent.this.getHeight()) > Integer.MAX_VALUE ? 2.147483647E9 / (double)(maxOffsetY + (long)height) : 1.0);
        }

        private boolean reversedValue() {
            return this.horizontal ? InteractiveCanvasComponent.this.isRightBased() : InteractiveCanvasComponent.this.isBottomBased();
        }

        private int getInt(long value) {
            return (int)((double)value * this.scrollBarFactor);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (InteractiveCanvasComponent.this.isMouseZoomingEnabled() && e.getSource() == InteractiveCanvasComponent.this) {
                return;
            }
            if (e.getScrollType() == 0) {
                int direction;
                int unitsToScroll = e.getUnitsToScroll();
                int n = direction = unitsToScroll < 0 ? -1 : 1;
                if (unitsToScroll != 0) {
                    int increment = this.scrollBar.getUnitIncrement(direction);
                    int oldValue = this.scrollBar.getValue();
                    int newValue = oldValue + increment * unitsToScroll;
                    if (oldValue != (newValue = Math.max(Math.min(newValue, this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount()), this.scrollBar.getMinimum()))) {
                        this.scrollBar.setValue(newValue);
                    }
                }
            }
        }
    }
}

