/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasource;

import java.util.Set;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.DataSourceProvider;

public final class DataSourceContainer
extends DataSourceProvider {
    private final DataSource owner;

    DataSourceContainer(DataSource owner) {
        this.owner = owner;
    }

    public void addDataSource(DataSource added) {
        this.registerDataSource(added);
    }

    public void addDataSources(Set<? extends DataSource> added) {
        super.registerDataSources(added);
    }

    public void removeDataSource(DataSource removed) {
        this.unregisterDataSource(removed);
    }

    public void removeDataSources(Set<? extends DataSource> removed) {
        super.unregisterDataSources(removed);
    }

    public void updateDataSources(Set<? extends DataSource> added, Set<? extends DataSource> removed) {
        super.changeDataSources(added, removed);
    }

    @Override
    protected void registerDataSourcesImpl(Set<? extends DataSource> added) {
        for (DataSource dataSource : added) {
            dataSource.addImpl(this.owner);
        }
        super.registerDataSourcesImpl(added);
    }

    @Override
    protected void unregisterDataSourcesImpl(Set<? extends DataSource> removed) {
        for (DataSource dataSource : removed) {
            DataSourceContainer dataSourceRepository = dataSource.getRepository();
            dataSourceRepository.unregisterDataSourcesImpl(dataSourceRepository.getDataSources());
            dataSource.removeImpl();
        }
        super.unregisterDataSourcesImpl(removed);
    }
}

