-- Map objects
objects = {}

objects["Ancient_Sign1"] = {
    animation_filename = "data/entities/map/objects/ancient_sign.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 6.0 * 16,
    img_half_width = 2.0 * 16,
    img_height = 6.0 * 16
}

objects["Barrel1"] = {
    animation_filename = "data/entities/map/objects/barrel1.lua",
    coll_half_width = 0.78 * 16,
    coll_height = 1.6 * 16,
    img_half_width = 0.78 * 16,
    img_height = 2.125 * 16
}

objects["Bed1"] = {
    animation_filename = "data/entities/map/objects/bed1.lua",
    coll_half_width = 1.75 * 16,
    coll_height = 5.50 * 16,
    img_half_width = 1.75 * 16,
    img_height = 5.68 * 16
}

objects["Bed2"] = {
    animation_filename = "data/entities/map/objects/bed2.lua",
    coll_half_width = 3.31 * 16,
    coll_height = 5.50 * 16,
    img_half_width = 3.31 * 16,
    img_height = 5.68 * 16
}

objects["Bench1"] = {
    animation_filename = "data/entities/map/objects/bench1.lua",
    coll_half_width = 3.0 * 16,
    coll_height = 1.6 * 16,
    img_half_width = 3.0 * 16,
    img_height = 2.0 * 16
}

objects["Bench2"] = {
    animation_filename = "data/entities/map/objects/bench2.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.6 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Bones1"] = {
    animation_filename = "data/entities/map/objects/bones1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.7 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Box1"] = {
    animation_filename = "data/entities/map/objects/box1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 2.27 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.37 * 16
}

objects["Book1"] = {
    animation_filename = "data/entities/map/objects/book1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Bread1"] = {
    animation_filename = "data/entities/map/objects/bread1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Bridge1_up"] = {
    animation_filename = "data/entities/map/objects/bridge_up.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 2.0 * 16,
    img_half_width = 2.0 * 16,
    img_height = 2.0 * 16
}

objects["Bridge1_middle"] = {
    animation_filename = "data/entities/map/objects/bridge_middle.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 2.0 * 16,
    img_half_width = 2.0 * 16,
    img_height = 2.0 * 16
}

objects["Bridge1_down"] = {
    animation_filename = "data/entities/map/objects/bridge_down.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 2.0 * 16,
    img_half_width = 2.0 * 16,
    img_height = 2.0 * 16
}

objects["Bubble"] = {
    animation_filename = "data/entities/map/objects/bubble.lua",
    coll_half_width = 0.5 * 16,
    coll_height = 1.0 * 16,
    img_half_width = 0.5 * 16,
    img_height = 1.0 * 16
}

objects["Bush1"] = {
    animation_filename = "data/entities/map/objects/bush1.lua",
    coll_half_width = 1.9 * 16,
    coll_height = 3.8 * 16,
    img_half_width = 2.0 * 16,
    img_height = 4.0 * 16
}

objects["Bush2"] = {
    animation_filename = "data/entities/map/objects/bush2.lua",
    coll_half_width = 1.9 * 16,
    coll_height = 3.8 * 16,
    img_half_width = 2.0 * 16,
    img_height = 4.0 * 16
}

objects["Bush3"] = {
    animation_filename = "data/entities/map/objects/bush3.lua",
    coll_half_width = 1.9 * 16,
    coll_height = 3.8 * 16,
    img_half_width = 2.0 * 16,
    img_height = 4.0 * 16
}

objects["Bush4"] = {
    animation_filename = "data/entities/map/objects/bush4.lua",
    coll_half_width = 1.9 * 16,
    coll_height = 3.8 * 16,
    img_half_width = 2.0 * 16,
    img_height = 4.0 * 16
}

objects["Campfire1"] = {
    animation_filename = "data/entities/map/objects/campfire1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.6 * 16,
    img_half_width = 2.0 * 16,
    img_height = 4.0 * 16
}

objects["Candle1"] = {
    animation_filename = "data/entities/map/objects/candle1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Candle Holder1"] = {
    animation_filename = "data/entities/map/objects/candle_holder1.lua",
    coll_half_width = 0.8 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 0.84 * 16,
    img_height = 3.06 * 16
}

objects["Candle Holder2"] = {
    animation_filename = "data/entities/map/objects/candle_holder2.lua",
    coll_half_width = 0.9 * 16,
    coll_height = 1.6 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Cat1"] = {
    animation_filename = "data/entities/map/objects/cat1.lua",
    coll_half_width = 0.95 * 16,
    coll_height = 0.9 * 16,
    img_half_width = 0.68 * 16,
    img_height = 1.56 * 16
}

objects["Chair1"] = {
    animation_filename = "data/entities/map/objects/chair1.lua",
    coll_half_width = 0.95 * 16,
    coll_height = 0.9 * 16,
    img_half_width = 0.95 * 16,
    img_height = 2.9 * 16
}

objects["Chair1_inverted"] = {
    animation_filename = "data/entities/map/objects/chair1_inverted.lua",
    coll_half_width = 0.95 * 16,
    coll_height = 0.9 * 16,
    img_half_width = 0.95 * 16,
    img_height = 2.9 * 16
}

objects["Chair1_north"] = {
    animation_filename = "data/entities/map/objects/chair1_north.lua",
    coll_half_width = 0.75 * 16,
    coll_height = 0.9 * 16,
    img_half_width = 0.75 * 16,
    img_height = 2.81 * 16
}

objects["Chair2"] = {
    animation_filename = "data/entities/map/objects/chair2.lua",
    coll_half_width = 0.95 * 16,
    coll_height = 0.9 * 16,
    img_half_width = 0.95 * 16,
    img_height = 2.9 * 16
}

objects["Clock1"] = {
    animation_filename = "data/entities/map/objects/clock1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.9 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Dog1"] = {
    animation_filename = "data/entities/map/objects/dog1.lua",
    coll_half_width = 1.18 * 16,
    coll_height = 1.6 * 16,
    img_half_width = 1.18 * 16,
    img_height = 2.6 * 16
}

objects["Door1_big"] = {
    animation_filename = "data/entities/map/objects/door_big1.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 8.125 * 16,
    img_half_width = 2.0 * 16,
    img_height = 8.125 * 16
}

objects["Dorver1"] = {
    animation_filename = "data/entities/map/objects/dorver1.lua",
    coll_half_width = 3.20 * 16,
    coll_height = 5.0 * 16,
    img_half_width = 3.39 * 16,
    img_height = 5.145 * 16
}

objects["Dorver1_left"] = {
    animation_filename = "data/entities/map/objects/dorver1_left.lua",
    coll_half_width = 3.20 * 16,
    coll_height = 5.0 * 16,
    img_half_width = 3.39 * 16,
    img_height = 5.145 * 16
}

objects["Fence1 horizontal"] = {
    animation_filename = "data/entities/map/objects/fence1-horizontal.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.2 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Fence1 vertical"] = {
    animation_filename = "data/entities/map/objects/fence1-vertical.lua",
    coll_half_width = 0.6 * 16,
    coll_height = 2.0 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Fence1 l top left"] = {
    animation_filename = "data/entities/map/objects/fence1-l-top-left.lua",
    coll_half_width = 0.6 * 16,
    coll_height = 1.2 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Fence1 l top right"] = {
    animation_filename = "data/entities/map/objects/fence1-l-top-right.lua",
    coll_half_width = 0.6 * 16,
    coll_height = 1.2 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Fence1 l bottom left"] = {
    animation_filename = "data/entities/map/objects/fence1-l-bottom-left.lua",
    coll_half_width = 0.6 * 16,
    coll_height = 1.2 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Fence1 l bottom right"] = {
    animation_filename = "data/entities/map/objects/fence1-l-bottom-right.lua",
    coll_half_width = 0.6 * 16,
    coll_height = 1.2 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Flame1"] = {
    animation_filename = "data/entities/map/objects/flame1.lua",
    coll_half_width = 0.5 * 16,
    coll_height = 1.5 * 16,
    img_half_width = 0.5 * 16,
    img_height = 1.5 * 16
}

objects["Flame Pot1"] = {
    animation_filename = "data/entities/map/objects/flame_pot1.lua",
    coll_half_width = 0.6 * 16,
    coll_height = 1.3 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Flower Pot1"] = {
    animation_filename = "data/entities/map/objects/flower_pot1.lua",
    coll_half_width = 0.59 * 16,
    coll_height = 1.2 * 16,
    img_half_width = 0.59 * 16,
    img_height = 1.68 * 16
}

objects["Flower Pot2"] = {
    animation_filename = "data/entities/map/objects/flower_pot2.lua",
    coll_half_width = 0.53 * 16,
    coll_height = 1.2 * 16,
    img_half_width = 0.53 * 16,
    img_height = 1.75 * 16
}

objects["Gate1 closed"] = {
    animation_filename = "data/entities/map/objects/gate1_closed.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 1.0 * 16,
    img_half_width = 2.0 * 16,
    img_height = 6.0 * 16
}

objects["Gate1 open"] = {
    animation_filename = "data/entities/map/objects/gate1_open.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 1.0 * 16,
    img_half_width = 2.0 * 16,
    img_height = 2.0 * 16
}

objects["Grass Clump1"] = {
    animation_filename = "data/entities/map/objects/grass_clump1.lua",
    coll_half_width = 2.2 * 16,
    coll_height = 1.2 * 16,
    img_half_width = 2.5 * 16,
    img_height = 3.5 * 16
}

objects["Green Pepper1"] = {
    animation_filename = "data/entities/map/objects/green_pepper1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Harlequin"] = {
    animation_filename = "data/entities/map/objects/harlequin.lua",
    coll_half_width = 2.3 * 16,
    coll_height = 2.0 * 16,
    img_half_width = 2.46 * 16,
    img_height = 5.8 * 16
}

objects["Jar1"] = {
    animation_filename = "data/entities/map/objects/jar1.lua",
    coll_half_width = 0.5 * 16,
    coll_height = 1.2 * 16,
    img_half_width = 0.625 * 16,
    img_height = 1.68 * 16
}

objects["Knife1"] = {
    animation_filename = "data/entities/map/objects/knife1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Layna Statue"] = {
    animation_filename = "data/entities/map/objects/layna_statue.lua",
    coll_half_width = 0.93 * 16,
    coll_height = 2.0 * 16,
    img_half_width = 0.93 * 16,
    img_height = 5.31 * 16
}

objects["Locker"] = {
    animation_filename = "data/entities/map/objects/locker.lua",
    coll_half_width = 0.75 * 16,
    coll_height = 1.1 * 16,
    img_half_width = 0.75 * 16,
    img_height = 1.43 * 16
}

objects["Oil Lamp"] = {
    animation_filename = "data/entities/map/objects/oil_lamp.lua",
    coll_half_width = 0.5 * 16,
    coll_height = 0.9 * 16,
    img_half_width = 0.625 * 16,
    img_height = 1.81 * 16
}

objects["Paper and Feather"] = {
    animation_filename = "data/entities/map/objects/paper_feather.lua",
    coll_half_width = 0.93 * 16,
    coll_height = 1.75 * 16,
    img_half_width = 0.93 * 16,
    img_height = 1.75 * 16
}

objects["Parchment"] = {
    animation_filename = "data/entities/map/objects/parchment.lua",
    coll_half_width = 0.59 * 16,
    coll_height = 1.31 * 16,
    img_half_width = 0.59 * 16,
    img_height = 1.31 * 16
}

objects["Plate Pile1"] = {
    animation_filename = "data/entities/map/objects/plate_pile1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Rock1"] = {
    animation_filename = "data/entities/map/objects/rock1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.63 * 16,
    img_half_width = 1.0 * 16,
    img_height = 1.93 * 16
}

objects["Rock1 snow"] = {
    animation_filename = "data/entities/map/objects/rock1_snow.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.64 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Rock2"] = {
    animation_filename = "data/entities/map/objects/rock2.lua",
    coll_half_width = 0.9 * 16,
    coll_height = 1.78 * 16,
    img_half_width = 0.9 * 16,
    img_height = 3.56 * 16
}

objects["Rock3"] = {
    animation_filename = "data/entities/map/objects/rock3.lua",
    coll_half_width = 4.0 * 16,
    coll_height = 6.0 * 16,
    img_half_width = 4.0 * 16,
    img_height = 6.0 * 16
}

objects["Rolling Stone"] = {
    animation_filename = "data/entities/map/objects/rolling_stone1.lua",
    coll_half_width = 0.9 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Rolling Stone2"] = {
    animation_filename = "data/entities/map/objects/rolling_stone2.lua",
    coll_half_width = 0.9 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Sauce Pot1"] = {
    animation_filename = "data/entities/map/objects/sauce_pot1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Stone Sign1"] = {
   animation_filename = "data/entities/map/objects/stone_sign1.lua",
   coll_half_width = 1.03 * 16,
   coll_height = 2.18 * 16,
   img_half_width = 1.03 * 16,
   img_height = 2.18 * 16
}

objects["Stone Fence1"] = {
   animation_filename = "data/entities/map/objects/stone_fence1.lua",
   coll_half_width = 1.0 * 16,
   coll_height = 1.8 * 16,
   img_half_width = 1.0 * 16,
   img_height = 2.625 * 16
}

objects["Stele1"] = {
   animation_filename = "data/entities/map/objects/stele1.lua",
   coll_half_width = 1.0 * 16,
   coll_height = 2.18 * 16,
   img_half_width = 1.06 * 16,
   img_height = 4.0 * 16
}

objects["Table1"] = {
    animation_filename = "data/entities/map/objects/table1.lua",
    coll_half_width = 2.95 * 16,
    coll_height = 3.9 * 16,
    img_half_width = 2.95 * 16,
    img_height = 5.0 * 16
}

objects["Table2"] = {
    animation_filename = "data/entities/map/objects/table2.lua",
    coll_half_width = 2.95 * 16,
    coll_height = 3.9 * 16,
    img_half_width = 2.95 * 16,
    img_height = 5.0 * 16
}

objects["Big Wooden Table"] = {
    animation_filename = "data/entities/map/objects/wooden_table_big.lua",
    coll_half_width = 3.0 * 16,
    coll_height = 4.77 * 16,
    img_half_width = 3.0 * 16,
    img_height = 4.87 * 16
}

objects["Small Wooden Table"] = {
    animation_filename = "data/entities/map/objects/wooden_table_small.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 2.7 * 16,
    img_half_width = 2.0 * 16,
    img_height = 4.0 * 16
}

objects["Salad1"] = {
    animation_filename = "data/entities/map/objects/salad1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 1.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 2.0 * 16
}

objects["Spikes1"] = {
    animation_filename = "data/entities/map/objects/spikes1.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 2.0 * 16,
    img_half_width = 1.0 * 16,
    img_height = 3.0 * 16
}

objects["Spikes_broken1"] = {
    animation_filename = "data/entities/map/objects/spikes_broken1.lua",
    coll_half_width = 0.906 * 16,
    coll_height = 1.56 * 16,
    img_half_width = 0.906 * 16,
    img_height = 1.56 * 16
}

objects["Tree Big1"] = {
    animation_filename = "data/entities/map/objects/tree_big1.lua",
    coll_half_width = 3.0 * 16,
    coll_height = 4.0 * 16,
    img_half_width = 3.0 * 16,
    img_height = 8.0 * 16
}

objects["Tree Big1 snow"] = {
    animation_filename = "data/entities/map/objects/tree_big1_snow.lua",
    coll_half_width = 3.0 * 16,
    coll_height = 4.0 * 16,
    img_half_width = 3.0 * 16,
    img_height = 8.0 * 16
}

objects["Tree Big2"] = {
    animation_filename = "data/entities/map/objects/tree_big2.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 3.4 * 16,
    img_half_width = 2.0 * 16,
    img_height = 6.8 * 16
}

objects["Tree Big2 snow"] = {
    animation_filename = "data/entities/map/objects/tree_big2_snow.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 3.5 * 16,
    img_half_width = 2.0 * 16,
    img_height = 7.06 * 16
}

objects["Tree Big2 snow2"] = {
    animation_filename = "data/entities/map/objects/tree_big2_snow2.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 3.5 * 16,
    img_half_width = 2.0 * 16,
    img_height = 7.0 * 16
}

objects["Tree Little1"] = {
    animation_filename = "data/entities/map/objects/tree_little1.lua",
    coll_half_width = 1.5 * 16,
    coll_height = 2.8 * 16,
    img_half_width = 2.0 * 16,
    img_height = 6.0 * 16
}

objects["Tree Little2"] = {
    animation_filename = "data/entities/map/objects/tree_little2.lua",
    coll_half_width = 1.5 * 16,
    coll_height = 2.8 * 16,
    img_half_width = 2.0 * 16,
    img_height = 6.0 * 16
}

objects["Tree Little3"] = {
    animation_filename = "data/entities/map/objects/tree_little3.lua",
    coll_half_width = 1.5 * 16,
    coll_height = 2.8 * 16,
    img_half_width = 2.0 * 16,
    img_height = 6.0 * 16
}

objects["Tree Little4"] = {
    animation_filename = "data/entities/map/objects/tree_little4.lua",
    coll_half_width = 1.5 * 16,
    coll_height = 2.8 * 16,
    img_half_width = 2.0 * 16,
    img_height = 6.0 * 16
}

objects["Tree Small1"] = {
    animation_filename = "data/entities/map/objects/tree_small1.lua",
    coll_half_width = 1.75 * 16,
    coll_height = 2.43 * 16,
    img_half_width = 1.75 * 16,
    img_height = 4.87 * 16
}

objects["Tree Small1 snow"] = {
    animation_filename = "data/entities/map/objects/tree_small1_snow.lua",
    coll_half_width = 1.93 * 16,
    coll_height = 2.43 * 16,
    img_half_width = 1.93 * 16,
    img_height = 5.125 * 16
}

objects["Tree Small2"] = {
    animation_filename = "data/entities/map/objects/tree_small2.lua",
    coll_half_width = 3.0 * 16,
    coll_height = 3.0 * 16,
    img_half_width = 3.0 * 16,
    img_height = 6.0 * 16
}

objects["Tree Small2 snow"] = {
    animation_filename = "data/entities/map/objects/tree_small2_snow.lua",
    coll_half_width = 3.0 * 16,
    coll_height = 3.0 * 16,
    img_half_width = 3.0 * 16,
    img_height = 6.0 * 16
}

objects["Tree Small3"] = {
    animation_filename = "data/entities/map/objects/tree_small3.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 2.5 * 16,
    img_half_width = 3.5 * 16,
    img_height = 8.0 * 16
}

objects["Tree Small3 Tilting"] = {
    animation_filename = "data/entities/map/objects/tree_small3_tilting.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 2.5 * 16,
    img_half_width = 3.46 * 16,
    img_height = 8.25 * 16
}

objects["Tree Small4"] = {
    animation_filename = "data/entities/map/objects/tree_small4.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 2.5 * 16,
    img_half_width = 3.5 * 16,
    img_height = 8.0 * 16
}

objects["Tree Small5"] = {
    animation_filename = "data/entities/map/objects/tree_small5.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 2.5 * 16,
    img_half_width = 3.5 * 16,
    img_height = 8.0 * 16
}

objects["Tree Small5 Fallen"] = {
    animation_filename = "data/entities/map/objects/tree_small5_fallen.lua",
    coll_half_width = 4.0 * 16,
    coll_height = 3.5 * 16,
    img_half_width = 4.03 * 16,
    img_height = 7.0 * 16
}

objects["Tree Small6"] = {
    animation_filename = "data/entities/map/objects/tree_small6.lua",
    coll_half_width = 2.0 * 16,
    coll_height = 2.5 * 16,
    img_half_width = 3.5 * 16,
    img_height = 8.0 * 16
}

objects["Tree Tiny1"] = {
    animation_filename = "data/entities/map/objects/tree_tiny1.lua",
    coll_half_width = 1.6 * 16,
    coll_height = 1.7 * 16,
    img_half_width = 2.0 * 16,
    img_height = 4.0 * 16
}

objects["Tree Tiny2"] = {
    animation_filename = "data/entities/map/objects/tree_tiny2.lua",
    coll_half_width = 1.6 * 16,
    coll_height = 1.7 * 16,
    img_half_width = 2.0 * 16,
    img_height = 4.0 * 16
}

objects["Tree Tiny3"] = {
    animation_filename = "data/entities/map/objects/tree_tiny3.lua",
    coll_half_width = 1.6 * 16,
    coll_height = 1.7 * 16,
    img_half_width = 2.0 * 16,
    img_height = 4.0 * 16
}

objects["Tree Tiny4"] = {
    animation_filename = "data/entities/map/objects/tree_tiny4.lua",
    coll_half_width = 1.6 * 16,
    coll_height = 1.7 * 16,
    img_half_width = 2.0 * 16,
    img_height = 4.0 * 16
}

objects["Vase1"] = {
    animation_filename = "data/entities/map/objects/vase1.lua",
    coll_half_width = 0.75 * 16,
    coll_height = 1.2 * 16,
    img_half_width = 0.75 * 16,
    img_height = 1.5 * 16
}

objects["Vase2"] = {
    animation_filename = "data/entities/map/objects/vase2.lua",
    coll_half_width = 0.75 * 16,
    coll_height = 1.3 * 16,
    img_half_width = 0.81 * 16,
    img_height = 2.5 * 16
}

objects["Vase3"] = {
    animation_filename = "data/entities/map/objects/vase3.lua",
    coll_half_width = 0.6 * 16,
    coll_height = 1.1 * 16,
    img_half_width = 0.68 * 16,
    img_height = 1.68 * 16
}

objects["Vase4"] = {
    animation_filename = "data/entities/map/objects/vase4.lua",
    coll_half_width = 0.5 * 16,
    coll_height = 1.1 * 16,
    img_half_width = 0.59 * 16,
    img_height = 2.0 * 16
}

objects["Waterfall1"] = {
    animation_filename = "data/entities/map/objects/waterfall1.lua",
    coll_half_width = 3 * 16,
    coll_height = 16 * 16,
    img_half_width = 3 * 16,
    img_height = 16 * 16
}

objects["Waterfall2"] = {
    animation_filename = "data/entities/map/objects/waterfall2.lua",
    coll_half_width = 3 * 16,
    coll_height = 8.93 * 16,
    img_half_width = 3 * 16,
    img_height = 8.93 * 16
}

objects["Waterfall3"] = {
    animation_filename = "data/entities/map/objects/waterfall2.lua",
    coll_half_width = 3 * 16,
    coll_height = 4.93 * 16,
    img_half_width = 3 * 16,
    img_height = 4.93 * 16
}

objects["Water Light1"] = {
    animation_filename = "data/entities/map/objects/water_light1.lua",
    coll_half_width = 16,
    coll_height = 3 * 16,
    img_half_width = 16,
    img_height = 3 * 16
}

objects["Well"] = {
    animation_filename = "data/entities/map/objects/well.lua",
    coll_half_width = 2.10 * 16,
    coll_height = 3.20 * 16,
    img_half_width = 2.43 * 16,
    img_height = 4.56 * 16
}

objects["Wood sign"] = {
    animation_filename = "data/entities/map/objects/wood_sign.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 0.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 3.18 * 16
}

objects["Wood sign info"] = {
    animation_filename = "data/entities/map/objects/wood_sign_info.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 0.8 * 16,
    img_half_width = 1.0 * 16,
    img_height = 3.18 * 16
}

objects["Wood sign snow"] = {
    animation_filename = "data/entities/map/objects/wood_sign_snow.lua",
    coll_half_width = 1.0 * 16,
    coll_height = 0.9 * 16,
    img_half_width = 1.0 * 16,
    img_height = 3.62 * 16
}

objects["Wooden Sword1"] = {
    animation_filename = "data/entities/map/objects/wooden_sword1.lua",
    coll_half_width = 0.65 * 16,
    coll_height = 2.5 * 16,
    img_half_width = 0.65 * 16,
    img_height = 2.5 * 16
}

-- "Ground" lights
-- Those are special light effect that have to be applied before the sky layer
objects["Left Window Light"] = {
    animation_filename = "data/visuals/lights/left_window_light.lua",
    coll_half_width = 0.0,
    coll_height = 0.0,
    img_half_width = 1.56 * 16,
    img_height = 4.5 * 16
}

objects["Right Window Light"] = {
    animation_filename = "data/visuals/lights/right_window_light.lua",
    coll_half_width = 0.0,
    coll_height = 0.0,
    img_half_width = 1.56 * 16,
    img_height = 4.5 * 16
}

objects["Left Window Light 2"] = {
    animation_filename = "data/visuals/lights/left_window_light.lua",
    coll_half_width = 0.0,
    coll_height = 0.0,
    img_half_width = 2.56 * 16,
    img_height = 6.5 * 16
}

objects["Right Window Light 2"] = {
    animation_filename = "data/visuals/lights/right_window_light.lua",
    coll_half_width = 0.0,
    coll_height = 0.0,
    img_half_width = 2.56 * 16,
    img_height = 6.5 * 16
}

-- The helper function permitting to easily create a prepared map object
function CreateObject(Map, name, x, y, layer)
    if (objects[name] == nil) then
        print("Error: No object named: "..name.." found!!");
        return nil;
    end

    if (Map == nil) then
        print("Error: Function called with invalid Map object");
        return nil;
    end

    -- Note: Auto-registered to the object supervisor.
    local object = vt_map.PhysicalObject.Create(layer);
    object:SetPosition(x, y);
    object:SetCollPixelHalfWidth(objects[name].coll_half_width);
    object:SetCollPixelHeight(objects[name].coll_height);
    object:SetImgPixelHalfWidth(objects[name].img_half_width);
    object:SetImgPixelHeight(objects[name].img_height);
    object:AddAnimation(objects[name].animation_filename);

    return object;
end
