/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.gost;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cryptopro.GostR3410KeyTransport;

public class TLSGostKeyTransportBlob
extends ASN1Object {
    private final GostR3410KeyTransport keyBlob;
    private final DERSequence proxyKeyBlobs;

    public static TLSGostKeyTransportBlob getInstance(Object obj) {
        if (obj instanceof TLSGostKeyTransportBlob) {
            return (TLSGostKeyTransportBlob)((Object)obj);
        }
        if (obj != null) {
            return new TLSGostKeyTransportBlob(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    private TLSGostKeyTransportBlob(ASN1Sequence seq) {
        this.keyBlob = GostR3410KeyTransport.getInstance((Object)seq.getObjectAt(0));
        this.proxyKeyBlobs = seq.size() > 1 ? (DERSequence)DERSequence.getInstance((Object)seq.getObjectAt(1)) : null;
    }

    public TLSGostKeyTransportBlob(GostR3410KeyTransport keyBlob) {
        this(keyBlob, null);
    }

    public TLSGostKeyTransportBlob(GostR3410KeyTransport keyBlob, DERSequence proxyKeyBlobs) {
        this.keyBlob = keyBlob;
        this.proxyKeyBlobs = proxyKeyBlobs;
    }

    public GostR3410KeyTransport getKeyBlob() {
        return this.keyBlob;
    }

    public DERSequence getProxyKeyBlobs() {
        return this.proxyKeyBlobs;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.keyBlob);
        if (this.proxyKeyBlobs != null) {
            v.add((ASN1Encodable)this.proxyKeyBlobs);
        }
        return new DERSequence(v);
    }
}

