/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TLSDelegateConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Delegate> delegateList = new LinkedList<Delegate>();
    private final GeneralDelegate generalDelegate;
    @Parameter(names={"-config"}, description="This parameter allows you to specify a default TlsConfig")
    private String defaultConfig = null;

    public TLSDelegateConfig(GeneralDelegate delegate) {
        this.generalDelegate = delegate;
        if (delegate != null) {
            this.delegateList.add(this.generalDelegate);
        }
    }

    public final void addDelegate(Delegate delegate) {
        this.delegateList.add(delegate);
    }

    public Delegate getDelegate(Class<? extends Delegate> delegateClass) {
        for (Delegate delegate : this.getDelegateList()) {
            if (!delegate.getClass().equals(delegateClass)) continue;
            return delegate;
        }
        return null;
    }

    public List<Delegate> getDelegateList() {
        return Collections.unmodifiableList(this.delegateList);
    }

    public GeneralDelegate getGeneralDelegate() {
        return this.generalDelegate;
    }

    public Config createConfig(Config baseConfig) {
        for (Delegate delegate : this.getDelegateList()) {
            delegate.applyDelegate(baseConfig);
        }
        return baseConfig;
    }

    public final boolean hasDifferentConfig() {
        return this.defaultConfig != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Config createConfig() {
        Config config = null;
        if (this.defaultConfig != null) {
            File configFile = new File(this.defaultConfig);
            if (!configFile.exists()) throw new ParameterException("Could not find config file: " + this.defaultConfig);
            config = Config.createConfig(configFile);
            return this.createConfig(config);
        } else {
            config = Config.createConfig();
        }
        return this.createConfig(config);
    }
}

